# -*- coding: utf-8 -*-


class CallBackMgr(object):
    """
    专门做路由管理
    """

    rule_map = None
    create_request_func_list = None
    before_request_func_list = None
    after_request_func_list = None
    teardown_request_func_list = None
    after_loop_func_list = None

    def __init__(self):
        self.rule_map = dict()
        self.create_request_func_list = []
        self.before_request_func_list = []
        self.after_request_func_list = []
        self.teardown_request_func_list = []
        self.after_loop_func_list = []

    def add_route_rule(self, endpoint=None, view_func=None, **options):
        assert view_func is not None, 'expected view func if endpoint is not provided.'

        endpoint = endpoint or view_func.__name__
        if endpoint in self.rule_map and view_func != self.rule_map[endpoint]:
            raise Exception, 'repeat view_func for endpoint: %(endpoint)s, old_view_func:%(old_view_func)s, new_view_func: %(new_view_func)s' % dict(
                endpoint=endpoint,
                old_view_func=self.rule_map[endpoint].__name__,
                new_view_func=view_func.__name__,
                )

        self.rule_map[endpoint] = view_func

    def route(self, **options):
        def decorator(f):
            endpoint = options.pop('endpoint', None)
            self.add_route_rule(endpoint, f, **options)
            return f
        return decorator

    def get_route_view_func(self, endpoint):
        return self.rule_map.get(endpoint)

    def create_request(self, f):
        """
        请求建立成功后
        """
        self.create_request_func_list.append(f)
        return f

    def before_request(self, f):
        """
        请求解析为json成功后
        """
        self.before_request_func_list.append(f)
        return f

    def after_request(self, f):
        """
        执行完route对应的view_func后
        """
        self.after_request_func_list.append(f)
        return f

    def teardown_request(self, f):
        """
        请求closed之后
        """
        self.teardown_request_func_list.append(f)
        return f

    def after_loop(self, f):
        """
        一次loop结束之后
        """
        self.after_loop_func_list.append(f)
        return f
