# gozerbot/channels.py
#
#

""" 
    channel related data. implemented with a persisted dict of dicts. 
    
    example: key = channels[event.channel]['key']

"""

__status__ = "seen"

## gozerbot imports

from persist.pdod import Pdod

## Channels class

class Channels(Pdod):

    """ channels class .. per channel data. """

    def __init__(self, fname):
        Pdod.__init__(self, fname)
        for j in self.data.values():
            if not j.has_key('perms'): j['perms'] = []
            if not j.has_key('autovoice'): j['autovoice'] = 0

    def __setitem__(self, a, b):
        if not self.data.has_key(a): self.data[a] = {}
        self.data[a] = b 

    def getchannels(self):
        """ return channels. """
        result = [] # list of channels found
        for channel in self.data.keys():
            channel = channel.strip()
            if channel not in result: result.append(channel)
        return result

    def getchannelswithkeys(self):
        """ return channels with keys. """
        result = []
        for channel in self.data.keys():
            channel = channel.strip()
            try:
                key = self.data[channel]['key']
                if not channel + ' ' + key in result: result.append(channel + ' ' + key)
            except KeyError:
                if channel not in result: result.append(channel)
        return result

    def getkey(self, channel):
        """ return key of channel if set. """
        try: return self.data[channel]['key']
        except: pass

    def getnick(self, channel):
        """ return bot nick of channel if set. """
        try: return self.data[channel]['nick']
        except: pass
