# gozerbot/ignore.py
#
#

""" ignore module. """

__status__ = "seen"

## gozerbot imports

from persist.persist import Persist
from datadir import datadir
from periodical import interval

## basic imports

import time
import os
import thread

## addignore function

def addignore(userhost, ttime):
    """ add ignore based on userhost .. record time when ignore is set. """
    global ignore
    ignore[userhost] = int(ttime)
    timeset[userhost] = time.time()
    
def delignore(userhost):
    """ remove ignore. """
    global ignore
    try:
        del ignore[userhost]
        del timeset[userhost]
        return True
    except KeyError: return False

def shouldignore(userhost):
    """ check if we should ignore. """
    try:
        ignoretime = ignore[userhost]
        ignoreset = timeset[userhost]
    except KeyError: return False
    if time.time() - ignoretime < ignoreset: return True
    return False


@interval(60)
def ignorecheck():
    """ periodic function to remove users that no longer need to be ignored. """
    for userhost in ignore.keys():
        if not shouldignore(userhost): delignore(userhost)

## defines

ignore = {}
timeset = {}

## start periodical 

ignorecheck()
