# gozerbot/monitor.py
#
#

""" monitors .. call callback on bot output. """

__status__ = "seen"

## gozerbot imports

from gozerbot.monitor import Monitor
from ircevent import Ircevent

## Outmonitor class

class Outmonitor(Monitor):

    """ monitor for bot output (bot.send). """

    def handle(self, bot, txt):
        """ fire outmonitor callbacks. """
        ievent = Ircevent().parse(bot, txt)
        if not ievent: rlog(10, 'monitor', "can't make ircevent: %s" % txt) ; return
        ievent.nick = bot.nick
        try: ievent.userhost = bot.userhosts.data[bot.nick]
        except KeyError: ievent.userhost = "bot@bot"
        Monitor.handle(self, bot, ievent)

## defines

outmonitor = Outmonitor('outmonitor') 
saymonitor = Monitor('saymonitor')
