# gozerbot/morphs.py
#
#

""" convert input/output stream. """

__status__ = "seen"

## gozerbot imports

from utils.exception import handle_exception
from utils.trace import calledfrom

## basic imports

import sys

## Morph class

class Morph(object):

    """ transform stream. """

    def __init__(self, func):
        self.plugname = calledfrom(sys._getframe(0))
        self.func = func
        self.activate = False

    def do(self, *args, **kwargs):
        """ do the morphing. """
        if not self.activate: return
        try: return self.func(*args, **kwargs)
        except Exception, ex: handle_exception()

## Morphg list

class MorphList(list):

    """ list of morphs. """

    def add(self, func, index=None):
        """ add morph. """
        if not index: self.append(Morph(func))
        else: self.insert(index, Moprh(func))
        return self

    def do(self, input, *args, **kwargs):
        """ call morphing chain. """
        for morph in self: input = morph.do(input, *args, **kwargs) or input
        return input

    def unload(self, plugname):
        """ unload morhps belonging to plug <plugname>. """
        for index in range(len(self)-1, -1, -1):
            if self[index].plugname == plugname: del self[index]

    def disable(self, plugname):
        """ disable morhps belonging to plug <plugname>. """
        for index in range(len(self)-1, -1, -1):
            if self[index].plugname == plugname: self[index].activate = False

    def activate(self, plugname):
        """ activate morhps belonging to plug <plugname>. """
        for index in range(len(self)-1, -1, -1):
            if self[index].plugname == plugname: self[index].activate = False

## defines

inputmorphs = MorphList()
outputmorphs = MorphList()
