# plugs/alias.py
#
#

""" 
    this alias plugin allows aliases for commands to be added. aliases are in
    the form of <alias> -> <command> .. aliases to aliases are not allowed

"""

__status__ = "seen"

## gozerbot imports

from gozerbot.aliases import aliasget, aliasdel, aliasset, aliases
from gozerbot.tests import tests, expect
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.plughelp import plughelp
from gozerbot.datadir import datadir

## basic imports

import os

## plughelp 

plughelp.add('alias', 'support for aliases')

## alias-search command

def handle_aliassearch(bot, ievent):
    """ <searchitem> - search aliases. """
    try: what = ievent.args[0]
    except IndexError: ievent.missing('<searchitem>') ; return
    result = []
    res = []
    for i, j in aliases.data.iteritems():
        if what in i or what in j: result.append((i, j))
    if not result: ievent.reply('no %s found' % what)
    else:
        for i in result: res.append("%s => %s" % i)
        ievent.reply("aliases matching %s: " % what, res, dot=True)

cmnds.add('alias-search', handle_aliassearch, 'USER')
examples.add('alias-search', 'search aliases',' alias-search web')
tests.add('alias-set mekker miep').add('alias-search mekker', 'miep').add('alias-del mekker')

## alias-set command

def handle_aliasset(bot, ievent):
    """ <from> <to> - set alias. """
    global aliases
    try: (aliasfrom, aliasto) = (ievent.args[0], ' '.join(ievent.args[1:]))
    except IndexError: ievent.missing('<from> <to>') ; return
    if not aliasto: ievent.missing('<from> <to>') ; return
    if aliases.data.has_key(aliasto): ievent.reply("can't alias an alias") ; return
    if cmnds.has_key(aliasfrom): ievent.reply('command with same name already exists.') ; return
    aliasset(aliasfrom, aliasto)
    aliases.save()
    ievent.reply('alias added')

cmnds.add('alias-set', handle_aliasset, 'OPER', allowqueue=False)
examples.add('alias-set', 'define alias', 'alias-set ll list')
aliasset('alias', 'alias-set')
tests.add('alias-set mekker2 list', 'alias added').add('mekker2', 'grep').add('alias-del mekker2')

## alias-del command

def handle_delalias(bot, ievent):
    """ <alias> - delete alias. """
    try: what = ievent.args[0]
    except IndexError: ievent.missing('<alias>') ; return
    if not aliasdel(what): ievent.reply('there is no %s alias' % what) ; return
    aliases.save()
    ievent.reply('alias deleted')

cmnds.add('alias-del', handle_delalias, 'OPER')
examples.add('alias-del', 'delete alias', 'alias-del ll')
tests.add('alias-set mekker3 miep').add('alias-del mekker3', 'alias deleted')

## alias-get command

def handle_getalias(bot, ievent):
    """ <alias> - show alias. """
    try: what = ievent.args[0]
    except IndexError: ievent.missing('<alias>') ; return
    alias = aliasget(what)
    if not alias: ievent.reply('there is no %s alias' % what) ; return
    ievent.reply(alias)

cmnds.add('alias-get', handle_getalias, 'USER')
examples.add('alias-get', 'get alias', 'alias-get v')
tests.add('alias-set mekker4 miep').add('alias-get mekker4', 'miep').add('alias-del mekker4')

## plugin initialisation

def init():
     """ initialise the alias plugin. """
     aliases.init()
