# plugs/jabber.py
#
#

""" jabber related commands. """

__status__ = "seen"

## gozerbot imports

from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.plughelp import plughelp
from gozerbot.xmpp.presence import Presence

## plughelp

plughelp.add('jabber', 'jabber specific commands')

## jabber-ratelimit command

def handle_jabberratelimit(bot, ievent):
    """ <ratelimit in seconds> - set jabber output limiter. """
    if not bot.jabber: ievent.reply('this command only works on a jabber bot') ; return 
    try: limit = int(ievent.args[0])
    except IndexError: ievent.reply('limiter is %s seconds' % bot.state['ratelimit']) ; return
    except ValueError: ievent.missing('<seconds>') ; return
    bot.state['ratelimit'] = limit
    ievent.reply('rate limiter set to %s' % limit)

cmnds.add('jabber-ratelimit', handle_jabberratelimit, 'OPER')
examples.add('jabber-ratelimit', 'limit jabber output', 'jabber-ratelimit 1')

## jabber-ircstr command

def handle_ircstr(bot, ievent):
    """ no arguments - show ircevent repr like string of jabbermessage. """
    if not bot.jabber: ievent.reply('this command only works on a jabber bot') ; return 
    ievent.reply(ievent.ircstr())

cmnds.add('jabber-ircstr', handle_ircstr, 'OPER')
examples.add('jabber-ircstr', 'show the given event as ircstr', 'jabber-ircstr')

## jabber-show command

def handle_show(bot, ievent):
    """ no arguments - send status stanza to server """
    if not bot.jabber: ievent.reply('this command only works on a jabber bot') ; return 
    try: bot.state['show'] = show = ievent.args[0]
    except IndexError: bot.state['show'] = show = ''
    bot.state.save()
    bot.sendpresence()

cmnds.add('jabber-show', handle_show, 'OPER')
examples.add('jabber-show', 'send status to the server', 'jabber-show away')

## jabber-imhere command

def handle_imhere(bot, ievent):
    """ no arguments - send presence stanza to server """
    if not bot.jabber: ievent.reply('this command only works on a jabber bot') ; return 
    bot.send(Presence({'type': 'available'}))

cmnds.add('jabber-imhere', handle_imhere, 'OPER')
examples.add('jabber-imhere', 'send presence to the server', 'jabber-imhere')

## jabber-status command

def handle_jabberstatus(bot, ievent):
    """ no arguments - set jabber status. """
    if not bot.jabber: ievent.reply('this command only works on a jabber bot') ; return 
    bot.state['status'] = ievent.rest
    bot.state.save()
    bot.sendpresence()

cmnds.add('jabber-status', handle_jabberstatus, 'OPER')
examples.add('jabber-status', 'set the status of the bot', 'jabber-status happy !!')
