# gozerplugs/mysqlkeepalive
#
#

""" mysql keepalive plugin. """

__status__ = "seen"

## gozerbot imports

from gozerbot.users import users
from gozerbot.utils.log import rlog
from gozerbot.threads.threadloop import ThreadSleeper
from gozerbot.config import config

## basic imports

import time

## PingLoop thread

class PingLoop(ThreadSleeper):

    """ This thread pings the mysql database every x seconds by calling the users.size() method. """

    def handle(self):
        users.size()
        rlog(10, 'mysqlkeepalive', 'pinged database')

pingloop = PingLoop(timeout=1800)

def init():
    if config['dbtype'] == 'mysql': pingloop.start()

def shutdown():
    if config['dbtype'] == 'mysql': pingloop.stop()
