# gozerbot/plugs/nickcapture.py
#
#

""" nick recapture callback. """

__status__ = "seen"

## gozerbot imports

from gozerbot.callbacks import callbacks
from gozerbot.plughelp import plughelp

## plughelp

plughelp.add('nickcapture', 'nickcapture takes a nick back if a user quits')

## ncaptest precondition

def ncaptest(bot, ievent):
    """ test if user is splitted. """
    if '*.' in ievent.txt or bot.server in ievent.txt: return 0
    if bot.orignick.lower() == ievent.nick.lower(): return 1
    return 0

## ncap callback

def ncap(bot, ievent):
    """ recapture the nick. """
    bot.donick(bot.orignick)

callbacks.add('QUIT', ncap, ncaptest, threaded=True)
