# gozerbot/plugs/underauth.py
#
#

""" handle non-ident connection on undernet. """

__author__ = 'aafshar@gmail.com'
__status__ = "seen"

# gozerbot imports

from gozerbot.callbacks import callbacks
from gozerbot.plughelp import plughelp

## plughelp

plughelp.add('underauth', 'provide callbacks that registers the bot with the undernet network')

## pre_underauth_cb precondition

def pre_underauth_cb(bot, ievent):
    """
        only respond to the message like:

        NOTICE AUTH :*** Your ident is disabled or broken, to continue
        to connect you must type /QUOTE PASS 16188

    """
    args = ievent.arguments
    try:
        return (args[0] == u'AUTH' and
                args[-3] == u'/QUOTE' and
                args[-2] == u'PASS')
    except Exception, ex: return 0

## underauth_cb callbacks

def underauth_cb(bot, ievent):
    """ send the raw command to the server. """
    # last two elements of the arguments list are PASS <id>
    bot._raw(' '.join(ievent.arguments[-2:]))

callbacks.add('NOTICE', underauth_cb, pre_underauth_cb)

#### BHJTW 21-01-2012
