# gozerbot/thr.py
#
#

""" own threading wrapper. """

__status__ = "seen"

## gozerbot imports

from gozerbot.stats import stats
from gozerbot.utils.exception import handle_exception
from gozerbot.utils.log import rlog
from gozerbot.utils.locking import lockdec
from gozerbot.config import config

## basic imports

import threading
import re
import time
import thread

## defines

dontshowthreads = ['Periodical.runjob', ]

methodre = re.compile('method\s+(\S+)', re.I)
funcre = re.compile('function\s+(\S+)', re.I)

## locks

threadlock = thread.allocate_lock()
locked = lockdec(threadlock)

## Botcommand class

class Botcommand(threading.Thread):

    """ thread for running bot commands. """

    def __init__(self, group, target, name, args, kwargs):
        threading.Thread.__init__(self, None, target, name, args, kwargs)
        self.name = name
        self.ievent = args[1]
        self.setDaemon(True)

    def run(self):
        """ run the bot command. """
        try:
            rlog(10, 'thr', 'running bot command thread %s' % self.name) 
            stats.up('threads', self.name)
            result = threading.Thread.run(self)
            if self.ievent.closequeue:
                rlog(4, 'thr', 'closing queue for %s' % self.ievent.userhost)
                for i in self.ievent.queues: i.put_nowait(None)
        except Exception, ex: handle_exception(self.ievent) ; time.sleep(0.1)

## Thr class

class Thr(threading.Thread):

    """ thread wrapper. """

    def __init__(self, group, target, name, args, kwargs):
        threading.Thread.__init__(self, None, target, name, args, kwargs)
        rlog(-14, 'thr', 'running %s .. args: %s' % (name, args))
        self.setDaemon(True)
        self.name = name
        time.sleep(0.001)

    def run(self):
        """ run the thread. """
        try:
            if self.name not in dontshowthreads: rlog(-4, 'thr', 'running thread %s' % self.name) 
            stats.up('threads', self.name)
            threading.Thread.run(self)
        except Exception, ex: handle_exception() ; time.sleep(1)

## getname function

def getname(func):
    """ get name of function/method. """
    name = ""
    method = re.search(methodre, str(func))
    if method: name = method.group(1)
    else:
        function = re.search(funcre, str(func))
        if function: name = function.group(1)
        else: name = str(func)
    return name

## start_new_thread function

def start_new_thread(func, arglist, kwargs=None):
    """ start a new thread .. set name to function/method name."""
    if not kwargs: kwargs = {}
    try:
        name = getname(func)
        if not name: name = 'noname'
        thread = Thr(None, target=func, name=name, args=arglist, kwargs=kwargs)
        rlog(-1, 'thr', 'starting %s thread' % str(func))
        thread.start()
        return thread
    except: handle_exception() ; time.sleep(1)

## start_bot_command function

def start_bot_command(func, arglist, kwargs={}):
    """ start a new thread .. set name to function/method name. """
    if not kwargs: kwargs = {}
    try:
        name = getname(func)
        if not name: name = 'noname'
        thread = Botcommand(group=None, target=func, name=name, args=arglist, kwargs=kwargs)
        rlog(-1, 'thr', 'starting %s thread' % str(func))
        thread.start()
        return thread
    except: handle_exception() ; time.sleep(1)

## threaded decorator

def threaded(func):
    """ threading decorator. """

    def threadedfunc(*args, **kwargs):
        start_new_thread(func, args, kwargs)

    return threadedfunc

#### BHJTW 22-01-2012
