# gozerbot/utils/lazydict.py
#
# thnx to maze

""" a lazydict allows dotted access to a dict .. dict.key """

__status__ = "seen"

## LazyDict class

class LazyDict(dict):

    """ Lazy dict allows dotted access to a dict """


    def __getattr__(self, attr, default={}):
        """ get attribute .. if not available init to default. """
        if not self.has_key(attr): self[attr] = default
        return self[attr]

    def __setattr__(self, attr, value):
        """ set attribute. """
        self[attr] = value

    def __str__(self):
        """ return a string representation of the dict """
        res = ""
        cp = dict(self)
        for item, value in cp.iteritems(): res += "%r=%r " % (item, value)
        return res

#### BHJTW 22-01-2012
