# gozerbot/utils/popen.py
#
#

""" popen helper functions """

__status__ = "seen"

## defines

go = False

## imports

try:
    from subprocess import Popen, PIPE
    from locking import lockdec
    import thread
    import StringIO
    import logging
    import types
    go = True
except: go = False

## teh stuff

if go:

    ## locks

    popenlock = thread.allocate_lock()
    popenlocked = lockdec(popenlock)

    ## PopenWhitelistError exception

    class PopenWhitelistError(Exception):

        def __init__(self, item):
            Exception.__init__(self)
            self.item = item
        
        def __str__(self):
            return self.item

    ## PoperListError exception

    class PopenListError(Exception):

        def __init__(self, item):
            Exception.__init__(self)
            self.item = item
        
        def __str__(self):
            return str(self.item)

    ## GozerStringIO class

    class GozerStringIO(StringIO.StringIO):

        def readlines(self):
            return self.read().split('\n')

    ## Gozerpopen4 class

    class Gozerpopen4(Popen):

        def __init__(self, args):
            Popen.__init__(self, args, shell=False, stdin=PIPE, stdout=PIPE, stderr=PIPE, close_fds=True)
            self.fromchild = self.stdout
            self.tochild   = self.stdin
            self.errors    = self.stderr

        def close(self):
            """ close the Popen instance. """
            self.wait()
            try: self.stdin.close()
            except: pass
            try: self.stdout.close()
            except: pass
            try: self.errors.close()
            except: pass
            return self.returncode

    def gozerpopen(args, userargs=[]):
        """ call popen via the Gozerpopen4 class. """
        if type(args) != types.ListType: raise PopenListError(args)
        if type(userargs) != types.ListType: raise PopenListError(args)
        for i in userargs:
            if i.startswith('-'): raise PopenWhitelistError(i)
        proces = Gozerpopen4(args + userargs)
        return proces

#### BHJTW 22-01-2012
