# plugs/quote.py
#
#

## still needs to be documented

__depend__ = ['karma', ]
__depending__ = ['grab', ]

from gozerbot.tests import tests
from gozerbot.persist.persist import Persist
from gozerbot.utils.nextid import nextid
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.datadir import datadir
from gozerbot.generic import lockdec, rlog, handle_exception
from gozerbot.plughelp import plughelp
from gozerbot.aliases import aliases
from gozerbot.config import config
from gplugs.alchemy.karma import karma
import random, re, time, thread, os, types

from gozerbot.database.alchemy import Base, create_all, query, Session, dblocked
from datetime import datetime
from time import localtime   
from sqlalchemy import Column, String, Integer, Text, DateTime, ForeignKey, Sequence
import sqlalchemy as sa

class Quotes(Base):
    __tablename__ = 'quotes'
    __table_args__ = {'useexisting': True }
    #indx = Column('indx', Integer, Sequence('quotes_indx_seq'), primary_key=True)
    indx = Column('indx', Integer, primary_key=True)
    quote = Column('quote', Text, nullable=False)
    userhost = Column('userhost', String(255), ForeignKey('userhosts.userhost'), nullable=False)
    createtime = Column('createtime', DateTime, nullable=False)
    nick = Column('nick', String(255), nullable=False)

    def __init__(self, quote, userhost, createtime, nick):
        self.quote = quote
        self.userhost = userhost
        self.createtime = createtime
        self.nick = nick

plughelp.add('quote', 'manage quotes')

class QuotesDb(object):

    """ quotes db interface """

    def size(self):
        """ return number of items """
        count = query(sa.func.count(Quotes.indx)).first()[0]
        return count

    @dblocked
    def add(self, nick, userhost, q, ttime=None):
        """ add a quote """
        #Session.begin()
        if ttime:
            try:
                ttime = float(ttime)
            except TypeError:
                pass
            t = datetime.fromtimestamp(ttime)
        else: 
            t = datetime.now()
        quote = Quotes(q, userhost, t, nick)
        Session.add(quote)
        #Session.flush()
        #idnr = quote.indx
        return quote

    @dblocked
    def delete(self, quotenr):
        #Session.begin()
        quote = Session.query(Quotes).filter(Quotes.indx==quotenr).first()
        if quote:
             Session.delete(quote)
             #Session.commit()
             #Session.close()
             return 1

    def random(self):
        """ get random quote """
        result = query(Quotes.indx).all()
        indices = []
        if not result:
            return 
        for i in result:
            if i[0]: indices.append(i[0])
        if indices:
            idnr = random.choice(indices)
            return self.idquote(str(idnr))

    def idquote(self, quotenr):
        """ get quote by id """
        quotenr = str(quotenr)
        quote = query(Quotes).filter(Quotes.indx==quotenr).first()
        if quote:
            return quote

    def whoquote(self, quotenr):
        """ get who quoted the quote """
        quotenr = str(quotenr)
        quote = query(Quotes).filter(Quotes.indx==quotenr).first()
        if quote:
            return quote

    def last(self, nr=1):
        """ get last quote """ 
        result = query(Quotes).order_by(Quotes.indx.desc()).limit(nr)
        if result:
            return result

    def search(self, what):
        """ search quotes """
        result = query(Quotes).filter(Quotes.quote.like('%%%s%%' % what)).all()
        if result:
            return result

    def searchlast(self, what, nr):
        """ search quotes """
        result = query(Quotes).filter(Quotes.quote.like('%%%s%%' % what)).order_by(Quotes.indx.desc()).limit(nr)
        if result:
            return result

quotes = QuotesDb()
assert(quotes)

def init():
    create_all('quote')


def size():
    """ return number of quotes """
    return quotes.size()

def search(what, queue):
    """ search the quotes """
    rlog(10, 'quote', 'searched for %s' % what)
    result = quotes.search(what)
    if result:
        for i in result:
            queue.put_nowait("#%s %s" % (i.indx, i.quote))

def handle_quoteadd(bot, ievent):
    """ quote-add <txt> .. add a quote """
    if not ievent.rest:
        ievent.missing("<quote>")
        return
    idnr = quotes.add(ievent.nick, ievent.userhost, ievent.rest)
    ievent.reply('quote %s added' % idnr)

cmnds.add('quote-add', handle_quoteadd, ['USER', 'QUOTEADD'], allowqueue=False, threaded=True)
examples.add('quote-add', 'quote-add <txt> .. add quote', 'quote-add mekker')
aliases.data['aq'] = 'quote-add'
tests.add('quote-add mekker','quote (\d+) added')

def handle_quotewho(bot, ievent):
    """ quote-who <nr> .. show who added a quote """
    try:
        quotenr = int(ievent.args[0])
    except IndexError:
        ievent.missing("<nr>")
        return
    except ValueError:
        ievent.reply("argument must be an integer")
        return
    result = quotes.whoquote(quotenr)
    if not result:
        ievent.reply('no who quote data available')
        return
    if result.createtime:
        if type(result.createtime) == types.LongType:
            ievent.reply('quote #%s was made by %s on %s' % (quotenr, \
result.nick, datetime.fromtimestamp(result.createtime).ctime()))
        else:
            ievent.reply('quote #%s was made by %s on %s' % (quotenr, \
result.nick, result.createtime.ctime()))
    else:
        ievent.reply('quote #%s was made by %s' % (quotenr, result.nick))

cmnds.add('quote-who', handle_quotewho, ['USER', 'WEB', 'CLOUD', 'ANONQUOTE'])
examples.add('quote-who', 'quote-who <nr> .. show who quote <nr>', \
'quote-who 1')
aliases.data['wq'] = 'quote-who'
tests.add('quote-who 1', 'quote #(\d+) was made by (\S+)')

def handle_quotedel(bot, ievent):
    """ quote-del <nr> .. delete quote by id """
    try:
        quotenr = int(ievent.args[0])
    except IndexError:
        ievent.missing('<nr>')
        return
    except ValueError:
        ievent.reply('argument needs to be an integer')
        return
    if quotes.delete(quotenr):
        ievent.reply('quote %s deleted' % quotenr)
    else:
        ievent.reply("can't delete quote with nr %s" % quotenr)

cmnds.add('quote-del', handle_quotedel, ['QUOTEDEL', 'OPER', 'QUOTE'])
examples.add('quote-del', 'quote-del <nr> .. delete quote', 'quote-del 2')
aliases.data['dq'] = 'quote-del'
tests.add('quote-add mekker', 'quote (\d+)').add('quote-del %s', 'quote %s deleted')

def handle_quotelast(bot, ievent):
    """ quote-last .. show last quote """
    search = ""
    try:
        (nr, search) = ievent.args
        nr = int(nr)  
    except ValueError:
        try:
            nr = ievent.args[0]
            nr = int(nr)
        except (IndexError, ValueError):
            nr = 1
            try:
                search = ievent.args[0]
            except IndexError:
                search = ""
    if nr < 1 or nr > 4:
        ievent.reply('nr needs to be between 1 and 4')
        return
    search = re.sub('^d', '', search)
    if search:
        quotelist = quotes.searchlast(search, nr)
    else:
        quotelist = quotes.last(nr)
    if quotelist != None:
        for quote in quotelist:
            try:
                qkarma = karma.get('quote %s' % quote.indx)
                if qkarma:
                    ievent.reply('#%s (%s) %s' % (quote.indx, qkarma, quote.quote))
                else:
                    ievent.reply('#%s %s' % (quote.indx, quote.quote))
            except AttributeError:
                    ievent.reply('#%s %s' % (quote.indx, quote.quote))
    else:
        ievent.reply("can't fetch quote")

cmnds.add('quote-last', handle_quotelast, ['USER', 'WEB', 'ANONQUOTE', 'CLOUD'])
examples.add('quote-last', 'show last quote', 'quote-last')
aliases.data['lq'] = 'quote-last'
tests.add('quote-last', '#(\d+)')

def handle_quote2(bot, ievent):
    """ quote-2 .. show 2 random quotes """
    quote = quotes.random()
    if quote:
        qkarma = karma.get('quote %s' % quote.indx)
        if qkarma:
            ievent.reply('#%s (%s) %s' % (quote.indx, qkarma, quote.quote))
        else:
            ievent.reply('#%s %s' % (quote.indx, quote.quote))
    else:
        ievent.reply('no quotes yet')
        return
    quote = quotes.random()
    if quote:
        qkarma = karma.get('quote %s' % quote.indx)
        if qkarma:
            ievent.reply('#%s (%s) %s' % (quote.indx, qkarma, quote.quote))
        else:
            ievent.reply('#%s %s' % (quote.indx, quote.quote))

cmnds.add('quote-2', handle_quote2, ['USER', 'WEB', 'ANONQUOTE', 'CLOUD'])
examples.add('quote-2', 'quote-2 .. show 2 random quotes', 'quote-2')
aliases.data['2q'] = 'quote-2'
tests.add('quote-2', '#(\d+)')
aliases.data['3q'] = "quote && quote && quote"

def handle_quoteid(bot, ievent):
    """ quote-id <nr> .. show quote by id """
    try:
        quotenr = int(ievent.args[0])
    except IndexError:
        ievent.missing('<nr>')
        return
    except ValueError:
        ievent.reply('argument must be an integer')
        return
    quote = quotes.idquote(quotenr)
    if quote:
        qkarma = karma.get('quote %s' % quote.indx)
        if qkarma:
            ievent.reply('#%s (%s) %s' % (quote.indx, qkarma, quote.quote))
        else:
            ievent.reply('#%s %s' % (quote.indx, quote.quote))
    else:
        ievent.reply("can't fetch quote with id %s" % quotenr)

cmnds.add('quote-id', handle_quoteid, ['USER', 'WEB', 'ANONQUOTE', 'CLOUD'])
examples.add('quote-id', 'quote-id <nr> .. get quote <nr>', 'quote-id 2')
aliases.data['iq'] = 'quote-id'
tests.add('quote-id 1', '#(\d+)')

def handle_quote(bot, ievent):
    """ quote .. show random quote """
    quote = quotes.random()
    if quote:
        qkarma = karma.get('quote %s' % quote.indx)
        if qkarma:
            ievent.reply('#%s (%s) %s' % (quote.indx, qkarma, quote.quote))
        else:
            ievent.reply('#%s %s' % (quote.indx, quote.quote))
    else:
        ievent.reply('no quotes yet')

cmnds.add('quote', handle_quote, ['USER', 'WEB', 'ANONQUOTE', 'CLOUD'])
examples.add('quote', 'show random quote', 'quote')
aliases.data['q'] = 'quote'
tests.add('quote', '#(\d+)')

def handle_quotesearch(bot, ievent):
    """ quote-search <txt> .. search quotes """
    if not ievent.rest:
        ievent.missing('<item>')
        return
    else:
        what = ievent.rest
        nrtimes = 3
    result = quotes.search(what)
    if result:
        if ievent.queues:
            res = []
            for quote in result:
                res.append('#%s %s' % (quote.indx, quote.quote))
            ievent.reply(res)
            return            
        if nrtimes > len(result):
            nrtimes = len(result)
        randquotes = random.sample(result, nrtimes)
        for quote in randquotes:
            qkarma = karma.get('quote %s' % quote.indx)
            if qkarma:
                ievent.reply('#%s (%s) %s' % (quote.indx, qkarma, quote.quote))
            else:
                ievent.reply("#%s %s" % (quote.indx, quote.quote))
    else:
        ievent.reply('no quotes found with %s' % what)

cmnds.add('quote-search', handle_quotesearch, ['USER', 'WEB', \
'ANONQUOTE', 'CLOUD'])
examples.add('quote-search', 'quote-search <txt> .. search quotes for <txt>'\
, 'quote-search bla')
aliases.data['sq'] = 'quote-search'
tests.add('quote-add gozerbot is tof').add('quote-search gozerbot', 'tof')

def handle_quotescount(bot, ievent):
    """ quote-count .. show number of quotes """
    ievent.reply('quotes count is %s' % quotes.size())

cmnds.add('quote-count', handle_quotescount, ['USER', 'WEB', \
'ANONQUOTE', 'CLOUD'])
examples.add('quote-count', 'count nr of quotes', 'quote-count')
aliases.data['cq'] = 'quote-count'
tests.add('quote-count', 'quotes count is (\d+)')

def handle_quotegood(bot, ievent):
    """ show top ten positive karma """
    result = karma.quotegood(limit=10)
    if result:
        resultstr = ""
        for i in result:
            if i[1] > 0:
                resultstr += "%s: %s " % (i[0], i[1])
        ievent.reply('quote goodness: %s' % resultstr)
    else:
        ievent.reply('quote karma void')

cmnds.add('quote-good', handle_quotegood, ['USER', 'WEB', 'ANONQUOTE', 'CLOUD'])
examples.add('quote-good', 'show top 10 quote karma', 'quote-good')
tests.add('quote 1++').add('quote-good', 'quote goodness')

def handle_quotebad(bot, ievent):
    """ show top ten negative karma """
    result = karma.quotebad(limit=10)
    if result:
        resultstr = ""
        for i in result:
            if i[1] < 0:
                resultstr += "%s: %s " % (i[0], i[1])
        ievent.reply('quote badness: %s' % resultstr)
    else:
        ievent.reply('quote karma void')

cmnds.add('quote-bad', handle_quotebad, ['USER', 'WEB', 'ANONQUOTE', 'CLOUD'])
examples.add('quote-bad', 'show lowest 10 quote karma', 'quote-bad')
tests.add('quote 2--').add('quote-bad', 'quote badness')
