# plugs/todo.py
#
#

""" manage todo lists .. by user or by channel .. a time/data string can 
 be provided to set time on a todo item.
"""

## still needs to be documented

from gozerbot.generic import strtotime, striptime, getwho, today, lockdec, \
handle_exception, rlog
from gozerbot.tests import tests
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.users import users
from gozerbot.datadir import datadir
from gozerbot.persist.persist import PlugPersist
from gozerbot.plughelp import plughelp
from gozerbot.aliases import aliases
from gozerbot.config import config
from gplugs.alarm import alarms
import time, thread, os

from datetime import datetime, timedelta
from time import localtime

try:
    from gozerbot.database.alchemy import Base, create_all, byname, query, Session, dblocked
    from sqlalchemy import Column, String, Integer, Text, DateTime, ForeignKey, Sequence
    import sqlalchemy as sa

    class Todo(Base):
        __tablename__ = 'todo'
        __table_args__ = {'useexisting': True}
        indx = Column('indx', Integer, primary_key=True)
        name = Column('name', String(255), nullable=False)
        time = Column('time', DateTime)
        duration = Column('duration', Integer)
        warnsec = Column('warnsec', Integer)
        descr = Column('descr', Text, nullable=False)
        priority = Column('priority', Integer)

        def __init__(self, name, time, duration, warnsec, descr, priority):
            self.name = name
            self.time = time
            self.duration = duration
            self.warnsec = warnsec
            self.descr = descr
            self.priority = priority

except:
    def trans(func, *args, **kwargs):
        def transaction(*args, **kwargs):
            func(*args, **kwargs)
        return transaction

if config['GAE']:
    from google.appengine.ext import db

    class GAETodo(db.Expando):

       indx = db.IntegerProperty()
       name = db.StringProperty(required=True)
       time = db.DateProperty()
       duration = db.IntegerProperty()
       warnsec = db.IntegerProperty()
       descr = db.StringProperty(required=True)
       priority = db.IntegerProperty()


plughelp.add('todo', 'todo lists')

todolock = thread.allocate_lock()
locked = lockdec(todolock)

class TodoDb(object):

    """ database todo interface """

    @dblocked
    def reset(self, name): 
        #Session.begin()
        item = Session.query(Todo).filter(Todo.name==name.lower()).first()
        Session.delete(item)
        #Session.commit()
        #Session.close()
        return 1

    def size(self):
        """ return number of todo's """
        count = Session.query(sa.func.count(Todo.indx)).first()[0]
        return count 
        
    def get(self, name):
        """ get todo list of <name> """
        name = name.lower()
        print name
        prio = Todo.priority.desc()
        print prio
        result = Session.query(Todo).filter(Todo.name==name).order_by(prio).all()
        return result

    def getid(self, idnr):
        """ get todo data of <idnr> """
        result = Session.query(Todo).filter(Todo.indx==idnr).first()
        return result

    def setprio(self, who, todonr, prio):
        """ set priority of todonr """
        #Session.begin()
        item = Session.query(Todo).filter(Todo.indx==todonr).first()
        if item:
            item.priority = prio
            #Session.commit()
            #Session.close()
            return 1

    def getprio(self, todonr):
        """ get priority of todonr """
        result =  Session.query(Todo).filter(Todo.indx==todonr).first()
        if result:
            return result.priority

    def getwarnsec(self, todonr):
        """ get priority of todonr """
        result = Session.query(Todo).filter(Todo.indx==todonr).first()
        return result

    def settime(self, who, todonr, ttime):
        """ set time of todonr """
        item = Session.query(Todo).filter(Todo.indx==todonr).first()
        if item:
            #Session.begin()
            item.time = datetime.fromtimestamp(ttime)
            #Session.commit()
            Session.refresh(item)
            #Session.close()
            return 1

    def add(self, name, txt, ttime=0, duration=0, warnsec=0, priority=0, alarmnr=None):
        """ add a todo """
        name = name.lower()
        txt = txt.strip()
        #Session.begin()
        if not ttime:
            if config['dbtype'] == 'mysql':
                todo = Todo(name, 0, duration, warnsec, txt, priority)
            else:
                todo = Todo(name, datetime.min, duration, warnsec, txt, priority)
            Session.add(todo)
        else:
            todo = Todo(name, datetime.fromtimestamp(ttime), duration, warnsec, txt, priority)
            Session.add(todo)
        #Session.commit()
        #idnr = todo.indx
        #Session.close()
        #return idnr

    def delete(self, name, indexnr):
        """ delete todo item """
        name = name.lower()
        try:
            warnsec = self.getwarnsec(indexnr)[0][0]
            if warnsec:
                alarmnr = 0 - warnsec
                if alarmnr > 0:
                    alarms.delete(alarmnr)
        except (IndexError, TypeError):
            pass
        item = Session.query(Todo).filter(Todo.name==name and Todo.indx==indexnr).first()
        if item:
            #Session.begin()
            Session.delete(item)
            #Session.close()
            return 1

    def toolate(self, name):
        """ show if there are any time related todoos that are too late """
        items = Session.query(Todo).filter(Todo.name==name.lower()).filter(Todo.time<datetime.now()).all()
        return items

    def withintime(self, name, time1, time2):
        """ show todo list within time frame """
        name = name.lower()
        items = Session.query(Todo).filter(Todo.name==name.lower()).filter(Todo.time>datetime.fromtimestamp(time1)).filter(Todo.time<datetime.fromtimestamp(time2)).all()
        return items

    def timetodo(self, name):
        name = name.lower()
        if 'mysql' in config['dbtype']:
            items = Session.query(Todo).filter(Todo.name==name.lower()).filter(Todo.time>0).all()
        else:
            items = Session.query(Todo).filter(Todo.name==name.lower()).filter(Todo.time>datetime.min).all()
        return items

todo = TodoDb()
create_all('todo')

assert(todo)

def size():
    """ return number of todo entries """
    return todo.size()

def handle_todo(bot, ievent):
    """ todo [<item>] .. show todo's or set todo item .. a time/date can be \
given"""
    if len(ievent.args) > 0:
        handle_todo2(bot, ievent)
        return
    name = users.getname(ievent.userhost)
    if not name:
        ievent.reply("can't find username for %s" % ievent.userhost)
        return
    try:
        todoos = todo.get(name)
    except KeyError:
        ievent.reply('i dont have todo info for %s' % user.name)
        return
    saytodo(bot, ievent, todoos)

def handle_todo2(bot, ievent):
    """ set todo item """
    if not ievent.rest:
        ievent.missing("<what>")
        return
    else:
        what = ievent.rest
    name = users.getname(ievent.userhost)
    if not name:
        ievent.reply("can't find username for %s" % ievent.userhost)
        return
    ttime = strtotime(what)
    nr = 0
    if not ttime == None:
        ievent.reply('time detected ' + time.ctime(ttime))
        nr = todo.add(name, what, ttime)
        what = "#%s %s" % (nr, striptime(what))
        alarmnr = alarms.add(bot.name, ievent.nick, ttime, what)
    else:
        nr = todo.add(name, what)
    ievent.reply('todo item %s added' % nr)

cmnds.add('todo', handle_todo, 'USER')
examples.add('todo', 'todo [<item>] .. show todo items or add a todo item', \
'1) todo 2) todo program the bot 3) todo 22:00 sleep')
tests.add('todo program the bot').add('todo', 'program the bot')

def handle_tododone(bot, ievent):
    """ todo-done <listofnrs> .. remove todo items """
    if len(ievent.args) == 0:
        ievent.missing('<list of nrs>')
        return
    try:
        nrs = []
        for i in ievent.args:
            nrs.append(int(i))
    except ValueError:
        ievent.reply('%s is not an integer' % i)
        return
    name = users.getname(ievent.userhost)
    if not name:
        ievent.reply("can't find username for %s" % ievent.userhost)
        return
    nrdone = 0
    failed = []
    for i in nrs:
        try:
            todo.delete(name, i)
            nrdone += 1
        except Exception, ex:
            failed.append(str(i))
            handle_exception()
    if failed:
        ievent.reply('failed to delete %s' % ' .. '.join(failed))
    if nrdone == 1:
        ievent.reply('%s item deleted' % nrdone)
    elif nrdone == 0:
        ievent.reply('no items deleted')
    else:
        ievent.reply('%s items deleted' % nrdone)

cmnds.add('todo-done', handle_tododone, 'USER')
examples.add('todo-done', 'todo-done <listofnrs> .. remove items from \
todo list', '1) todo-done 1 2) todo-done 3 5 8')
aliases.data['done'] = 'todo-done'
tests.add('todo program the bot', 'todo item (\d+) added').add('todo-done %s', '(\d+) item deleted')

def handle_chantodo(bot, ievent):
    """ todo-chan [<item>] .. show channel todo's or set todo item for \
channel"""
    if ievent.rest:
        handle_chantodo2(bot, ievent)
        return
    todoos = todo.get(ievent.channel)
    saytodo(bot, ievent, todoos)

def handle_chantodo2(bot, ievent):
    """ set todo item for channel"""
    what = ievent.rest
    ttime = strtotime(what)
    nr = 0
    if not ttime  == None:
        ievent.reply('time detected ' + time.ctime(ttime))
        what = striptime(what)
        nr = todo.add(ievent.channel, what, ttime)
        result = '#%s (%s) %s' % (nr, ievent.nick, what)
        alarmnr = alarms.add(bot.name, ievent.channel, ttime, result)
    else:
        result = '(%s) ' % ievent.nick + what
        nr = todo.add(ievent.channel, result, 0)
    ievent.reply('todo item %s added' % nr)

cmnds.add('todo-chan', handle_chantodo, 'USER')
examples.add('todo-chan', 'todo-chan [<item>] .. add channel todo', \
'todo-chan fix bla')
aliases.data['chantodo'] = 'todo-chan'
tests.add('todo-chan program the bot', 'todo item (\d+) added').add('todo-chan', 'program the bot')

def handle_todochandone(bot, ievent):
    """ todo-chandone <listofnrs> .. remove channel todo item """
    if not ievent.rest:
        ievent.missing('<list of nrs>')
        return
    data = ievent.rest.split()
    try:
        nrs = []
        for i in data:
            nrs.append(int(i))
    except ValueError:
        ievent.reply('%s is not an integer' % i)
        return
    nrdone = 0
    failed = []
    for i in nrs:
        try:
            if todo.delete(ievent.channel, i):
                nrdone += 1
        except Excpetion, ex:
            failed.append(i)
            handle_exception()
    if failed:
        ievent.reply('failed to delete %s' % ' .. '.join(failed))
    if nrdone == 1:
        ievent.reply('%s item deleted' % nrdone)
    elif nrdone == 0:
        ievent.reply('no items deleted')
    else:
        ievent.reply('%s items deleted' % nrdone)

cmnds.add('todo-chandone', handle_todochandone, 'USER')
examples.add('todo-chandone', 'todo-chandone <listofnrs> .. remove item \
from channel todo list', 'todo-chandone 2')
aliases.data['chandone'] = 'todo-chandone'
tests.add('todo-chan program the bot', 'todo item (\d+) added').add('todo-chandone %s', '(\d+) item deleted')

def handle_settodo(bot, ievent):
    """ todo-set <name> <txt> .. add a todo to another user's todo list"""
    try:
        who = ievent.args[0]
        what = ' '.join(ievent.args[1:])
    except IndexError:
        ievent.missing('<nick> <what>')
        return
    if not what:
        ievent.missing('<nick> <what>')
        return
    userhost = getwho(bot, who)
    if not userhost:
        ievent.reply("can't find userhost for %s" % who)
        return
    whouser = users.getname(userhost)
    if not whouser:
        ievent.reply("can't find user for %s" % userhost)
        return
    name = users.getname(ievent.userhost)
    if not name:
        ievent.reply("can't find username for %s" % ievent.userhost)
        return
    if not users.permitted(userhost, name, 'todo'):
        ievent.reply("%s doesn't permit todo sharing for %s " % \
(who, name))
        return
    what = "%s: %s" % (ievent.nick, what)
    ttime = strtotime(what)
    nr = 0
    if not ttime  == None:
        ievent.reply('time detected ' + time.ctime(ttime))
        what = striptime(what)
        nr = todo.add(whouser, what, ttime)
        what = "#%s %s" % (nr, what)
        alarmnr = alarms.add(bot.name, who, ttime, what)
    else:
        nr = todo.add(whouser, what, 0)
    ievent.reply('todo item %s added' % nr)

cmnds.add('todo-set', handle_settodo, 'USER')
examples.add('todo-set', 'todo-set <nick> <txt> .. set todo item of \
<nick>', 'todo-set dunker bot proggen')
tests.add('user-addpermit owner todo').add('todo-set {{ me }} program the bot', 'todo item (\d+) added')

def handle_gettodo(bot, ievent):
    """ todo-get <nick> .. get todo of another user """
    try:
        who = ievent.args[0]
    except IndexError:
        ievent.missing('<nick>')
        return
    userhost = getwho(bot, who)
    if not userhost:
        ievent.reply("can't find userhost for %s" % who)
        return
    whouser = users.getname(userhost)
    if not whouser:
        ievent.reply("can't find user for %s" % userhost)
        return
    name = users.getname(ievent.userhost)
    if not name:
        ievent.reply("can't find username for %s" % ievent.userhost)
        return
    if not users.permitted(userhost, name, 'todo'):
        ievent.reply("%s doesn't permit todo sharing for %s " % (who, name))
        return
    todoos = todo.get(whouser)
    saytodo(bot, ievent, todoos)

cmnds.add('todo-get', handle_gettodo, ['USER', 'WEB'])
examples.add('todo-get', 'todo-get <nick> .. get the todo list of \
<nick>', 'todo-get dunker')
tests.add('todo program the bot').add('todo-get {{ me }}', 'program the bot')

def handle_todotime(bot, ievent):
    """ todo-time .. show time related todoos """
    name = users.getname(ievent.userhost)
    if not name:
        ievent.reply("can't find username for %s" % ievent.userhost)
        return
    todoos = todo.timetodo(name)
    saytodo(bot, ievent, todoos)

cmnds.add('todo-time', handle_todotime, 'USER')
examples.add('todo-time', 'todo-time .. show todo items with time fields', \
'todo-time')
aliases.data['tt'] = 'todo-time'
tests.add('todo 11-11-2011 test', 'time detected').add('todo-time', 'test')

def handle_todoweek(bot, ievent):
    """ todo-week .. show time related todo items for this week """
    name = users.getname(ievent.userhost)
    if not name:
        ievent.reply("can't find username for %s" % ievent.userhost)
        return
    todoos = todo.withintime(name, today(), today()+7*24*60*60)
    saytodo(bot, ievent, todoos)

cmnds.add('todo-week', handle_todoweek, 'USER')
examples.add('todo-week', 'todo-week .. todo items for this week', 'todo-week')
tests.add('tomorrow test the bot').add('todo-week', 'test the bot')

def handle_today(bot, ievent):
    """ todo-today .. show time related todo items for today """
    name = users.getname(ievent.userhost)
    if not name:
        ievent.reply("can't find username for %s" % ievent.userhost)
        return
    todoos = todo.withintime(name, today(), today()+24*60*60)
    saytodo(bot, ievent, todoos)

cmnds.add('todo-today', handle_today, 'USER')
examples.add('todo-today', 'todo-today .. todo items for today', 'todo-today')
aliases.data['today'] = 'todo-today'
tests.add('todo test the bot').add('todo-today', 'test the bot')

def handle_tomorrow(bot, ievent):
    """ todo-tomorrow .. show time related todo items for tomorrow """
    username = byname(ievent.userhost)
    if not username:
        ievent.reply("can't find username for %s" % ievent.userhost)
        return
    if ievent.rest:
        what = ievent.rest
        ttime = strtotime(what)
        if ttime != None:
            if ttime < today() or ttime > today() + 24*60*60:
                ievent.reply("%s is not tomorrow" % \
time.ctime(ttime + 24*60*60))
                return
            ttime += 24*60*60
            ievent.reply('time detected ' + time.ctime(ttime))
            what = striptime(what)
        else:
            ttime = today() + 42*60*60
        todo.add(username, what, ttime)   
        ievent.reply('todo added')    
        return
    todoos = todo.withintime(username, today()+24*60*60, today()+2*24*60*60)
    saytodo(bot, ievent, todoos)

cmnds.add('todo-tomorrow', handle_tomorrow, 'USER')
examples.add('todo-tomorrow', 'todo-tomorrow .. todo items for tomorrow', \
'todo-tomorrow')
aliases.data['tomorrow'] = 'todo-tomorrow'
tests.add('todo-tomorrow test the bot').add('todo-time', 'test the bot')

def handle_setpriority(bot, ievent):
    """ todo-setprio [<channel|name>] <itemnr> <prio> .. show priority \
        on todo item """
    try:
        (who, itemnr, prio) = ievent.args
    except ValueError:
        try:
            (itemnr, prio) = ievent.args
            who = users.getname(ievent.userhost)
        except ValueError:
            ievent.missing('[<channe|namel>] <itemnr> <priority>')
            return
    if not who:
        ievent.reply("can't find username for %s" % ievent.userhost)
        return
    try:
        itemnr = int(itemnr)
        prio = int(prio)
    except ValueError:
        ievent.missing('[<channel|name>] <itemnr> <priority>')
        return
    who = who.lower()
    todo.setprio(who, itemnr, prio)
    ievent.reply('priority set')

cmnds.add('todo-setprio', handle_setpriority, 'USER')
examples.add('todo-setprio', 'todo-setprio [<channel|name>] <itemnr> <prio> \
.. set todo priority', '1) todo-setprio #dunkbots 2 5 2) todo-setprio owner \
3 10 3) todo-setprio 2 10')
aliases.data['setprio'] = 'todo-setprio'
tests.add('todo test the bot', 'todo item (\d+) added').add('todo-setprio %s 10', 'priority set')

def handle_todosettime(bot, ievent):
    """ todo-settime [<channel|name>] <itemnr> <timestring> .. set time \
        on todo item """
    ttime = strtotime(ievent.rest)
    if ttime == None:
        ievent.reply("can't detect time")
        return   
    txt = striptime(ievent.rest)
    try:
        (who, itemnr) = txt.split()
    except ValueError:
        try:
            (itemnr, ) = txt.split()
            who = users.getname(ievent.userhost)
        except ValueError:
            ievent.missing('[<channel|name>] <itemnr> <timestring>')
            return
    if not who:
        ievent.reply("can't find username for %s" % ievent.userhost)
        return
    try:
        itemnr = int(itemnr)
    except ValueError:
        ievent.missing('[<channel|name>] <itemnr> <timestring>')
        return
    who = who.lower()
    if not todo.settime(who, itemnr, ttime):
        ievent.reply('no todo %s found for %s' % (itemnr, who))
        return
    ievent.reply('time of todo %s set to %s' % (itemnr, time.ctime(ttime)))

cmnds.add('todo-settime', handle_todosettime, 'USER')
examples.add('todo-settime', 'todo-settime [<channel|name>] <itemnr> \
<timestring> .. set todo time', '1) todo-settime #dunkbots 2 13:00 2) \
todo-settime owner 3 2-2-2010 3) todo-settime 2 22:00')
tests.add('todo test the bot', 'todo item (\d+) added').add('todo-settime %s 11:00', 'time of todo %s set')

def handle_getpriority(bot, ievent):
    """ todo-getprio <[channel|name]> <itemnr> .. get priority of todo \
        item """
    try:
        (who, itemnr) = ievent.args
    except ValueError:
        try:
            itemnr = ievent.args[0]
            who = users.getname(ievent.userhost)
        except IndexError:
            ievent.missing('[<channel|name>] <itemnr>')
            return
    if not who:
        ievent.reply("can't find username for %s" % ievent.userhost)
        return
    try:
        itemnr = int(itemnr)
    except ValueError:
        ievent.missing('[<channel|name>] <itemnr>')
        return
    who = who.lower()
    prio = todo.getprio(itemnr)
    ievent.reply('priority is %s' % prio)

cmnds.add('todo-getprio', handle_getpriority, 'USER')
examples.add('todo-getprio', 'todo-getprio [<channel|name>] <itemnr> .. get \
todo priority', '1) todo-getprio #dunkbots 5 2) todo-getprio 3')
aliases.data['prio'] = 'todo-getprio'
tests.add('todo test the bot', 'todo item (\d+) added').add('todo-getprio %s', 'priority is 0')

def saytodo(bot, ievent, todoos):
    """ output todo items of <name> """
    result = []
    now = datetime.now()
    if not todoos:
        ievent.reply('nothing todo ;]')
        return
    for i in todoos:
        res = ""
        res += "%s) " % i.indx
        if i.priority:
            res += "[%s] " % i.priority
        if i.time and not i.time == i.time.min:
            if i.time < now:
                res += 'TOO LATE: '
            res += "%s %s " % (i.time.ctime(), i.descr)
        else:
            res += "%s " % i.descr
        result.append(res.strip())
    if result:
        ievent.reply("todolist of %s: " % ievent.nick, result, nritems=True)
