# gplugs/bash.py
#
# bash.org / qdb.us fetcher

""" show quotes from bash.org """

__status__ = "seen"

## gozerbot imports

from gozerbot.examples import examples
from gozerbot.commands import cmnds
from gozerbot.generic import geturl2, striphtml
from gozerbot.plughelp import plughelp
from gozerbot.tests import tests

## basic imports

import re

## plughelp

plughelp.add('bash', 'shows bash.org quotes')

## defines

re_p = re.compile('<p class="qt">(.*)</p>', )

## fetch function

def fetch(server, qid='random'):

    """ fetch bash quotes from server. """
    html = geturl2('http://%s/%s' % (server, qid))
    text = ''
    keep = False
    for line in html.splitlines():
        if len(line.split('</p>')) == 3: return striphtml(line.split('</p>')[1])
        elif line.startswith('<p class="quote">'):
            if '<p class="qt">' in line:
                if line.endswith('</p>'): return striphtml(re_p.findall(line)[0])
                else:
                    text = line.split('<p class="qt">')[1]
                    keep = True
        elif keep:
            if '</p>' in line:
                text = text + line.split('</p>')[0]
                return striphtml(text.replace('<br />', ' '))
            else: text = text + line
    if text: return striphtml(text.replace('<br />', ' '))
    else: return 'no result'

## bash command

def handle_bash(bot, ievent):

    """ <id>. fetch quote from bash.org. """
    if ievent.args:
        if not ievent.args[0].isdigit(): ievent.missing('<id>') ; return
        qid = ievent.args[0]
    else: qid = 'random'
    ievent.reply(fetch('bash.org', '?%s' % qid))

cmnds.add('bash', handle_bash, 'USER')
examples.add('bash', 'fetch quote from bash.org', "1) bash 2) bash 123")

#### BHJTW 22-01-2012
