# plugins/gcalc.py
# encoding: utf-8
#

__status__ = "seen"

## gozerbot imports

from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.plughelp import plughelp
from gozerbot.tests import tests
from gozerbot.aliases import aliasset

## basic imports

import urllib
import urllib2
import simplejson as json
import re

## plughelp

plughelp.add('gcalc', 'use the google calculator')

## defines

url = "http://www.google.com/ig/calculator?oe=utf-8&q="

## gcalc command

def handle_gcalc(bot, ievent):
    if len(ievent.args) > 0: expr = " ".join(ievent.args)
    else: ievent.missing('Missing an expression') ; return
    try: response = urllib2.urlopen(url + urllib.quote_plus(expr)) 
    except IOError: ievent.reply('request failed') ; return
    try:
	data = response.read()
	data = re.sub("(['\"])?([a-zA-Z0-9]+)(['\"])?:", '"\\2":', data)
	result = json.loads(data)
    except ValueError: ievent.reply('decoding failed') ; return
    if result['error']: ievent.reply('request failed: ' + result['error'])
    else: ievent.reply("%s = %s" % (result['lhs'], result['rhs']))
    return

cmnds.add('gcalc', handle_gcalc, 'USER')
examples.add('gcalc', 'Calculate an expression using the google calculator', 'gcalc 1 + 1')
aliasset('calc', 'gcalc')
tests.add('gcalc 1 + 1')

#### BHJTW 22-01-2012
