# gplugs/lns.py
#
# BSD License

""" http://ln-s.net short ln-s. """

__author__ = 'Wijnand "tehmaze" Modderman - http://tehmaze.com'
__status__ = "seen"

## gozerbot imports

from gozerbot.aliases import aliases
from gozerbot.callbacks import callbacks
from gozerbot.commands import cmnds
from gozerbot.generic import rlog
from gozerbot.persist.persistconfig import PersistConfig
from gozerbot.persist.persiststate import PlugState
from gozerbot.plughelp import plughelp
from gozerbot.examples import examples
from gozerbot.tests import tests

## basic imports

import re
import urllib
import urllib2

## plughelp

plughelp.add('lns', 'use the ln-s.net redirector')

## defines

re_url_match = re.compile(r'((?:http|https|ftp)://\S+)')

cfg = PersistConfig()
cfg.define('url-api', 'http://ln-s.net/home/api.jsp')
cfg.define('url-len', 64)

state = None

## init function

def init():
    global state
    state = PlugState()
    state.define('ln-s', {})
    return 1

## shutdown function

def shutdown():
    if state: state.save() ; return 1

## lnsurl function

def lnsurl(url):
    req = urllib2.Request(url=cfg.get('url-api'), data=urllib.urlencode({'url': url}))
    out = urllib2.urlopen(req)
    ret = out.read().strip()
    return ret.split(' ', 1)[1]

## lnscb callback

def lnscb(bot, ievent):
    if not state: return
    if not bot.name in state['ln-s']: return
    if not ievent.channel.lower() in state['ln-s'][bot.name]: return
    if not state['ln-s'][bot.name][ievent.channel.lower()]: return
    try:
        test_urls = re_url_match.findall(ievent.txt)
        for url in test_urls:
            if len(url) >= cfg.get('url-len'):
                host = url.split(':')[1].lstrip('/').split('/')[0]
                short = lnsurl(url)
                ievent.reply('%s (at %s)' % (short, host))
    except Exception,e: rlog(10, 'lns', 'EXCEPTION: %s' % str(e))

callbacks.add('PRIVMSG', lnscb)

## ln-on command

def handle_ln_on(bot, ievent):
    if not state: return
    if not bot.name in state['ln-s']: state['ln-s'][bot.name] = {}
    if not ievent.channel.lower() in state['ln-s'][bot.name]: state['ln-s'][bot.name][ievent.channel.lower()] = True
    ievent.reply('ok')

cmnds.add('ln-on', handle_ln_on, 'USER')
examples.add('ln-on', 'enable ln in channel the command was given in', 'ln-on')
aliases.data['lns-on'] = 'ln-on'
tests.add('ln-on')

## ln-off command

def handle_ln_off(bot, ievent):
    if not state: return
    if not bot.name in state['ln-s']: state['ln-s'][bot.name] = {}
    if not ievent.channel.lower() in state['ln-s'][bot.name]: state['ln-s'][bot.name][ievent.channel.lower()] = False
    ievent.reply('ok')

cmnds.add('ln-off', handle_ln_off, 'USER')
examples.add('ln-off', 'diable ln in channel the command was given in', 'ln-off')
aliases.data['lns-off'] = 'lns-off'
tests.add('ln-off')

#### BHJTW 22-01-2012
