#!/usr/bin/env python

import unittest
#import grandma
from nose.tools import ok_
from grandma.grandma import t_ways

def check_combinations(result, gold):
    """
    Check if the required results are contained in the computed
    combinations.
    """
    cases = list(result) # load all cases from the generator
    print cases
    for g in gold:
        contained = False
        for r in cases:
            contained = True # we would like to see that result
            for k in g.keys():
                if g[k] != r[k]:
                    contained = False
                    break
            if contained:
                break
        ok_(contained, '%s is not contained in computed result!' % g)


def check_invalid_combinations(result, gold):
    """
    Verify that the results do not contain any invalid combinations.
    """
    for g in gold:
        contained = False
        for r in result:
            contained = True # we would like to see that result
            for k in g.keys():
                if g[k] != r[k]:
                    contained = False
                    break
            if contained:
                break
        ok_(not(contained), '%s is contained in computed result!' % g)


def test_1_way():
    """Test 1-way combination of three parameters."""

    data = {
        "p1": ["v1_1", "v1_2", "v1_3"],
        "p2": ["v2_1", "v2_2", "v2_3", "v2_4"],
        "p3": ["v3_1", "v3_2", "v3_3", "v3_4", "v3_5"]
    }

    constraints = []

    result = t_ways(data, 1)
    
    # this is just all values 3+4+5 = 12
    gold = [
        {"p1": "v1_1"}, {"p1": "v1_2"}, {"p1": "v1_3"}, 
        {"p2": "v2_1"}, {"p2": "v2_2"}, {"p2": "v2_3"}, {"p2": "v2_4"}, 
        {"p3": "v3_1"}, {"p3": "v3_2"}, {"p3": "v3_3"}, {"p3": "v3_4"},
        {"p3": "v3_5"}
    ]
        
    check_combinations(result, gold)


def test_2_way():
    """Test 2-way combination of three parameters."""

    data = {
        "p1": ["v1_1", "v1_2", "v1_3"],
        "p2": ["v2_1", "v2_2", "v2_3", "v2_4"],
        "p3": ["v3_1", "v3_2", "v3_3", "v3_4", "v3_5"]
    }

    constraints = []

    result = t_ways(data, 2)
    
    # this is 3x4 + 3x5 + 4x5 = 47 
    gold = [
        {"p1": "v1_1", "p2": "v2_1"}, {"p1": "v1_2", "p2": "v2_1"},
        {"p1": "v1_3", "p2": "v2_1"},
        {"p1": "v1_1", "p2": "v2_2"}, {"p1": "v1_2", "p2": "v2_2"},
        {"p1": "v1_3", "p2": "v2_2"},
        {"p1": "v1_1", "p2": "v2_3"}, {"p1": "v1_2", "p2": "v2_3"},
        {"p1": "v1_3", "p2": "v2_3"},
        {"p1": "v1_1", "p2": "v2_4"}, {"p1": "v1_2", "p2": "v2_4"},
        {"p1": "v1_3", "p2": "v2_4"},
        {"p1": "v1_1", "p3": "v3_1"}, {"p1": "v1_2", "p3": "v3_1"},
        {"p1": "v1_3", "p3": "v3_1"},
        {"p1": "v1_1", "p3": "v3_2"}, {"p1": "v1_2", "p3": "v3_2"},
        {"p1": "v1_3", "p3": "v3_2"},
        {"p1": "v1_1", "p3": "v3_3"}, {"p1": "v1_2", "p3": "v3_3"},
        {"p1": "v1_3", "p3": "v3_3"},
        {"p1": "v1_1", "p3": "v3_4"}, {"p1": "v1_2", "p3": "v3_4"},
        {"p1": "v1_3", "p3": "v3_4"},
        {"p1": "v1_1", "p3": "v3_5"}, {"p1": "v1_2", "p3": "v3_5"},
        {"p1": "v1_3", "p3": "v3_5"},
        {"p2": "v2_1", "p3": "v3_1"}, {"p2": "v2_2", "p3": "v3_1"},
        {"p2": "v2_3", "p3": "v3_1"}, {"p2": "v2_4", "p3": "v3_1"},
        {"p2": "v2_1", "p3": "v3_2"}, {"p2": "v2_2", "p3": "v3_2"},
        {"p2": "v2_3", "p3": "v3_2"}, {"p2": "v2_4", "p3": "v3_2"},
        {"p2": "v2_1", "p3": "v3_3"}, {"p2": "v2_2", "p3": "v3_3"},
        {"p2": "v2_3", "p3": "v3_3"}, {"p2": "v2_4", "p3": "v3_3"},
        {"p2": "v2_1", "p3": "v3_4"}, {"p2": "v2_2", "p3": "v3_4"},
        {"p2": "v2_3", "p3": "v3_4"}, {"p2": "v2_4", "p3": "v3_4"},
        {"p2": "v2_1", "p3": "v3_5"}, {"p2": "v2_2", "p3": "v3_5"},
        {"p2": "v2_3", "p3": "v3_5"}, {"p2": "v2_4", "p3": "v3_5"}
    ]
        
    check_combinations(result, gold)
    

def test_3_way():
    """
    Test 3-way combination of three parameters. All possible combinations
    must be contained! 
    """

    data = {
        "p1": ["v1_1", "v1_2", "v1_3"],
        "p2": ["v2_1", "v2_2", "v2_3", "v2_4"],
        "p3": ["v3_1", "v3_2", "v3_3", "v3_4", "v3_5"]
    }

    constraints = []

    result = t_ways(data, 3)
    
    # this should be 3x4x5 = 60 combinations
    gold = [
        {"p1": "v1_1", "p2": "v2_1", "p3": "v3_1"},
        {"p1": "v1_1", "p2": "v2_1", "p3": "v3_2"},
        {"p1": "v1_1", "p2": "v2_1", "p3": "v3_3"},
        {"p1": "v1_1", "p2": "v2_1", "p3": "v3_4"},
        {"p1": "v1_1", "p2": "v2_1", "p3": "v3_5"},
        {"p1": "v1_1", "p2": "v2_2", "p3": "v3_1"},
        {"p1": "v1_1", "p2": "v2_2", "p3": "v3_2"},
        {"p1": "v1_1", "p2": "v2_2", "p3": "v3_3"},
        {"p1": "v1_1", "p2": "v2_2", "p3": "v3_4"},
        {"p1": "v1_1", "p2": "v2_2", "p3": "v3_5"},
        {"p1": "v1_1", "p2": "v2_3", "p3": "v3_1"},
        {"p1": "v1_1", "p2": "v2_3", "p3": "v3_2"},
        {"p1": "v1_1", "p2": "v2_3", "p3": "v3_3"},
        {"p1": "v1_1", "p2": "v2_3", "p3": "v3_4"},
        {"p1": "v1_1", "p2": "v2_3", "p3": "v3_5"},
        {"p1": "v1_1", "p2": "v2_4", "p3": "v3_1"},
        {"p1": "v1_1", "p2": "v2_4", "p3": "v3_2"},
        {"p1": "v1_1", "p2": "v2_4", "p3": "v3_3"},
        {"p1": "v1_1", "p2": "v2_4", "p3": "v3_4"},
        {"p1": "v1_1", "p2": "v2_4", "p3": "v3_5"},
        {"p1": "v1_2", "p2": "v2_1", "p3": "v3_1"},
        {"p1": "v1_2", "p2": "v2_1", "p3": "v3_2"},
        {"p1": "v1_2", "p2": "v2_1", "p3": "v3_3"},
        {"p1": "v1_2", "p2": "v2_1", "p3": "v3_4"},
        {"p1": "v1_2", "p2": "v2_1", "p3": "v3_5"},
        {"p1": "v1_2", "p2": "v2_2", "p3": "v3_1"},
        {"p1": "v1_2", "p2": "v2_2", "p3": "v3_2"},
        {"p1": "v1_2", "p2": "v2_2", "p3": "v3_3"},
        {"p1": "v1_2", "p2": "v2_2", "p3": "v3_4"},
        {"p1": "v1_2", "p2": "v2_2", "p3": "v3_5"},
        {"p1": "v1_2", "p2": "v2_3", "p3": "v3_1"},
        {"p1": "v1_2", "p2": "v2_3", "p3": "v3_2"},
        {"p1": "v1_2", "p2": "v2_3", "p3": "v3_3"},
        {"p1": "v1_2", "p2": "v2_3", "p3": "v3_4"},
        {"p1": "v1_2", "p2": "v2_3", "p3": "v3_5"},
        {"p1": "v1_2", "p2": "v2_4", "p3": "v3_1"},
        {"p1": "v1_2", "p2": "v2_4", "p3": "v3_2"},
        {"p1": "v1_2", "p2": "v2_4", "p3": "v3_3"},
        {"p1": "v1_2", "p2": "v2_4", "p3": "v3_4"},
        {"p1": "v1_2", "p2": "v2_4", "p3": "v3_5"},
        {"p1": "v1_3", "p2": "v2_1", "p3": "v3_1"},
        {"p1": "v1_3", "p2": "v2_1", "p3": "v3_2"},
        {"p1": "v1_3", "p2": "v2_1", "p3": "v3_3"},
        {"p1": "v1_3", "p2": "v2_1", "p3": "v3_4"},
        {"p1": "v1_3", "p2": "v2_1", "p3": "v3_5"},
        {"p1": "v1_3", "p2": "v2_2", "p3": "v3_1"},
        {"p1": "v1_3", "p2": "v2_2", "p3": "v3_2"},
        {"p1": "v1_3", "p2": "v2_2", "p3": "v3_3"},
        {"p1": "v1_3", "p2": "v2_2", "p3": "v3_4"},
        {"p1": "v1_3", "p2": "v2_2", "p3": "v3_5"},
        {"p1": "v1_3", "p2": "v2_3", "p3": "v3_1"},
        {"p1": "v1_3", "p2": "v2_3", "p3": "v3_2"},
        {"p1": "v1_3", "p2": "v2_3", "p3": "v3_3"},
        {"p1": "v1_3", "p2": "v2_3", "p3": "v3_4"},
        {"p1": "v1_3", "p2": "v2_3", "p3": "v3_5"},
        {"p1": "v1_3", "p2": "v2_4", "p3": "v3_1"},
        {"p1": "v1_3", "p2": "v2_4", "p3": "v3_2"},
        {"p1": "v1_3", "p2": "v2_4", "p3": "v3_3"},
        {"p1": "v1_3", "p2": "v2_4", "p3": "v3_4"},
        {"p1": "v1_3", "p2": "v2_4", "p3": "v3_5"}
    ]
    
    check_combinations(result, gold)


def test_incompats():
    """
    Test incompatibilities. All possible combinations
    must be contained! 
    """

    data = {
        "p1": ["v1_1", "v1_2", "v1_3"],
        "p2": ["v2_1", "v2_2", "v2_3", "v2_4"],
        "p3": ["v3_1", "v3_2", "v3_3", "v3_4", "v3_5"]
    }

    incompats = [{
        #"p1": ["v1_3"],
        "p2": ["v2_4"],
        "p3": ["v3_4", "v3_5"]
    }]

    constraints = []

    result = t_ways(data, 3, incompats=incompats)
    
    # this should be 3x4x5 - 6 = 54 combinations
    gold = [
        {"p1": "v1_1", "p2": "v2_1", "p3": "v3_1"},
        {"p1": "v1_1", "p2": "v2_1", "p3": "v3_2"},
        {"p1": "v1_1", "p2": "v2_1", "p3": "v3_3"},
        {"p1": "v1_1", "p2": "v2_1", "p3": "v3_4"},
        {"p1": "v1_1", "p2": "v2_1", "p3": "v3_5"},
        {"p1": "v1_1", "p2": "v2_2", "p3": "v3_1"},
        {"p1": "v1_1", "p2": "v2_2", "p3": "v3_2"},
        {"p1": "v1_1", "p2": "v2_2", "p3": "v3_3"},
        {"p1": "v1_1", "p2": "v2_2", "p3": "v3_4"},
        {"p1": "v1_1", "p2": "v2_2", "p3": "v3_5"},
        {"p1": "v1_1", "p2": "v2_3", "p3": "v3_1"},
        {"p1": "v1_1", "p2": "v2_3", "p3": "v3_2"},
        {"p1": "v1_1", "p2": "v2_3", "p3": "v3_3"},
        {"p1": "v1_1", "p2": "v2_3", "p3": "v3_4"},
        {"p1": "v1_1", "p2": "v2_3", "p3": "v3_5"},
        {"p1": "v1_1", "p2": "v2_4", "p3": "v3_1"},
        {"p1": "v1_1", "p2": "v2_4", "p3": "v3_2"},
        {"p1": "v1_1", "p2": "v2_4", "p3": "v3_3"},
        {"p1": "v1_2", "p2": "v2_1", "p3": "v3_1"},
        {"p1": "v1_2", "p2": "v2_1", "p3": "v3_2"},
        {"p1": "v1_2", "p2": "v2_1", "p3": "v3_3"},
        {"p1": "v1_2", "p2": "v2_1", "p3": "v3_4"},
        {"p1": "v1_2", "p2": "v2_1", "p3": "v3_5"},
        {"p1": "v1_2", "p2": "v2_2", "p3": "v3_1"},
        {"p1": "v1_2", "p2": "v2_2", "p3": "v3_2"},
        {"p1": "v1_2", "p2": "v2_2", "p3": "v3_3"},
        {"p1": "v1_2", "p2": "v2_2", "p3": "v3_4"},
        {"p1": "v1_2", "p2": "v2_2", "p3": "v3_5"},
        {"p1": "v1_2", "p2": "v2_3", "p3": "v3_1"},
        {"p1": "v1_2", "p2": "v2_3", "p3": "v3_2"},
        {"p1": "v1_2", "p2": "v2_3", "p3": "v3_3"},
        {"p1": "v1_2", "p2": "v2_3", "p3": "v3_4"},
        {"p1": "v1_2", "p2": "v2_3", "p3": "v3_5"},
        {"p1": "v1_2", "p2": "v2_4", "p3": "v3_1"},
        {"p1": "v1_2", "p2": "v2_4", "p3": "v3_2"},
        {"p1": "v1_2", "p2": "v2_4", "p3": "v3_3"},
        {"p1": "v1_3", "p2": "v2_1", "p3": "v3_1"},
        {"p1": "v1_3", "p2": "v2_1", "p3": "v3_2"},
        {"p1": "v1_3", "p2": "v2_1", "p3": "v3_3"},
        {"p1": "v1_3", "p2": "v2_1", "p3": "v3_4"},
        {"p1": "v1_3", "p2": "v2_1", "p3": "v3_5"},
        {"p1": "v1_3", "p2": "v2_2", "p3": "v3_1"},
        {"p1": "v1_3", "p2": "v2_2", "p3": "v3_2"},
        {"p1": "v1_3", "p2": "v2_2", "p3": "v3_3"},
        {"p1": "v1_3", "p2": "v2_2", "p3": "v3_4"},
        {"p1": "v1_3", "p2": "v2_2", "p3": "v3_5"},
        {"p1": "v1_3", "p2": "v2_3", "p3": "v3_1"},
        {"p1": "v1_3", "p2": "v2_3", "p3": "v3_2"},
        {"p1": "v1_3", "p2": "v2_3", "p3": "v3_3"},
        {"p1": "v1_3", "p2": "v2_3", "p3": "v3_4"},
        {"p1": "v1_3", "p2": "v2_3", "p3": "v3_5"},
        {"p1": "v1_3", "p2": "v2_4", "p3": "v3_1"},
        {"p1": "v1_3", "p2": "v2_4", "p3": "v3_2"},
        {"p1": "v1_3", "p2": "v2_4", "p3": "v3_3"}
    ]


    # this should be 1x2 = 2 combinations
    gold_invalid = [
        {"p2": "v2_4", "p3": "v3_4"},
        {"p2": "v2_4", "p3": "v3_5"},
     ]    
        
    check_invalid_combinations(result, gold_invalid)


