var grano=angular.module('grano',['ngRoute','ngAnimate','ui.bootstrap','grano.config']);grano.config(['$routeProvider','$locationProvider',function($routeProvider,$locationProvider){$routeProvider.when('/',{templateUrl:'home.html',controller:HomeCtrl});$routeProvider.when('/p/:slug',{templateUrl:'projects/view.html',controller:ProjectsViewCtrl});$routeProvider.when('/p/:slug/settings',{templateUrl:'projects/edit.html',controller:ProjectsEditCtrl});$routeProvider.when('/p/:slug/schemata',{templateUrl:'schemata/index.html',controller:SchemataIndexCtrl});$routeProvider.when('/p/:slug/permissions',{templateUrl:'permissions/index.html',controller:PermissionsIndexCtrl});$routeProvider.when('/p/:slug/entities',{templateUrl:'entities/index.html',controller:EntitiesIndexCtrl});$routeProvider.when('/p/:slug/entities/:id',{templateUrl:'entities/view.html',controller:EntitiesViewCtrl});$routeProvider.otherwise({redirectTo:'/'});$locationProvider.html5Mode(false);}]);grano.handleFormError=function(form){return function(data,status){if(status==400){var errors=[];for(var field in data.errors){form[field].$setValidity('value',false);form[field].$message=data.errors[field];errors.push(field);}
if(angular.isDefined(form._errors)){angular.forEach(form._errors,function(field){if(errors.indexOf(field)==-1){form[field].$setValidity('value',true);}});}
form._errors=errors;}else{if(angular.isObject(data)&&data.message){alert(data.message);}
}};};grano.factory('core',['$http','$rootScope','$location','config',function($http,$rootScope,$location,config){var setTitle=function(name){$('title').html(name+' - '+config.APP_NAME);};return{setTitle:setTitle};}]);grano.factory('session',['$http',function($http){var dfd=$http.get('/api/1/sessions');return{get:dfd.success};}]);grano.directive('gnFrame',function(){return{restrict:'E',transclude:true,templateUrl:'directives/frame.html'}});grano.directive('gnPermission',['$timeout','session',function($timeout,session){return{restrict:'AE',scope:{'project':'=','role':'@role',},link:function(scope,element,attrs,model){element.addClass('hidden');scope.$watch('project',function(n,o,project){if(scope.project&&scope.project.slug){session.get(function(res){var perms=res.permissions[scope.project.slug]||{};if(perms[scope.role]){element.removeClass('hidden');}});}});}};}]);grano.directive('gnPager',['$timeout',function($timeout){return{restrict:'E',scope:{'response':'=','load':'&load'},templateUrl:'directives/pager.html',link:function(scope,element,attrs,model){scope.showPager=false;scope.$watch('response',function(e){if(scope.response.pages<=1){return;}
var pages=[],current=(scope.response.offset/scope.response.limit)+1,num=Math.ceil(scope.response.total/scope.response.limit),range=3,low=current-range,high=current+range;if(low<1){low=1;high=Math.min((2*range)+1,num);}
if(high>num){high=num;low=Math.max(1,num-(2*range)+1);}
for(var page=low;page<=high;page++){var offset=(page-1)*scope.response.limit,url=scope.response.format.replace('LIMIT',scope.response.limit).replace('OFFSET',offset);pages.push({page:page,current:page==current,url:url});}
scope.showPager=true;scope.pages=pages;});}};}]);function AppCtrl($scope,$window,$routeParams,$location,$modal,session,core,config){$scope.session={logged_in:false};$scope.config=config
core.setTitle('Welcome');session.get(function(data){$scope.session=data;});$scope.showAccount=function(){var d=$modal.open({templateUrl:'account.html',controller:'AccountCtrl',backdrop:false});};}
AppCtrl.$inject=['$scope','$window','$routeParams','$location','$modal','session','core','config'];function HomeCtrl($scope,$location,$http,$modal){$scope.projects={};$scope.loadProjects=function(url){$http.get(url).then(function(data){$scope.projects=data.data;});};$scope.loadProjects('/api/1/projects');$scope.newProject=function(){var d=$modal.open({templateUrl:'projects/new.html',controller:'ProjectsNewCtrl',backdrop:false});};}
HomeCtrl.$inject=['$scope','$location','$http','$modal'];function AccountCtrl($scope,$location,$modalInstance,$http,session){$scope.session={logged_in:false};$scope.account={};session.get(function(data){$scope.session=data;$scope.account=data.account;});$scope.cancel=function(){$modalInstance.dismiss('cancel');};$scope.update=function(form){var res=$http.post('/api/1/accounts/'+$scope.account.id,$scope.account);res.success(function(data){$scope.account=data;$scope.session.account=data;$modalInstance.dismiss('ok');});res.error(grano.handleFormError(form));};}
AccountCtrl.$inject=['$scope','$location','$modalInstance','$http','session'];function ProjectsViewCtrl($scope,$routeParams,$location,$http,$modal,$timeout,session){$scope.project={};$http.get('/api/1/projects/'+$routeParams.slug).then(function(res){$scope.project=res.data;});}
ProjectsViewCtrl.$inject=['$scope','$routeParams','$location','$http','$modal','$timeout','session'];function ProjectsNewCtrl($scope,$routeParams,$modalInstance,$location,$http,session){$scope.project={};$scope.cancel=function(){$modalInstance.dismiss('cancel');};$scope.create=function(form){var res=$http.post('/api/1/projects',$scope.project);res.success(function(data){$location.path('/p/'+data.slug);$modalInstance.dismiss('ok');});res.error(grano.handleFormError(form));};}
ProjectsNewCtrl.$inject=['$scope','$routeParams','$modalInstance','$location','$http','session'];function ProjectsEditCtrl($scope,$route,$routeParams,$location,$http,core){$scope.navSection='settings';$scope.project={};$http.get('/api/1/projects/'+$routeParams.slug).then(function(res){$scope.project=res.data;core.setTitle($scope.project.label);});$scope.update=function(form){var res=$http.post('/api/1/projects/'+$scope.project.slug,$scope.project);res.success(function(data){$location.path('/p/'+$scope.project.slug);});res.error(grano.handleFormError(form));};}
ProjectsEditCtrl.$inject=['$scope','$route','$routeParams','$location','$http','core'];function SchemataIndexCtrl($scope,$routeParams,$location,$http,$modal,$timeout,core,session){$scope.navSection='schemata';$scope.project={};$scope.entity_schemata=[];$scope.relation_schemata=[];$http.get('/api/1/projects/'+$routeParams.slug).then(function(res){$scope.project=res.data;core.setTitle($scope.project.label);});$http.get('/api/1/projects/'+$routeParams.slug+'/schemata',{params:{limit:1000}}).then(function(res){angular.forEach(res.data.results,function(e){if(e.obj=='entity'){$scope.entity_schemata.push(e);}else{$scope.relation_schemata.push(e);}});});}
SchemataIndexCtrl.$inject=['$scope','$routeParams','$location','$http','$modal','$timeout','core','session'];function PermissionsIndexCtrl($scope,$routeParams,$location,$http,$modal,$q,$timeout,core,session){$scope.url='/api/1/projects/'+$routeParams.slug+'/permissions';$scope.navSection='permissions';$scope.permissions={};$scope.newPermission={'reader':true};$http.get('/api/1/projects/'+$routeParams.slug).then(function(res){$scope.project=res.data;core.setTitle($scope.project.label);});$scope.loadPermissions=function(url){$http.get(url).then(function(res){$scope.url=url;$scope.permissions=res.data;});};$scope.save=function(permission){if(!permission.reader)permission.editor=false;if(!permission.editor)permission.admin=false;var res=$http.post(permission.api_url,permission);res.then(function(res){permission.reader=res.data.reader;permission.editor=res.data.editor;permission.admin=res.data.admin;});};$scope.sanify=function(){if($scope.newPermission.admin)$scope.newPermission.editor=true;if($scope.newPermission.editor)$scope.newPermission.reader=true;};$scope.create=function(){var url='/api/1/projects/'+$routeParams.slug+'/permissions',res=$http.post(url,$scope.newPermission);res.then(function(res){$scope.loadPermissions($scope.url);$scope.newPermission={'reader':true};});};$scope.loadAccounts=function(query){var dfd=$q.defer();var res=$http.get('/api/1/accounts/_suggest',{params:{q:query}});return res.then(function(res){return res.data.results;});};$scope.loadPermissions($scope.url);}
PermissionsIndexCtrl.$inject=['$scope','$routeParams','$location','$http','$modal','$q','$timeout','core','session'];function EntitiesIndexCtrl($scope,$routeParams,$location,$http,$modal,$timeout,core,session){var params={project:$routeParams.slug,'limit':25},filterTimeout=null;$scope.navSection='entities';$scope.query={value:''};$scope.project={};$scope.entities={};$http.get('/api/1/projects/'+$routeParams.slug).then(function(res){$scope.project=res.data;core.setTitle($scope.project.label);});$scope.updateFilter=function(){if(filterTimeout){$timeout.cancel(filterTimeout);}
filterTimeout=$timeout(function(){var fparams=angular.copy(params);fparams.q=$scope.query.value+'*';$scope.loadEntities('/api/1/entities/_search',fparams);},500);};$scope.loadEntities=function(url,params){$http.get(url,{params:params}).then(function(res){$scope.entities=res.data;});};$scope.loadEntities('/api/1/entities/_search',params);}
EntitiesIndexCtrl.$inject=['$scope','$routeParams','$location','$http','$modal','$timeout','core','session'];function EntitiesViewCtrl($scope,$routeParams,$location,$http,$modal,$timeout,core,session){$scope.navSection='entities';$scope.project={};$scope.entity={};$http.get('/api/1/projects/'+$routeParams.slug).then(function(res){$scope.project=res.data;});$http.get('/api/1/entities/'+$routeParams.id).then(function(res){$scope.entity=res.data;$scope.json=JSON.stringify(res.data,null,"  ");core.setTitle(res.data.properties.name.value);});}
EntitiesViewCtrl.$inject=['$scope','$routeParams','$location','$http','$modal','$timeout','core','session'];