var grano=angular.module("grano",["ngRoute","ngAnimate","ngSanitize","angularFileUpload","ui.bootstrap","grano.config"]);grano.config(["$routeProvider","$locationProvider",function($routeProvider,$locationProvider){$routeProvider.when("/",{templateUrl:"home.html",controller:HomeCtrl});$routeProvider.when("/p/:slug",{templateUrl:"projects/view.html",controller:ProjectsViewCtrl});$routeProvider.when("/p/:slug/settings",{templateUrl:"projects/edit.html",controller:ProjectsEditCtrl});$routeProvider.when("/p/:slug/schemata",{templateUrl:"schemata/index.html",controller:SchemataIndexCtrl});$routeProvider.when("/p/:slug/schemata/new/:obj",{templateUrl:"schemata/view.html",controller:SchemataViewCtrl});$routeProvider.when("/p/:slug/schemata/:name",{templateUrl:"schemata/view.html",controller:SchemataViewCtrl});$routeProvider.when("/p/:slug/permissions",{templateUrl:"permissions/index.html",controller:PermissionsIndexCtrl});$routeProvider.when("/p/:slug/entities",{templateUrl:"entities/index.html",controller:EntitiesIndexCtrl,reloadOnSearch:false});$routeProvider.when("/p/:slug/entities/new",{templateUrl:"entities/new.html",controller:EntitiesNewCtrl});$routeProvider.when("/p/:slug/entities/:id",{templateUrl:"entities/view.html",controller:EntitiesViewCtrl});$routeProvider.when("/p/:slug/relations/:id",{templateUrl:"relations/view.html",controller:RelationsViewCtrl});$routeProvider.when("/p/:slug/import",{templateUrl:"imports/index.html",controller:ImportIndexCtrl});$routeProvider.when("/p/:slug/import/modes",{templateUrl:"imports/modes.html",controller:ImportModesCtrl});$routeProvider.when("/p/:slug/import/mapping",{templateUrl:"imports/mapping.html",controller:ImportMappingCtrl});$routeProvider.otherwise({redirectTo:"/"});$locationProvider.html5Mode(false)}]);grano.handleFormError=function(form){return function(data,status){if(status==400){var errors=[];for(var field in data.errors){form[field].$setValidity("value",false);form[field].$message=data.errors[field];errors.push(field)}if(angular.isDefined(form._errors)){angular.forEach(form._errors,function(field){if(errors.indexOf(field)==-1){form[field].$setValidity("value",true)}})}form._errors=errors}else{if(angular.isObject(data)&&data.message){alert(data.message)}}}};grano.factory("core",["$http","$rootScope","$location","config",function($http,$rootScope,$location,config){var setTitle=function(name){$("title").html(name+" - "+config.APP_NAME)};var call=function(path){return config.API_ROOT+path};return{setTitle:setTitle,call:call}}]);grano.factory("session",["$http","core",function($http,core){var dfd=$http.get(core.call("/sessions"));return{get:dfd.success}}]);grano.factory("schemata",["$http","$rootScope","$location","$q","core",function($http,$rootScope,$location,$q,core){var schemata={};var reset=function(slug){schemata[slug]=null};var get=function(slug){var dfd=$q.defer();if(schemata[slug]){dfd.resolve(schemata[slug])}else{var url=core.call("/projects/"+slug+"/schemata");$http.get(url,{params:{limit:1e3,full:true}}).then(function(res){schemata[slug]=res.data.results;dfd.resolve(schemata[slug])})}return dfd.promise};var byName=function(slug,name){var dfd=$q.defer();get(slug).then(function(schemata){angular.forEach(schemata,function(schema){if(schema.name==name){dfd.resolve(schema)}})});return dfd.promise};var attributes=function(slug,obj){var dfd=$q.defer();get(slug).then(function(schemata){var attributes={};angular.forEach(schemata,function(s){if(!obj||s.obj==obj){angular.forEach(s.attributes,function(a){a.schema=s;attributes[a.name]=a})}});dfd.resolve(attributes)});return dfd.promise};return{get:get,reset:reset,attributes:attributes,byName:byName}}]);grano.filter("truncate",["$sanitize","$sce",function($sanitize,$sce){return function(input,len){if(input.length<=len){return input}cleaned=$sanitize(input);cleaned=cleaned.substring(0,len)+"…";return $sce.trustAsHtml(cleaned)}}]);grano.filter("datetime",["$sanitize","$sce",function($sanitize,$sce){return function(input){if(!input)return"-";return moment(input).format("LLL")}}]);grano.directive("gnPermission",["$timeout","session",function($timeout,session){return{restrict:"AE",scope:{project:"=",inverted:"=",role:"@role"},link:function(scope,element,attrs,model){element.addClass("hidden");scope.$watch("project",function(n,o,project){if(scope.project&&scope.project.slug){session.get(function(res){var perms=res.permissions[scope.project.slug]||{};if(!scope.inverted&&perms[scope.role]||scope.inverted&&!perms[scope.role]){element.removeClass("hidden")}})}})}}}]);grano.directive("gnPager",["$timeout",function($timeout){return{restrict:"E",scope:{response:"=",load:"&load"},templateUrl:"directives/pager.html",link:function(scope,element,attrs,model){scope.$watch("response",function(e){scope.showPager=false;scope.pages=[];if(scope.response.pages<=1){return}var pages=[],current=scope.response.offset/scope.response.limit+1,num=Math.ceil(scope.response.total/scope.response.limit),range=2,low=current-range,high=current+range;if(low<1){low=1;high=Math.min(2*range+1,num)}if(high>num){high=num;low=Math.max(1,num-2*range+1)}for(var page=low;page<=high;page++){var offset=(page-1)*scope.response.limit,url=scope.response.format.replace("LIMIT",scope.response.limit).replace("OFFSET",offset);pages.push({page:page,current:page==current,url:url})}scope.showPager=true;scope.pages=pages})}}}]);grano.directive("gnMenu",["$timeout","$location","$route","schemata","session",function($timeout,$location,$route,schemata,session){return{restrict:"E",scope:{project:"=",navSection:"=",full:"=",ulClass:"@"},templateUrl:"directives/menu.html",link:function(scope,element,attrs,model){scope.schemata=[];scope.$watch("project",function(p){scope.schemata=[];if(!p||!p.slug)return;schemata.get(p.slug).then(function(ss){angular.forEach(ss,function(s){if(s.obj=="entity"&&!s.hidden){scope.schemata.push(s)}})})});scope.applyFacet=function(schema){$location.path("/p/"+scope.project.slug+"/entities");$location.search("schema",schema);scope.$emit("updateSearch")}}}}]);grano.directive("gnPropertyView",["core","$http","$sce","$sanitize","schemata",function(core,$http,$sce,$sanitize,schemata){return{restrict:"E",scope:{property:"=",attribute:"="},templateUrl:"directives/property_view.html",link:function(scope,element,attrs,model){scope.display_value=null;scope.show="short";var update=function(){if(!scope.attribute)return;var value=scope.property?scope.property.value:"";if(scope.attribute.datatype=="string"){value=$sanitize(value);if(/^https?:\/\/.*/i.test(value)){name=value.replace(/^https?:\/\//i,"");value="<a class='auto' href='"+value+"' target='_blank'>"+name+"</a>"}else if(value&&value.length>80){scope.long_value=value;value=value.substring(0,90).replace(/<[^>]+>/gm,"")}}else if(scope.attribute.datatype=="float"){value=new Number(value).toFixed(2)}else if(scope.attribute.datatype=="boolean"){var icon="fa-square-o";if(value){icon="fa-check-square-o"}value='<i class="fa '+icon+'"></i>'}else if(scope.attribute.datatype=="datetime"){value=moment(value).format("LL")}else{value=value+""}scope.display_value=$sce.trustAsHtml(value)};scope.$watch("attribute",update);scope.$watch("property",update)}}}]);angular.module("template/datepicker/datepicker.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("template/datepicker/datepicker.html","<table>\n"+"  <thead>\n"+"    <tr>\n"+'      <th><button type="button" class="btn btn-default btn-sm pull-left" ng-click="move(-1)"><i class="fa fa-angle-double-left"></i></button></th>\n'+'      <th colspan="{{rows[0].length - 2 + showWeekNumbers}}"><button type="button" class="btn btn-default btn-sm btn-block" ng-click="toggleMode()"><strong>{{title}}</strong></button></th>\n'+'      <th><button type="button" class="btn btn-default btn-sm pull-right" ng-click="move(1)"><i class="fa fa-angle-double-right"></i></button></th>\n'+"    </tr>\n"+'    <tr ng-show="labels.length > 0" class="h6">\n'+'      <th ng-show="showWeekNumbers" class="text-center">#</th>\n'+'      <th ng-repeat="label in labels" class="text-center">{{label}}</th>\n'+"    </tr>\n"+"  </thead>\n"+"  <tbody>\n"+'    <tr ng-repeat="row in rows">\n'+'      <td ng-show="showWeekNumbers" class="text-center"><em>{{ getWeekNumber(row) }}</em></td>\n'+'      <td ng-repeat="dt in row" class="text-center">\n'+'        <button type="button" style="width:100%;" class="btn btn-default btn-sm" ng-class="{\'btn-info\': dt.selected}" ng-click="select(dt.date)" ng-disabled="dt.disabled"><span ng-class="{\'text-muted\': dt.secondary}">{{dt.label}}</span></button>\n'+"      </td>\n"+"    </tr>\n"+"  </tbody>\n"+"</table>\n"+"")}]);grano.directive("gnPropertyEdit",["core","$http","$sce","schemata",function(core,$http,$sce,schemata){return{restrict:"E",scope:{property:"=",attribute:"=",fieldClass:"@"},templateUrl:"directives/property_edit.html",link:function(scope,element,attrs,model){scope.openDatePicker=false;var update=function(){};scope.$watch("attribute",update);scope.$watch("property",update)}}}]);grano.directive("gnPropertyMultiEdit",["core","$http","$sce","schemata",function(core,$http,$sce,schemata){return{restrict:"E",scope:{obj:"=",attributes:"="},templateUrl:"directives/property_multiedit.html",link:function(scope,element,attrs,model){scope.newProperty={ready:false,value:null};scope.$watch("attributes",function(){if(!scope.newProperty.attribute){scope.newProperty.attribute=scope.attributeChoices()[0]}});scope.$on("save",function(e){if(scope.newProperty.value){scope.addProperty()}});scope.addProperty=function(){prop=scope.newProperty;prop.name=prop.attribute.name;scope.obj.properties[prop.name]=prop;scope.newProperty={attribute:scope.attributeChoices()[0],ready:false}};scope.changeAttribute=function(){scope.newProperty.value=null};scope.removeProperty=function(property){delete scope.obj.properties[property.name]};scope.hasAttributes=function(){return scope.attributeChoices().length>0};scope.canRemoveProperty=function(property){return property.name!="name"};scope.attributeChoices=function(){var attributes=[];angular.forEach(scope.attributes,function(a,n){if(_.keys(scope.obj.properties).indexOf(n)==-1){attributes.push(a)}});return attributes}}}}]);grano.directive("gnPropertyList",["core","$http","$sce","$modal","schemata",function(core,$http,$sce,$modal,schemata){return{restrict:"E",scope:{obj:"=",refresh:"&"},templateUrl:"directives/property_list.html",link:function(scope,element,attrs,model){scope.attributes={};scope.getProperties=function(){var properties=[];angular.forEach(scope.obj.properties,function(p,k){p.name=k;properties.push(p)});return properties.sort(function(a,b){if(a.name=="name")return-1;if(b.name=="name")return 1;if(a.name>b.name)return 1;if(a.name<b.name)return-1;return 0})};scope.editProperty=function(attribute){var d=$modal.open({templateUrl:"properties/edit.html",controller:"PropertiesEditCtrl",resolve:{obj:function(){return scope.obj},attribute:function(){return attribute}}});d.result.finally(function(){scope.refresh({id:scope.obj.id})})};scope.canDisable=function(attribute){if(scope.obj&&scope.obj.schemata&&attribute&&attribute.name=="name"){return false}return true};scope.canCreate=function(){return _.keys(scope.attributes).length>_.keys(scope.obj.properties).length};scope.disableProperty=function(attribute){delete scope.obj.properties[attribute.name];$http.post(scope.obj.api_url,scope.obj).then(function(res){scope.obj=res.data})};scope.$watch("obj",function(o){if(!o||!o.id)return;scope.project=o.project;if(o.schemata){schemata.attributes(o.project.slug,"entity").then(function(attributes){scope.attributes=attributes})}else if(o.schema){schemata.byName(o.project.slug,o.schema.name).then(function(schema){scope.attributes={};angular.forEach(schema.attributes,function(attr){attr.schema=schema;scope.attributes[attr.name]=attr})})}})}}}]);grano.directive("gnRelationList",["core","$http","$sce","$modal","schemata",function(core,$http,$sce,$modal,schemata){return{restrict:"E",scope:{entity:"=",direction:"@"},templateUrl:"directives/relation_list.html",link:function(scope,element,attrs,model){scope.relations={};scope.schemata=[];scope.localName=scope.direction=="inbound"?"target":"source";scope.oppositeName=scope.direction=="inbound"?"source":"target";scope.load=function(url){scope.relations={};$http.get(url).then(function(res){scope.relations=res.data})};scope.canAdd=function(){return scope.schemata.length>0};scope.deleteRelation=function(relation){var d=$modal.open({templateUrl:"relations/delete.html",controller:"RelationsDeleteCtrl",resolve:{relation:function(){return relation}}})};scope.createRelation=function(){var d=$modal.open({templateUrl:"relations/new.html",controller:"RelationsNewCtrl",resolve:{project:function(){return scope.project},source:function(){return scope.localName=="source"?scope.entity:null},target:function(){return scope.localName=="target"?scope.entity:null}}})};scope.$watch("entity",function(e){if(!e||!e.id)return;scope.project=e.project;var url=core.call("/relations?"+scope.localName+"="+e.id);scope.load(url);if(scope.project){schemata.get(scope.project.slug,"relation").then(function(ss){scope.schemata=[];angular.forEach(ss,function(s){if(s.obj=="relation")scope.schemata.push(s)})})}})}}}]);grano.directive("gnEntityPreview",["core","$http","$route","$location","$modal","core","config","schemata",function(core,$http,$route,$location,$modal,core,config,schemata){return{restrict:"E",scope:{preview:"=",project:"="},templateUrl:"entities/preview.html",link:function(scope,element,attrs,model){scope.entity={};scope.reloadEntity=function(id){$http.get(core.call("/entities/"+id)).then(function(res){scope.entity=res.data;core.setTitle(scope.entity.properties.name.value)})};scope.deleteEntity=function(){var d=$modal.open({templateUrl:"entities/delete.html",controller:"EntitiesDeleteCtrl",resolve:{entity:function(){return scope.entity}}})};scope.$watch("preview",function(e){if(!e||!e.id)return;scope.entity=e;if(!e.created_at){scope.reloadEntity(e.id)}});scope.$watch("project",function(p){if(!p||!p.slug)return;schemata.attributes(p.slug,"entity").then(function(attributes){scope.attributes=attributes})})}}}]);grano.directive("gnEntitySuggest",["core","$http","$sce","$q","core",function(core,$http,$sce,$q,core){return{restrict:"E",scope:{entity:"=",project:"="},templateUrl:"directives/entity_suggest.html",link:function(scope,element,attrs,model){var url=core.call("/entities/_suggest");scope.loadEntities=function(query){var dfd=$q.defer(),params={q:query,project:scope.project.slug};$http.get(url,{params:params}).then(function(es){dfd.resolve(es.data.results)});return dfd.promise}}}}]);grano.directive("gnEntityHeader",["core","$http","$route","$location","$modal","core","config","schemata",function(core,$http,$route,$location,$modal,core,config,schemata){return{restrict:"AE",scope:{entity:"="},templateUrl:"entities/header.html",link:function(scope,element,attrs,model){scope.config=config;scope.deleteEntity=function(){var d=$modal.open({templateUrl:"entities/delete.html",controller:"EntitiesDeleteCtrl",resolve:{entity:function(){return scope.entity}}})};scope.mergeEntity=function(){var d=$modal.open({templateUrl:"entities/merge.html",controller:"EntitiesMergeCtrl",resolve:{orig:function(){return scope.entity}}})};scope.$watch("entity",function(e){if(!e||!e.project)return;scope.project=e.project})}}}]);function AppCtrl($scope,$window,$routeParams,$location,$modal,$http,$route,session,schemata,core,config){$scope.session={logged_in:false};$scope.config=config;$scope.navSection="project";core.setTitle("Welcome");$scope.pageLoaded=true;$scope.loadProject=function(slug){$scope.project=false;$scope.frameSchemata=[];if(!slug)return;var url=core.call("/projects/"+$routeParams.slug);$http.get(url).then(function(res){$scope.project=res.data;core.setTitle($scope.project.label)})};$scope.setSection=function(section){$scope.navSection=section};session.get(function(data){$scope.session=data});$scope.showAccount=function(){var d=$modal.open({templateUrl:"account.html",controller:"AccountCtrl"})}}AppCtrl.$inject=["$scope","$window","$routeParams","$location","$modal","$http","$route","session","schemata","core","config"];function HomeCtrl($scope,$location,$http,$modal,core){$scope.projects={};$scope.loadProject(null);$scope.loadProjects=function(url){$http.get(url).then(function(data){$scope.projects=data.data})};$scope.loadProjects(core.call("/projects"));$scope.newProject=function(){var d=$modal.open({templateUrl:"projects/new.html",controller:"ProjectsNewCtrl",backdrop:false})}}HomeCtrl.$inject=["$scope","$location","$http","$modal","core"];function AccountCtrl($scope,$location,$modalInstance,$http,core,session){$scope.session={logged_in:false};$scope.account={};session.get(function(data){$scope.session=data;$scope.account=data.account});$scope.cancel=function(){$modalInstance.dismiss("cancel")};$scope.update=function(form){var res=$http.post(core.call("/accounts/"+$scope.account.id),$scope.account);res.success(function(data){$scope.account=data;$scope.session.account=data;$modalInstance.dismiss("ok")});res.error(grano.handleFormError(form))}}AccountCtrl.$inject=["$scope","$location","$modalInstance","$http","core","session"];function ProjectsViewCtrl($scope,$routeParams,$location,$http,$modal,$timeout,core,session,schemata){$scope.setSection("project");$scope.loadProject($routeParams.slug);$scope.query={};$scope.schemata=[];$scope.noSchemata=false;$scope.searchEntities=function(){$location.path("/p/"+$routeParams.slug+"/entities");$location.search({q:$scope.query.value})};$scope.uploadFile=function(){var d=$modal.open({templateUrl:"imports/upload.html",controller:"ImportUploadCtrl",resolve:{project:function(){return $scope.project}}})};schemata.get($routeParams.slug).then(function(ss){$scope.schemata=ss;$scope.noSchemata=ss.length==1})}ProjectsViewCtrl.$inject=["$scope","$routeParams","$location","$http","$modal","$timeout","core","session","schemata"];function ProjectsNewCtrl($scope,$routeParams,$modalInstance,$location,$http,core,session){$scope.project={};$scope.cancel=function(){$modalInstance.dismiss("cancel")};$scope.create=function(form){var res=$http.post(core.call("/projects"),$scope.project);res.success(function(data){$location.path("/p/"+data.slug);$modalInstance.dismiss("ok")});res.error(grano.handleFormError(form))}}ProjectsNewCtrl.$inject=["$scope","$routeParams","$modalInstance","$location","$http","core","session"];function ProjectsEditCtrl($scope,$route,$routeParams,$location,$http,$modal,core){$scope.setSection("settings");$scope.loadProject($routeParams.slug);$scope.update=function(form){var res=$http.post(core.call("/projects/"+$scope.project.slug),$scope.project);res.success(function(data){$route.reload()});res.error(grano.handleFormError(form))};$scope.deleteProject=function(){var d=$modal.open({templateUrl:"projects/delete.html",controller:"ProjectsDeleteCtrl",resolve:{project:function(){return $scope.project}}})};$scope.truncateProject=function(){var d=$modal.open({templateUrl:"projects/truncate.html",controller:"ProjectsTruncateCtrl",resolve:{project:function(){return $scope.project}}})}}ProjectsEditCtrl.$inject=["$scope","$route","$routeParams","$location","$http","$modal","core"];function ProjectsDeleteCtrl($scope,$routeParams,$location,$http,$route,$modal,$modalInstance,project){$scope.project=project;$scope.cancel=function(){$modalInstance.dismiss("cancel")};$scope.delete=function(){var res=$http.delete($scope.project.api_url);res.error(function(data){$location.path("/");$modalInstance.dismiss("ok")})}}ProjectsDeleteCtrl.$inject=["$scope","$routeParams","$location","$http","$route","$modal","$modalInstance","project"];function ProjectsTruncateCtrl($scope,$routeParams,$location,$http,$route,$modal,$modalInstance,project){$scope.project=project;$scope.cancel=function(){$modalInstance.dismiss("cancel")};$scope.truncate=function(){var res=$http.delete($scope.project.api_url+"/_truncate");res.then(function(data){$modalInstance.dismiss("ok")})}}ProjectsTruncateCtrl.$inject=["$scope","$routeParams","$location","$http","$route","$modal","$modalInstance","project"];function SchemataIndexCtrl($scope,$routeParams,$location,$http,$modal,$timeout,core,session){$scope.setSection("schemata");$scope.loadProject($routeParams.slug);$scope.entity_schemata=[];$scope.relation_schemata=[];$http.get(core.call("/projects/"+$routeParams.slug+"/schemata"),{params:{limit:1e3}}).then(function(res){angular.forEach(res.data.results,function(e){if(e.obj=="entity"){if(e.name!="base"){$scope.entity_schemata.push(e)}}else{$scope.relation_schemata.push(e)}})})}SchemataIndexCtrl.$inject=["$scope","$routeParams","$location","$http","$modal","$timeout","core","session"];function SchemataViewCtrl($scope,$routeParams,$location,$http,$route,$modal,$timeout,schemata,core,session){$scope.setSection("schemata");$scope.loadProject($routeParams.slug);$scope.schema={};$scope.newAttributeBase={fresh:true,datatype:"string"};$scope.newAttribute=angular.copy($scope.newAttributeBase);if($routeParams.name){$http.get(core.call("/projects/"+$routeParams.slug+"/schemata/"+$routeParams.name)).then(function(res){$scope.schema=res.data;core.setTitle($scope.schema.label)})}else{$scope.schema={obj:$routeParams.obj,attributes:[],fresh:true,api_url:core.call("/projects/"+$routeParams.slug+"/schemata")};core.setTitle("New Schema")}$scope.addAttribute=function(){$scope.schema.attributes.push($scope.newAttribute);$scope.newAttribute=angular.copy($scope.newAttributeBase)};$scope.removeAttribute=function(attribute){var index=$scope.schema.attributes.indexOf(attribute);if(index>-1){$scope.schema.attributes.splice(index,1)}};$scope.update=function(form){var res=$http.post($scope.schema.api_url,$scope.schema);res.success(function(res){schemata.reset();if($scope.schema.fresh){$location.path("/p/"+$routeParams.slug+"/schemata/"+res.name)}else{$route.reload()}});res.error(grano.handleFormError(form))};$scope.reset=function(){$route.reload()};$scope.deleteSchema=function(){var d=$modal.open({templateUrl:"schemata/delete.html",controller:"SchemataDeleteCtrl",resolve:{schema:function(){return $scope.schema}}})}}SchemataViewCtrl.$inject=["$scope","$routeParams","$location","$http","$route","$modal","$timeout","schemata","core","session"];function SchemataDeleteCtrl($scope,$location,$modalInstance,$http,session,schema){$scope.schema=schema;$scope.cancel=function(){$modalInstance.dismiss("cancel")};$scope.delete=function(){var res=$http.delete($scope.schema.api_url);res.error(function(data){$modalInstance.dismiss("ok");$location.path("/p/"+$scope.schema.project.slug+"/schemata")})}}SchemataDeleteCtrl.$inject=["$scope","$location","$modalInstance","$http","session","schema"];function PermissionsIndexCtrl($scope,$routeParams,$location,$http,$modal,$q,$timeout,core,session){$scope.loadProject($routeParams.slug);$scope.url=core.call("/projects/"+$routeParams.slug+"/permissions");$scope.setSection("permissions");$scope.permissions={};$scope.newPermission={reader:true,editor:true};$scope.loadPermissions=function(url){$http.get(url).then(function(res){$scope.url=url;$scope.permissions=res.data})};$scope.save=function(permission){if(!permission.reader)permission.editor=false;if(!permission.editor)permission.admin=false;var res=$http.post(permission.api_url,permission);res.then(function(res){permission.reader=res.data.reader;permission.editor=res.data.editor;permission.admin=res.data.admin})};$scope.sanify=function(){if($scope.newPermission.admin)$scope.newPermission.editor=true;if($scope.newPermission.editor)$scope.newPermission.reader=true};$scope.create=function(){if(!$scope.canCreate()){return}var url=core.call("/projects/"+$routeParams.slug+"/permissions"),res=$http.post(url,$scope.newPermission);$scope.newPermission={reader:true};res.then(function(res){$scope.loadPermissions($scope.url)})};$scope.canCreate=function(){return $scope.newPermission.account};$scope.loadAccounts=function(query){var res=$http.get(core.call("/accounts/_suggest"),{params:{q:query}});return res.then(function(res){return res.data.results})};$scope.loadPermissions($scope.url)}PermissionsIndexCtrl.$inject=["$scope","$routeParams","$location","$http","$modal","$q","$timeout","core","session"];function EntitiesIndexCtrl($scope,$rootScope,$routeParams,$location,$http,$modal,$timeout,core,session){var params={project:$routeParams.slug,limit:25},filterTimeout=null;$scope.loadProject($routeParams.slug);$scope.setSection("entities");$scope.query={value:$location.search().q};$scope.project={};$scope.entities={};$scope.previewEntity=null;$http.get(core.call("/projects/"+$routeParams.slug)).then(function(res){$scope.project=res.data;core.setTitle($scope.project.label)});$scope.updateFilter=function(){if(filterTimeout){$timeout.cancel(filterTimeout)}filterTimeout=$timeout(function(){$location.search("q",$scope.query.value);$scope.updateSearch()},500)};$scope.updateSearch=function(){var fparams=angular.copy(params);angular.extend(fparams,$location.search());if(fparams.schema){$scope.setSection("entities."+fparams.schema)}else{$scope.setSection("entities")}$scope.loadEntities(core.call("/entities"),fparams)};$rootScope.$on("updateSearch",$scope.updateSearch);$scope.loadEntities=function(url,params){$scope.showEntityPreview(null);$http.get(url,{params:params}).then(function(res){$scope.entities=res.data})};$scope.showEntityPreview=function(entity){if(entity&&$scope.previewEntity!=null&&$scope.previewEntity.id==entity.id){$scope.previewEntity=null;$location.search("preview",null);core.setTitle($scope.project.label);return}if(entity&&$location.search().preview!=entity.id){$location.search("preview",entity.id)}$scope.previewEntity=entity};$scope.uploadFile=function(){var d=$modal.open({templateUrl:"imports/upload.html",controller:"ImportUploadCtrl",resolve:{project:function(){return $scope.project}}})};$scope.updateSearch();if($location.search().preview){$scope.showEntityPreview({id:$location.search().preview})}}EntitiesIndexCtrl.$inject=["$scope","$rootScope","$routeParams","$location","$http","$modal","$timeout","core","session"];function EntitiesViewCtrl($scope,$routeParams,$location,$http,$modal,core,session){$scope.setSection("entities");$scope.loadProject($routeParams.slug);$scope.entity={};$scope.reloadEntity=function(id){$http.get(core.call("/entities/"+id)).then(function(res){$scope.entity=res.data;core.setTitle(res.data.properties.name.value)})};$scope.deleteEntity=function(){var d=$modal.open({templateUrl:"entities/delete.html",controller:"EntitiesDeleteCtrl",resolve:{entity:function(){return $scope.entity}}})};$scope.reloadEntity($routeParams.id)}EntitiesViewCtrl.$inject=["$scope","$routeParams","$location","$http","$modal","core","session"];function EntitiesNewCtrl($scope,$routeParams,$location,$http,$modal,core,schemata){$scope.setSection("entities");$scope.loadProject($routeParams.slug);$scope.entity={project:$routeParams.slug,properties:{name:{value:null,datatype:"string",name:"name"}}};$scope.createEntity=function(form){$scope.$broadcast("save",$scope.entity);$scope.entity.schemata=[];angular.forEach($scope.entity.properties,function(p,k){var schema=$scope.attributes[k].schema.name;if(p.attribute){delete p.attribute}if($scope.entity.schemata.indexOf(schema)==-1){$scope.entity.schemata.push(schema)}});var res=$http.post(core.call("/entities"),$scope.entity);res.success(function(data){$location.path("/p/"+$scope.project.slug+"/entities/"+data.id)});res.error(grano.handleFormError(form))};$scope.canCreate=function(){return!$scope.entity.properties.name.value};schemata.attributes($routeParams.slug,"entity").then(function(attributes){$scope.attributes=attributes;$scope.entity.properties.name.attribute=attributes.name})}EntitiesNewCtrl.$inject=["$scope","$routeParams","$location","$http","$modal","core","schemata"];function EntitiesDeleteCtrl($scope,$routeParams,$location,$http,$route,$modal,$modalInstance,session,entity){$scope.entity=entity;$scope.cancel=function(){$modalInstance.dismiss("cancel")};$scope.delete=function(){var res=$http.delete($scope.entity.api_url);res.error(function(data){$modalInstance.dismiss("ok");$location.search("preview",null);$route.reload()})}}EntitiesDeleteCtrl.$inject=["$scope","$routeParams","$location","$http","$route","$modal","$modalInstance","session","entity"];function EntitiesMergeCtrl($scope,$routeParams,$location,$http,$route,$modal,$modalInstance,core,orig){$scope.merge={orig:orig,dest:null};$scope.project=orig.project;$scope.cancel=function(){$modalInstance.dismiss("cancel")};$scope.save=function(form){var res=$http.post(core.call("/entities/_merge"),$scope.merge);res.success(function(data){$location.path("/p/"+data.project.slug+"/entities/"+data.id);$modalInstance.dismiss("ok")});res.error(grano.handleFormError(form))}}EntitiesMergeCtrl.$inject=["$scope","$routeParams","$location","$http","$route","$modal","$modalInstance","core","orig"];function RelationsViewCtrl($scope,$routeParams,$location,$http,$modal,core,session){$scope.navSection="relations";$scope.loadProject($routeParams.slug);$scope.relation={};$scope.reloadRelation=function(id){$http.get(core.call("/relations/"+id)).then(function(res){$scope.relation=res.data;core.setTitle(res.data.schema.label)})};$scope.deleteRelation=function(){var after="/p/"+$scope.relation.project.slug+"/entities/"+$scope.relation.source.id;var d=$modal.open({templateUrl:"relations/delete.html",controller:"RelationsDeleteCtrl",resolve:{relation:function(){return $scope.relation}}});d.result.then(function(result){if(result=="ok"){$location.path(after)}})};$scope.reloadRelation($routeParams.id)}RelationsViewCtrl.$inject=["$scope","$routeParams","$location","$http","$modal","core","session"];function RelationsNewCtrl($scope,$routeParams,$modalInstance,$location,$http,core,schemata,project,source,target){$scope.relation={project:project,source:angular.copy(source),target:angular.copy(target)};$scope.project=project;$scope.source=source;$scope.target=target;$scope.cancel=function(){$modalInstance.dismiss("cancel")};$scope.create=function(form){var res=$http.post(core.call("/relations"),$scope.relation);res.success(function(data){$modalInstance.dismiss("ok");$location.path("/p/"+data.project.slug+"/relations/"+data.id)});res.error(grano.handleFormError(form))};schemata.get(project.slug).then(function(ss){$scope.schemata=[];angular.forEach(ss,function(s){if(s.obj=="relation"){$scope.schemata.push(s)}})})}RelationsNewCtrl.$inject=["$scope","$routeParams","$modalInstance","$location","$http","core","schemata","project","source","target"];function RelationsDeleteCtrl($scope,$routeParams,$location,$http,$route,$modal,$modalInstance,session,relation){$scope.relation=relation;$scope.cancel=function(){$modalInstance.close("cancel")};$scope.delete=function(){var url="/p/"+$scope.relation.project.slug;var res=$http.delete($scope.relation.api_url);res.error(function(data){$modalInstance.close("ok")})}}RelationsDeleteCtrl.$inject=["$scope","$routeParams","$location","$http","$route","$modal","$modalInstance","session","relation"];function ImportIndexCtrl($scope,$rootScope,$routeParams,$location,$http,$modal,$interval,core,session){var pipelinesUrl=core.call("/pipelines"),pipelinesParams={project:$routeParams.slug,operation:"import",limit:10};$scope.loadProject($routeParams.slug);$scope.setSection("import");$scope.pipelines={};$scope.loadPipelines=function(url){pipelinesUrl=url;$http.get(url,{params:pipelinesParams}).then(function(data){$scope.pipelines=data.data})};$scope.loadPipelines(pipelinesUrl);$scope.uploadFile=function(){var d=$modal.open({templateUrl:"imports/upload.html",controller:"ImportUploadCtrl",resolve:{project:function(){return $scope.project}}})}}ImportIndexCtrl.$inject=["$scope","$rootScope","$routeParams","$location","$http","$modal","$interval","core","session"];function ImportUploadCtrl($scope,$rootScope,$routeParams,$location,$http,$modalInstance,$timeout,$upload,core,project){$scope.file=null;$scope.uploadProgress=null;$scope.cancel=function(){$modalInstance.dismiss("cancel")
};$scope.upload=function(){$scope.uploadProgress=1;$scope.upload=$upload.upload({url:core.call("/files"),data:{project:project.slug},file:$scope.file}).progress(function(evt){$scope.uploadProgress=parseInt(100*evt.loaded/evt.total)}).success(function(data,status,headers,config){$modalInstance.dismiss("ok");$location.search({file:data.id});$location.path("/p/"+project.slug+"/import/modes");$scope.uploadProgress=null})};$scope.onFileSelect=function($files){if($files.length>0){$scope.file=$files[0]}}}ImportUploadCtrl.$inject=["$scope","$rootScope","$routeParams","$location","$http","$modalInstance","$timeout","$upload","core","project"];function ImportModesCtrl($scope,$rootScope,$routeParams,$location,$http,$modal,$timeout,core,schemata){$scope.loadProject($routeParams.slug);$scope.setSection("import");$scope.validFile=true;$scope.relationSchema=null;$scope.relationSchemaOptions=[];$scope.data={mode:$location.search().mode};$scope.uploadFile=function(){var d=$modal.open({templateUrl:"imports/upload.html",controller:"ImportUploadCtrl",resolve:{project:function(){return $scope.project}}})};$scope.defineMapping=function(){$location.search({file:$location.search().file,mode:$scope.data.mode,schema:$scope.relationSchema});$location.path("/p/"+$scope.project.slug+"/import/mapping")};$scope.canRelationsMode=function(){return $scope.relationSchemaOptions.length>0};schemata.get($routeParams.slug).then(function(schemata){angular.forEach(schemata,function(s){if(s.obj=="relation"){$scope.relationSchemaOptions.push(s)}});if($scope.relationSchemaOptions.length>0){$scope.relationSchema=$scope.relationSchemaOptions[0].name}if($location.search().schema){$scope.relationSchema=$location.search().schema}});var url=core.call("/files/"+$location.search().file+"/_table?limit=0");var res=$http.get(url).then(function(data){$scope.validData=!data.data.status||data.data.status!="error"})}ImportModesCtrl.$inject=["$scope","$rootScope","$routeParams","$location","$http","$modal","$timeout","core","schemata"];function ImportMappingCtrl($scope,$rootScope,$routeParams,$location,$http,$modal,$timeout,$filter,$q,core,schemata){$scope.loadProject($routeParams.slug);$scope.setSection("import");$scope.truncate=$filter("truncate");var relationAttributes=[],entityAttributes=[],selectBase=[{name:"",label:"Don't import"},{name:"_source_url",label:"Source URL (for this data)"}];$scope.mode=$location.search().mode;$scope.editMode=$scope.mode=="relations"?"object":"attribute";$scope.request={source_url:null};$scope.mapping={};var url=core.call("/files/"+$location.search().file+"/_table?limit=3");var res=$http.get(url).then(function(data){$scope.sampleData=data.data;angular.forEach($scope.sampleData.headers,function(header){$scope.mapping[header]={attribute:"",object:""}})});$scope.defineMapping=function(){$location.path("/p/"+$scope.project.slug+"/import/modes")};$scope.beginImport=function(){$scope.request.mode=$scope.mode;$scope.request.relation_schema=$location.search().schema;$scope.request.file=$location.search().file;$scope.request.mapping={};angular.forEach($scope.mapping,function(v,k){if(v.attribute.length>0){$scope.request.mapping[k]=v}});var url=core.call("/projects/"+$scope.project.slug+"/_import");var res=$http.post(url,$scope.request);res.then(function(data){$location.path("/p/"+$scope.project.slug+"/import");$location.search({})})};$scope.attributeChoices=function(header){if($scope.mode=="aliases"){var options=[{name:"alias",label:"Alternate name"},{name:"canonical",label:"Preferred name"}];return selectBase.concat(options)}else if($scope.mode=="entities"||$scope.mapping[header].object!="relation"){return selectBase.concat(entityAttributes)}return selectBase.concat(relationAttributes)};$scope.validateObjects=function(){var source=false,target=false;angular.forEach($scope.mapping,function(v){if(v.object=="source")source=true;if(v.object=="target")target=true});return source&&target};$scope.validateAttributes=function(){var required=[{o:"",a:"alias"},{o:"",a:"canonical"}];if($scope.mode=="entities"){required=[{o:"",a:"name"}]}else if($scope.mode=="relations"){required=[{o:"source",a:"name"},{o:"target",a:"name"}]}var matches=0;angular.forEach($scope.mapping,function(v){angular.forEach(required,function(r){if(v.attribute==r.a&&v.object==r.o)matches++})});return matches==required.length};var init=function(){schemata.attributes($routeParams.slug,"entity").then(function(attributes){entityAttributes=[];angular.forEach(attributes,function(a){a.label=$scope.truncate(a.label,20);entityAttributes.push(a)})});schemata.attributes($routeParams.slug,"relation").then(function(attributes){relationAttributes=[];angular.forEach(attributes,function(a){if(a.schema.name==$location.search().schema){a.label=$scope.truncate(a.label,20);relationAttributes.push(a)}})})};init()}ImportMappingCtrl.$inject=["$scope","$rootScope","$routeParams","$location","$http","$modal","$timeout","$filter","$q","core","schemata"];function PropertiesEditCtrl($scope,$location,$modalInstance,$http,$route,schemata,obj,attribute){$scope.obj=obj;$scope.property={fresh:true,attribute:attribute};$scope.attributeChoices=[];$scope.cancel=function(){$modalInstance.dismiss("cancel")};$scope.update=function(form){var attr=$scope.property.attribute;delete $scope.property.attribute;if(!angular.isUndefined($scope.obj.schemata)){$scope.obj.schemata.push(attr.schema.name)}$scope.obj.properties[attr.name]=$scope.property;var res=$http.post($scope.obj.api_url,$scope.obj);res.success(function(data){$modalInstance.dismiss("ok")});res.error(grano.handleFormError(form))};if(attribute){$scope.property=obj.properties[attribute.name]||{};$scope.property.attribute=attribute}else{var obj_type=$scope.obj.schema?"relation":"entity";schemata.attributes(obj.project.slug,obj_type).then(function(as){angular.forEach(as,function(k,v){if(angular.isUndefined($scope.obj.properties[v])){$scope.attributeChoices.push(k)}})})}}PropertiesEditCtrl.$inject=["$scope","$location","$modalInstance","$http","$route","schemata","obj","attribute"];