"""transform the account

Revision ID: 3c486a5dcceb
Revises: 2b65d3dfa1de
Create Date: 2014-02-25 14:09:45.192072

"""

# revision identifiers, used by Alembic.
revision = '3c486a5dcceb'
down_revision = '2b65d3dfa1de'

from alembic import op
import sqlalchemy as sa


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.add_column('account', sa.Column('facebook_id', sa.Unicode(), nullable=True))
    op.add_column('account', sa.Column('full_name', sa.Unicode(), nullable=True))
    op.add_column('account', sa.Column('twitter_id', sa.Unicode(), nullable=True))
    op.create_index('ix_property_entity_id', 'property', ['entity_id'], unique=False)
    op.create_index('ix_property_name', 'property', ['name'], unique=False)
    op.create_index('ix_property_relation_id', 'property', ['relation_id'], unique=False)
    op.create_index('ix_relation_schema_id', 'relation', ['schema_id'], unique=False)
    op.create_index('ix_relation_source_id', 'relation', ['source_id'], unique=False)
    op.create_index('ix_relation_target_id', 'relation', ['target_id'], unique=False)
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_relation_target_id', table_name='relation')
    op.drop_index('ix_relation_source_id', table_name='relation')
    op.drop_index('ix_relation_schema_id', table_name='relation')
    op.drop_index('ix_property_relation_id', table_name='property')
    op.drop_index('ix_property_name', table_name='property')
    op.drop_index('ix_property_entity_id', table_name='property')
    op.drop_column('account', 'twitter_id')
    op.drop_column('account', 'full_name')
    op.drop_column('account', 'facebook_id')
    ### end Alembic commands ###
