#!/usr/bin/env python
"""
WordAPI.py
Copyright 2012 Wordnik, Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

from .models import *


class DocApi(object):

    def __init__(self, apiClient):
      self.apiClient = apiClient
      self.__basePath = "https://api.groupdocs.com/v2.0"

    @property
    def basePath(self):
        return self.__basePath
    
    @basePath.setter
    def basePath(self, value):
        self.__basePath = value

    
    def ViewDocument(self, userId, fileId, pageNumber, pageCount, width, quality, usePdf, **kwargs):
        """View Document

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            pageNumber, str: Page Number (optional)
            pageCount, str: Page Count (optional)
            width, str: Width (optional)
            quality, str: Quality (optional)
            usePdf, str: Use Pdf (optional)
            
        Returns: ViewDocumentResponse
        """

        allParams = ['userId', 'fileId', 'pageNumber', 'pageCount', 'width', 'quality', 'usePdf']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ViewDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/thumbnails?page_number={pageNumber}&amp;page_count={pageCount}&amp;width={width}&amp;quality={quality}&amp;use_pdf={usePdf}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('pageNumber' in params):
            replacement = str(self.apiClient.toPathValue(params['pageNumber']))
            resourcePath = resourcePath.replace('{' + 'pageNumber' + '}',
                                                replacement)
        if ('pageCount' in params):
            replacement = str(self.apiClient.toPathValue(params['pageCount']))
            resourcePath = resourcePath.replace('{' + 'pageCount' + '}',
                                                replacement)
        if ('width' in params):
            replacement = str(self.apiClient.toPathValue(params['width']))
            resourcePath = resourcePath.replace('{' + 'width' + '}',
                                                replacement)
        if ('quality' in params):
            replacement = str(self.apiClient.toPathValue(params['quality']))
            resourcePath = resourcePath.replace('{' + 'quality' + '}',
                                                replacement)
        if ('usePdf' in params):
            replacement = str(self.apiClient.toPathValue(params['usePdf']))
            resourcePath = resourcePath.replace('{' + 'usePdf' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'ViewDocumentResponse')
        return responseObject
        
        
    def GetDocumentViews(self, userId, startIndex, pageSize, **kwargs):
        """Get Document Views

        Args:
            userId, str: User GUID (required)
            startIndex, str: A historical view entry to start from. Historical entries are sorted from the recent to old ones (optional)
            pageSize, str: The total number of requested entries. If pageSize is equal to -1, all available entries will be returned (optional)
            
        Returns: DocumentViewsResponse
        """

        allParams = ['userId', 'startIndex', 'pageSize']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentViews" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/views?page_index={startIndex}&amp;page_size={pageSize}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('startIndex' in params):
            replacement = str(self.apiClient.toPathValue(params['startIndex']))
            resourcePath = resourcePath.replace('{' + 'startIndex' + '}',
                                                replacement)
        if ('pageSize' in params):
            replacement = str(self.apiClient.toPathValue(params['pageSize']))
            resourcePath = resourcePath.replace('{' + 'pageSize' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DocumentViewsResponse')
        return responseObject
        
        
    def ShareDocument(self, userId, fileId, body, **kwargs):
        """Share document

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            body, List[str]: Sharers (required)
            
        Returns: SharedUsersResponse
        """

        allParams = ['userId', 'fileId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ShareDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/sharers'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SharedUsersResponse')
        return responseObject
        
        
    def UnshareDocument(self, userId, fileId, **kwargs):
        """Unshare document

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            
        Returns: SharedUsersResponse
        """

        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UnshareDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/sharers'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SharedUsersResponse')
        return responseObject
        
        
    def GetFolderSharers(self, userId, folderId, **kwargs):
        """Get folder sharers

        Args:
            userId, str: User GUID (required)
            folderId, str: Folder Id (required)
            
        Returns: SharedUsersResponse
        """

        allParams = ['userId', 'folderId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetFolderSharers" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/folders/{folderId}/sharers'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('folderId' in params):
            replacement = str(self.apiClient.toPathValue(params['folderId']))
            resourcePath = resourcePath.replace('{' + 'folderId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SharedUsersResponse')
        return responseObject
        
        
    def ShareFolder(self, userId, folderId, body, **kwargs):
        """Share folder

        Args:
            userId, str: User GUID (required)
            folderId, str: Folder Id (required)
            body, List[str]: Sharers (required)
            
        Returns: SharedUsersResponse
        """

        allParams = ['userId', 'folderId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ShareFolder" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/folders/{folderId}/sharers'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('folderId' in params):
            replacement = str(self.apiClient.toPathValue(params['folderId']))
            resourcePath = resourcePath.replace('{' + 'folderId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SharedUsersResponse')
        return responseObject
        
        
    def UnshareFolder(self, userId, folderId, **kwargs):
        """Unshare folder

        Args:
            userId, str: User GUID (required)
            folderId, str: Folder Id (required)
            
        Returns: SharedUsersResponse
        """

        allParams = ['userId', 'folderId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UnshareFolder" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/folders/{folderId}/sharers'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('folderId' in params):
            replacement = str(self.apiClient.toPathValue(params['folderId']))
            resourcePath = resourcePath.replace('{' + 'folderId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SharedUsersResponse')
        return responseObject
        
        
    def SetDocumentAccessMode(self, userId, fileId, mode, **kwargs):
        """Set document access mode

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            mode, str: Mode (optional)
            
        Returns: DocumentAccessInfoResponse
        """

        allParams = ['userId', 'fileId', 'mode']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method SetDocumentAccessMode" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/accessinfo?mode={mode}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('mode' in params):
            replacement = str(self.apiClient.toPathValue(params['mode']))
            resourcePath = resourcePath.replace('{' + 'mode' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DocumentAccessInfoResponse')
        return responseObject
        
        
    def GetDocumentAccessInfo(self, userId, fileId, **kwargs):
        """Get document access info

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            
        Returns: DocumentAccessInfoResponse
        """

        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentAccessInfo" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/accessinfo'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DocumentAccessInfoResponse')
        return responseObject
        
        
    def GetDocumentMetadata(self, userId, fileId, **kwargs):
        """Get document metadata

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            
        Returns: GetDocumentInfoResponse
        """

        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentMetadata" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/metadata'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetDocumentInfoResponse')
        return responseObject
        
        
    def GetDocumentMetadataByPath(self, userId, path, **kwargs):
        """Returns document metadata

        Args:
            userId, str: User GUID (required)
            path, str: File path to return metadata for (required)
            
        Returns: GetDocumentInfoResponse
        """

        allParams = ['userId', 'path']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentMetadataByPath" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{*path}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('path' in params):
            replacement = str(self.apiClient.toPathValue(params['path']))
            resourcePath = resourcePath.replace('{' + 'path' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetDocumentInfoResponse')
        return responseObject
        
        
    def SetDocumentUserStatus(self, userId, fileId, status, **kwargs):
        """Set document user status

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            status, str: Status (required)
            
        Returns: DocumentUserStatusResponse
        """

        allParams = ['userId', 'fileId', 'status']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method SetDocumentUserStatus" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/sharer'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('status' in params):
            replacement = str(self.apiClient.toPathValue(params['status']))
            resourcePath = resourcePath.replace('{' + 'status' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DocumentUserStatusResponse')
        return responseObject
        
        
    def GetSharedDocuments(self, userId, sharesTypes, pageIndex, pageSize, orderBy, orderAsc, **kwargs):
        """Get shared documents

        Args:
            userId, str: User GUID (required)
            sharesTypes, str: Shares types (optional)
            pageIndex, str: Page index (optional)
            pageSize, str: Page size (optional)
            orderBy, str: Order by (optional)
            orderAsc, bool: Order asc (optional)
            
        Returns: SharedDocumentsResponse
        """

        allParams = ['userId', 'sharesTypes', 'pageIndex', 'pageSize', 'orderBy', 'orderAsc']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSharedDocuments" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/shares/{sharesTypes}?page_index={pageIndex}&amp;page_size={pageSize}&amp;order_by={orderBy}&amp;order_asc={orderAsc}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('sharesTypes' in params):
            replacement = str(self.apiClient.toPathValue(params['sharesTypes']))
            resourcePath = resourcePath.replace('{' + 'sharesTypes' + '}',
                                                replacement)
        if ('pageIndex' in params):
            replacement = str(self.apiClient.toPathValue(params['pageIndex']))
            resourcePath = resourcePath.replace('{' + 'pageIndex' + '}',
                                                replacement)
        if ('pageSize' in params):
            replacement = str(self.apiClient.toPathValue(params['pageSize']))
            resourcePath = resourcePath.replace('{' + 'pageSize' + '}',
                                                replacement)
        if ('orderBy' in params):
            replacement = str(self.apiClient.toPathValue(params['orderBy']))
            resourcePath = resourcePath.replace('{' + 'orderBy' + '}',
                                                replacement)
        if ('orderAsc' in params):
            replacement = str(self.apiClient.toPathValue(params['orderAsc']))
            resourcePath = resourcePath.replace('{' + 'orderAsc' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SharedDocumentsResponse')
        return responseObject
        
        
    def GetTemplateFields(self, userId, fileId, includeGeometry, **kwargs):
        """Get template fields

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            includeGeometry, bool: Include geometry (optional)
            
        Returns: TemplateFieldsResponse
        """

        allParams = ['userId', 'fileId', 'includeGeometry']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetTemplateFields" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/fields?include_geometry={includeGeometry}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('includeGeometry' in params):
            replacement = str(self.apiClient.toPathValue(params['includeGeometry']))
            resourcePath = resourcePath.replace('{' + 'includeGeometry' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'TemplateFieldsResponse')
        return responseObject
        
        
    def GetDocumentFormats(self, userId, fileId, **kwargs):
        """Get document formats

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            
        Returns: GetDocumentForeignTypesResponse
        """

        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentFormats" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/formats'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetDocumentForeignTypesResponse')
        return responseObject
        
        
    def GetDocumentPageImage(self, userId, fileId, pageNumber, dimension, quality, usePdf, expiresOn, **kwargs):
        """Returns a stream of bytes representing a particular document page image.

        Args:
            userId, str: GroupDocs user global unique identifier. (required)
            fileId, str: Document global unique identifier. (required)
            pageNumber, int: Document page number to get image for. (required)
            dimension, str: Image dimension in format '&lt;width&gt;x&lt;height&gt;' (one or both values can be omitted). (required)
            quality, int: Image qualiry in range 1-100. (optional)
            usePdf, bool: A flag indicating whether a document should be converted to PDF format before generating the image. (optional)
            expiresOn, bool: The date and time in milliseconds since epoch the URL expires. (optional)
            
        Returns: stream
        """

        allParams = ['userId', 'fileId', 'pageNumber', 'dimension', 'quality', 'usePdf', 'expiresOn']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentPageImage" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/pages/{pageNumber}/images/{dimension}?quality={quality}&amp;use_pdf={usePdf}&amp;expires={expiresOn}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('pageNumber' in params):
            replacement = str(self.apiClient.toPathValue(params['pageNumber']))
            resourcePath = resourcePath.replace('{' + 'pageNumber' + '}',
                                                replacement)
        if ('dimension' in params):
            replacement = str(self.apiClient.toPathValue(params['dimension']))
            resourcePath = resourcePath.replace('{' + 'dimension' + '}',
                                                replacement)
        if ('quality' in params):
            replacement = str(self.apiClient.toPathValue(params['quality']))
            resourcePath = resourcePath.replace('{' + 'quality' + '}',
                                                replacement)
        if ('usePdf' in params):
            replacement = str(self.apiClient.toPathValue(params['usePdf']))
            resourcePath = resourcePath.replace('{' + 'usePdf' + '}',
                                                replacement)
        if ('expiresOn' in params):
            replacement = str(self.apiClient.toPathValue(params['expiresOn']))
            resourcePath = resourcePath.replace('{' + 'expiresOn' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'stream')
        return responseObject
        
        
    def GetDocumentPagesImageUrls(self, userId, fileId, firstPage, pageCount, dimension, quality, usePdf, token, **kwargs):
        """Returns a list of URLs pointing to document page images.

        Args:
            userId, str: GroupDocs user global unique identifier. (required)
            fileId, str: Document global unique identifier. (required)
            firstPage, int: Document page number to start from. (optional)
            pageCount, int: Page count to return URLs for. (optional)
            dimension, str: Image dimension in format '&lt;width&gt;x&lt;height&gt;' (one or both values can be omitted). (required)
            quality, int: Image qualiry in range 1-100. (optional)
            usePdf, bool: A flag indicating whether a document should be converted to PDF format before generating the image. (optional)
            token, str: A document viewer session token returned by the View Document request. (optional)
            
        Returns: GetImageUrlsResponse
        """

        allParams = ['userId', 'fileId', 'firstPage', 'pageCount', 'dimension', 'quality', 'usePdf', 'token']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentPagesImageUrls" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/pages/images/{dimension}/urls?first_page={firstPage}&amp;page_count={pageCount}&amp;quality={quality}&amp;use_pdf={usePdf}&amp;token={token}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('firstPage' in params):
            replacement = str(self.apiClient.toPathValue(params['firstPage']))
            resourcePath = resourcePath.replace('{' + 'firstPage' + '}',
                                                replacement)
        if ('pageCount' in params):
            replacement = str(self.apiClient.toPathValue(params['pageCount']))
            resourcePath = resourcePath.replace('{' + 'pageCount' + '}',
                                                replacement)
        if ('dimension' in params):
            replacement = str(self.apiClient.toPathValue(params['dimension']))
            resourcePath = resourcePath.replace('{' + 'dimension' + '}',
                                                replacement)
        if ('quality' in params):
            replacement = str(self.apiClient.toPathValue(params['quality']))
            resourcePath = resourcePath.replace('{' + 'quality' + '}',
                                                replacement)
        if ('usePdf' in params):
            replacement = str(self.apiClient.toPathValue(params['usePdf']))
            resourcePath = resourcePath.replace('{' + 'usePdf' + '}',
                                                replacement)
        if ('token' in params):
            replacement = str(self.apiClient.toPathValue(params['token']))
            resourcePath = resourcePath.replace('{' + 'token' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetImageUrlsResponse')
        return responseObject
        
        
    def GetEditLock(self, userId, fileId, **kwargs):
        """Locks a document for editing and returns editing metadata.

        Args:
            userId, str: GroupDocs user global unique identifier. (required)
            fileId, str: Document global unique identifier. (required)
            
        Returns: GetEditLockResponse
        """

        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetEditLock" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/editlock'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetEditLockResponse')
        return responseObject
        
        
    def RemoveEditLock(self, userId, fileId, **kwargs):
        """Removes edit lock for a document and replaces the document with its edited copy.

        Args:
            userId, str: GroupDocs user global unique identifier. (required)
            fileId, str: Document global unique identifier. (required)
            
        Returns: RemoveEditLockResponse
        """

        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method RemoveEditLock" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/editlock'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'RemoveEditLockResponse')
        return responseObject
        
        
    


