#!/usr/bin/env python
"""
WordAPI.py
Copyright 2012 Wordnik, Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

from .models import *


class MgmtApi(object):

    def __init__(self, apiClient):
      self.apiClient = apiClient
      self.__basePath = "https://api.groupdocs.com/v2.0"

    @property
    def basePath(self):
        return self.__basePath
    
    @basePath.setter
    def basePath(self, value):
        self.__basePath = value

    
    def GetUserProfile(self, userId, **kwargs):
        """Get user profile

        Args:
            userId, str: User GUID (required)
            
        Returns: UserInfoResponse
        """

        allParams = ['userId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetUserProfile" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{userId}/profile'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UserInfoResponse')
        return responseObject
        
        
    def UpdateUserProfile(self, userId, body, **kwargs):
        """Update user profile

        Args:
            userId, str: User GUID (required)
            body, UserInfo: Info (required)
            
        Returns: UpdateUserResponse
        """

        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateUserProfile" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{userId}/profile'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UpdateUserResponse')
        return responseObject
        
        
    def ChangeUserPassword(self, userId, body, **kwargs):
        """Change user password

        Args:
            userId, str: User GUID (required)
            body, UserPasswordInfo: Password (required)
            
        Returns: ChangePasswordResponse
        """

        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ChangeUserPassword" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{userId}/profile/password'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'ChangePasswordResponse')
        return responseObject
        
        
    def GetUserProfileByResetToken(self, callerId, token, **kwargs):
        """Get user profile by reset token

        Args:
            callerId, str: Caller GUID (required)
            token, str: Token (required)
            
        Returns: UserInfoResponse
        """

        allParams = ['callerId', 'token']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetUserProfileByResetToken" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{callerId}/reset-tokens?token={token}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        if ('token' in params):
            replacement = str(self.apiClient.toPathValue(params['token']))
            resourcePath = resourcePath.replace('{' + 'token' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UserInfoResponse')
        return responseObject
        
        
    def GetUserProfileByVerifToken(self, callerId, token, **kwargs):
        """Get user profile by verif token

        Args:
            callerId, str: Caller GUID (required)
            token, str: Token (required)
            
        Returns: UserInfoResponse
        """

        allParams = ['callerId', 'token']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetUserProfileByVerifToken" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{callerId}/verif-tokens?token={token}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        if ('token' in params):
            replacement = str(self.apiClient.toPathValue(params['token']))
            resourcePath = resourcePath.replace('{' + 'token' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UserInfoResponse')
        return responseObject
        
        
    def GetUserProfileByClaimedToken(self, callerId, token, **kwargs):
        """Get user profile by claimed token

        Args:
            callerId, str: Caller GUID (required)
            token, str: Token (required)
            
        Returns: UserInfoResponse
        """

        allParams = ['callerId', 'token']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetUserProfileByClaimedToken" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{callerId}/claimed-tokens?token={token}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        if ('token' in params):
            replacement = str(self.apiClient.toPathValue(params['token']))
            resourcePath = resourcePath.replace('{' + 'token' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UserInfoResponse')
        return responseObject
        
        
    def GetAlienUserProfile(self, callerId, userId, **kwargs):
        """Get alien user profile

        Args:
            callerId, str: Caller GUID (required)
            userId, str: User GUID (required)
            
        Returns: UserInfoResponse
        """

        allParams = ['callerId', 'userId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetAlienUserProfile" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{callerId}/users/{userId}/profile'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UserInfoResponse')
        return responseObject
        
        
    def UpdateAlienUserProfile(self, callerId, userId, body, **kwargs):
        """Update alien user profile

        Args:
            callerId, str: Caller GUID (required)
            userId, str: User GUID (required)
            body, UserInfo: Info (required)
            
        Returns: UpdateUserResponse
        """

        allParams = ['callerId', 'userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateAlienUserProfile" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{callerId}/users/{userId}/profile'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UpdateUserResponse')
        return responseObject
        
        
    def CreateUser(self, callerId, body, **kwargs):
        """Create user

        Args:
            callerId, str: Caller GUID (required)
            body, UserInfo: Payload (required)
            
        Returns: CreateUserResponse
        """

        allParams = ['callerId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CreateUser" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{callerId}/users'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'CreateUserResponse')
        return responseObject
        
        
    def CreateUserLogin(self, callerId, userId, password, **kwargs):
        """Create user login

        Args:
            callerId, str: Caller GUID (required)
            userId, str: User GUID (required)
            password, str: Password (required)
            
        Returns: UserInfoResponse
        """

        allParams = ['callerId', 'userId', 'password']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CreateUserLogin" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{callerId}/users/{userId}/logins'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('password' in params):
            replacement = str(self.apiClient.toPathValue(params['password']))
            resourcePath = resourcePath.replace('{' + 'password' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UserInfoResponse')
        return responseObject
        
        
    def ChangeAlienUserPassword(self, callerId, userId, body, **kwargs):
        """Change alien user password

        Args:
            callerId, str: Caller GUID (required)
            userId, str: User GUID (required)
            body, UserPasswordInfo: Password (required)
            
        Returns: ChangePasswordResponse
        """

        allParams = ['callerId', 'userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ChangeAlienUserPassword" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{callerId}/users/{userId}/password'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'ChangePasswordResponse')
        return responseObject
        
        
    def ResetUserPassword(self, callerId, userId, **kwargs):
        """Reset user password

        Args:
            callerId, str: Caller GUID (required)
            userId, str: User GUID (required)
            
        Returns: ResetPasswordResponse
        """

        allParams = ['callerId', 'userId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ResetUserPassword" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{callerId}/users/{userId}/password'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'ResetPasswordResponse')
        return responseObject
        
        
    def GetStorageProviders(self, userId, **kwargs):
        """Returns user's storage providers.

        Args:
            userId, str: User GUID (required)
            
        Returns: GetStorageProvidersResponse
        """

        allParams = ['userId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetStorageProviders" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{userId}/storages'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetStorageProvidersResponse')
        return responseObject
        
        
    def AddStorageProvider(self, userId, provider, body, **kwargs):
        """Adds a new storage provider configuration.

        Args:
            userId, str: User GUID (required)
            provider, str: Storage provider name (required)
            body, StorageProviderInfo: Storage provider configuration details (required)
            
        Returns: AddStorageProviderResponse
        """

        allParams = ['userId', 'provider', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddStorageProvider" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{userId}/storages/{provider}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('provider' in params):
            replacement = str(self.apiClient.toPathValue(params['provider']))
            resourcePath = resourcePath.replace('{' + 'provider' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddStorageProviderResponse')
        return responseObject
        
        
    def UpdateStorageProvider(self, userId, provider, body, **kwargs):
        """Updates user's storage provider configuration.

        Args:
            userId, str: User GUID (required)
            provider, str: Storage provider name (required)
            body, StorageProviderInfo: Storage provider configuration details (required)
            
        Returns: UpdateStorageProviderResponse
        """

        allParams = ['userId', 'provider', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateStorageProvider" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{userId}/storages/{provider}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('provider' in params):
            replacement = str(self.apiClient.toPathValue(params['provider']))
            resourcePath = resourcePath.replace('{' + 'provider' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UpdateStorageProviderResponse')
        return responseObject
        
        
    def GetRoles(self, userId, **kwargs):
        """Returns a list of user roles.

        Args:
            userId, str: User GUID (required)
            
        Returns: GetRolesResponse
        """

        allParams = ['userId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetRoles" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{userId}/roles'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetRolesResponse')
        return responseObject
        
        
    def GetUserRoles(self, callerId, userId, **kwargs):
        """Returns a list of user roles.

        Args:
            callerId, str: Caller GUID (required)
            userId, str: User GUID (required)
            
        Returns: GetRolesResponse
        """

        allParams = ['callerId', 'userId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetUserRoles" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{callerId}/users/{userId}/roles'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetRolesResponse')
        return responseObject
        
        
    def SetUserRoles(self, callerId, userId, body, **kwargs):
        """Set user roles.

        Args:
            callerId, str: Caller GUID (required)
            userId, str: User GUID (required)
            body, List[RoleInfo]: A list of user roles (required)
            
        Returns: SetUserRolesResponse
        """

        allParams = ['callerId', 'userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method SetUserRoles" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{callerId}/users/{userId}/roles'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SetUserRolesResponse')
        return responseObject
        
        
    def GetAccount(self, userId, **kwargs):
        """Returns an account information.

        Args:
            userId, str: User GUID (required)
            
        Returns: GetAccountResponse
        """

        allParams = ['userId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetAccount" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{userId}/account'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetAccountResponse')
        return responseObject
        
        
    def DeleteAccount(self, userId, **kwargs):
        """Closes user's account.

        Args:
            userId, str: User global unique identifier (required)
            
        Returns: DeleteAccountResponse
        """

        allParams = ['userId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteAccount" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{userId}/account'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteAccountResponse')
        return responseObject
        
        
    def GetAccountUsers(self, adminId, **kwargs):
        """Returns account user list.

        Args:
            adminId, str: Administrator GUID (required)
            
        Returns: GetAccountUsersResponse
        """

        allParams = ['adminId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetAccountUsers" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{adminId}/account/users'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('adminId' in params):
            replacement = str(self.apiClient.toPathValue(params['adminId']))
            resourcePath = resourcePath.replace('{' + 'adminId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetAccountUsersResponse')
        return responseObject
        
        
    def UpdateAccountUser(self, adminId, userName, body, **kwargs):
        """Create or update account user.

        Args:
            adminId, str: Administrator GUID (required)
            userName, str: User name (required)
            body, UserInfo: User details (required)
            
        Returns: UpdateAccountUserResponse
        """

        allParams = ['adminId', 'userName', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateAccountUser" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{adminId}/account/users/{userName}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('adminId' in params):
            replacement = str(self.apiClient.toPathValue(params['adminId']))
            resourcePath = resourcePath.replace('{' + 'adminId' + '}',
                                                replacement)
        if ('userName' in params):
            replacement = str(self.apiClient.toPathValue(params['userName']))
            resourcePath = resourcePath.replace('{' + 'userName' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UpdateAccountUserResponse')
        return responseObject
        
        
    def DeleteAccountUser(self, adminId, userName, **kwargs):
        """Delete account user.

        Args:
            adminId, str: Administrator GUID (required)
            userName, str: User name (required)
            
        Returns: DeleteAccountUserResponse
        """

        allParams = ['adminId', 'userName']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteAccountUser" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{adminId}/account/users/{userName}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('adminId' in params):
            replacement = str(self.apiClient.toPathValue(params['adminId']))
            resourcePath = resourcePath.replace('{' + 'adminId' + '}',
                                                replacement)
        if ('userName' in params):
            replacement = str(self.apiClient.toPathValue(params['userName']))
            resourcePath = resourcePath.replace('{' + 'userName' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteAccountUserResponse')
        return responseObject
        
        
    def GetUserEmbedKey(self, userId, area, **kwargs):
        """Returns active user embed key.

        Args:
            userId, str: User GUID (required)
            area, str: Application area where the key is (required)
            
        Returns: GetUserEmbedKeyResponse
        """

        allParams = ['userId', 'area']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetUserEmbedKey" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{userId}/embedkey/{area}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('area' in params):
            replacement = str(self.apiClient.toPathValue(params['area']))
            resourcePath = resourcePath.replace('{' + 'area' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetUserEmbedKeyResponse')
        return responseObject
        
        
    def GetUserEmbedKeyFromGuid(self, callerId, guid, **kwargs):
        """Returns embed key by GUID.

        Args:
            callerId, str: UserId invoked the service (required)
            guid, str: Key GUID (required)
            
        Returns: GetUserEmbedKeyResponse
        """

        allParams = ['callerId', 'guid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetUserEmbedKeyFromGuid" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{callerId}/embedkey/guid/{guid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        if ('guid' in params):
            replacement = str(self.apiClient.toPathValue(params['guid']))
            resourcePath = resourcePath.replace('{' + 'guid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetUserEmbedKeyResponse')
        return responseObject
        
        
    def GenerateKeyForUser(self, userId, area, **kwargs):
        """Generates new active user embed key.

        Args:
            userId, str: User GUID (required)
            area, str: Application area where the key is (required)
            
        Returns: GetUserEmbedKeyResponse
        """

        allParams = ['userId', 'area']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GenerateKeyForUser" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/mgmt/{userId}/embedkey/new/{area}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('area' in params):
            replacement = str(self.apiClient.toPathValue(params['area']))
            resourcePath = resourcePath.replace('{' + 'area' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetUserEmbedKeyResponse')
        return responseObject
        
        
    


