#!/usr/bin/env python
"""
Copyright 2012 GroupDocs.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

from .models import *
from groupdocs.FileStream import FileStream
from groupdocs.ApiClient import ApiException

class StorageApi(object):

    def __init__(self, apiClient):
        self.apiClient = apiClient
        self.__basePath = "https://api.groupdocs.com/v2.0"

    @property
    def basePath(self):
        return self.__basePath
    
    @basePath.setter
    def basePath(self, value):
        self.__basePath = value

    
    def GetStorageInfo(self, userId, **kwargs):
        """Get storage info

        Args:
            userId, str: User GUID (required)
            
        Returns: StorageInfoResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetStorageInfo" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'StorageInfoResponse')
        return responseObject
        
        
    def ListEntities(self, userId, path, **kwargs):
        """List entities

        Args:
            userId, str: User GUID (required)
            path, str: Path (optional)
            pageIndex, int: Page Index (optional)
            pageSize, int: Page Size (optional)
            orderBy, str: Order By (optional)
            orderAsc, bool: Order Asc (optional)
            filter, str: Filter (optional)
            fileTypes, str: File Types (optional)
            extended, bool: Indicates whether an extended information should be returned (optional)
            
        Returns: ListEntitiesResponse
        """
        if( userId == None or path == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'path', 'pageIndex', 'pageSize', 'orderBy', 'orderAsc', 'filter', 'fileTypes', 'extended']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ListEntities" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}/folders/{*path}?page={pageIndex}&count={pageSize}&order_by={orderBy}&order_asc={orderAsc}&filter={filter}&file_types={fileTypes}&extended={extended}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('pageIndex' in params):
            queryParams['page'] = self.apiClient.toPathValue(params['pageIndex'])
        if ('pageSize' in params):
            queryParams['count'] = self.apiClient.toPathValue(params['pageSize'])
        if ('orderBy' in params):
            queryParams['order_by'] = self.apiClient.toPathValue(params['orderBy'])
        if ('orderAsc' in params):
            queryParams['order_asc'] = self.apiClient.toPathValue(params['orderAsc'])
        if ('filter' in params):
            queryParams['filter'] = self.apiClient.toPathValue(params['filter'])
        if ('fileTypes' in params):
            queryParams['file_types'] = self.apiClient.toPathValue(params['fileTypes'])
        if ('extended' in params):
            queryParams['extended'] = self.apiClient.toPathValue(params['extended'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('path' in params):
            replacement = str(self.apiClient.toPathValue(params['path']))
            resourcePath = resourcePath.replace('{' + 'path' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'ListEntitiesResponse')
        return responseObject
        
        
    def GetFile(self, userId, fileId, **kwargs):
        """Get file

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            
        Returns: stream
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetFile" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}/files/{fileId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        return self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams, FileStream)
        
    def GetSharedFile(self, userEmail, filePath, **kwargs):
        """Get shared file

        Args:
            userEmail, str: User Email (required)
            filePath, str: File path (required)
            
        Returns: stream
        """
        if( userEmail == None or filePath == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userEmail', 'filePath']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSharedFile" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/shared/{userEmail}/{*filePath}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userEmail' in params):
            replacement = str(self.apiClient.toPathValue(params['userEmail']))
            resourcePath = resourcePath.replace('{' + 'userEmail' + '}',
                                                replacement)
        if ('filePath' in params):
            replacement = str(self.apiClient.toPathValue(params['filePath']))
            resourcePath = resourcePath.replace('{' + 'filePath' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        return self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams, FileStream)
        
    def Upload(self, userId, path, body, **kwargs):
        """Upload

        Args:
            userId, str: User GUID (required)
            path, str: Path (required)
            description, str: Description (optional)
            body, stream: Stream (required)
            
        Returns: UploadResponse
        """
        if( userId == None or path == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'path', 'description', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method Upload" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}/folders/{*path}?description={description}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('description' in params):
            queryParams['description'] = self.apiClient.toPathValue(params['description'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('path' in params):
            replacement = str(self.apiClient.toPathValue(params['path']))
            resourcePath = resourcePath.replace('{' + 'path' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UploadResponse')
        return responseObject
        
        
    def Decompress(self, userId, path, body, **kwargs):
        """UploadAndUnzip

        Args:
            userId, str: User GUID (required)
            path, str: Path (required)
            description, str: Description (optional)
            archiveType, str: Archive type (optional)
            body, stream: Stream (required)
            
        Returns: UploadResponse
        """
        if( userId == None or path == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'path', 'description', 'archiveType', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method Decompress" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}/decompress/{*path}?description={description}&archiveType={archiveType}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('description' in params):
            queryParams['description'] = self.apiClient.toPathValue(params['description'])
        if ('archiveType' in params):
            queryParams['archiveType'] = self.apiClient.toPathValue(params['archiveType'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('path' in params):
            replacement = str(self.apiClient.toPathValue(params['path']))
            resourcePath = resourcePath.replace('{' + 'path' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UploadResponse')
        return responseObject
        
        
    def UploadWeb(self, userId, url, **kwargs):
        """Upload Web

        Args:
            userId, str: User GUID (required)
            url, str: Url (required)
            
        Returns: UploadResponse
        """
        if( userId == None or url == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'url']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UploadWeb" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}/urls?url={url}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('url' in params):
            queryParams['url'] = self.apiClient.toPathValue(params['url'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UploadResponse')
        return responseObject
        
        
    def UploadGoogle(self, userId, path, **kwargs):
        """Upload Google

        Args:
            userId, str: User GUID (required)
            path, str: File path (required)
            fileId, str: File unique identifier (optional)
            
        Returns: UploadResponse
        """
        if( userId == None or path == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'path', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UploadGoogle" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}/google/files/{*path}?file_id={fileId}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('fileId' in params):
            queryParams['file_id'] = self.apiClient.toPathValue(params['fileId'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('path' in params):
            replacement = str(self.apiClient.toPathValue(params['path']))
            resourcePath = resourcePath.replace('{' + 'path' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UploadResponse')
        return responseObject
        
        
    def Delete(self, userId, fileId, **kwargs):
        """Delete

        Args:
            userId, str: User GUID (required)
            fileId, str: File ID (required)
            
        Returns: DeleteResponse
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method Delete" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}/files/{fileId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteResponse')
        return responseObject
        
        
    def DeleteFromFolder(self, userId, path, **kwargs):
        """Delete from folder

        Args:
            userId, str: User GUID (required)
            path, str: Path (required)
            
        Returns: DeleteResponse
        """
        if( userId == None or path == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'path']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteFromFolder" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}/folders/{*path}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('path' in params):
            replacement = str(self.apiClient.toPathValue(params['path']))
            resourcePath = resourcePath.replace('{' + 'path' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteResponse')
        return responseObject
        
        
    def MoveFile(self, userId, path, **kwargs):
        """Move file

        Args:
            userId, str: User GUID (required)
            path, str: Path (required)
            mode, str: Mode (optional)
            Groupdocs-Copy, str: File ID (copy) (optional)
            Groupdocs-Move, str: File ID (move) (optional)
            
        Returns: FileMoveResponse
        """
        if( userId == None or path == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'path', 'mode', 'Groupdocs-Copy', 'Groupdocs-Move']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method MoveFile" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}/files/{*path}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('mode' in params):
            queryParams['mode'] = self.apiClient.toPathValue(params['mode'])
        if ('Groupdocs-Copy' in params):
            headerParams['Groupdocs-Copy'] = params['Groupdocs-Copy']
        if ('Groupdocs-Move' in params):
            headerParams['Groupdocs-Move'] = params['Groupdocs-Move']
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('path' in params):
            replacement = str(self.apiClient.toPathValue(params['path']))
            resourcePath = resourcePath.replace('{' + 'path' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'FileMoveResponse')
        return responseObject
        
        
    def MoveFolder(self, userId, path, **kwargs):
        """Move folder

        Args:
            userId, str: User GUID (required)
            path, str: Destination Path (required)
            mode, str: Mode (optional)
            Groupdocs-Move, str: Source path (move) (optional)
            Groupdocs-Copy, str: Source path (copy) (optional)
            
        Returns: FolderMoveResponse
        """
        if( userId == None or path == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'path', 'mode', 'Groupdocs-Move', 'Groupdocs-Copy']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method MoveFolder" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}/folders/{*path}?override_mode={mode}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('mode' in params):
            queryParams['override_mode'] = self.apiClient.toPathValue(params['mode'])
        if ('Groupdocs-Move' in params):
            headerParams['Groupdocs-Move'] = params['Groupdocs-Move']
        if ('Groupdocs-Copy' in params):
            headerParams['Groupdocs-Copy'] = params['Groupdocs-Copy']
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('path' in params):
            replacement = str(self.apiClient.toPathValue(params['path']))
            resourcePath = resourcePath.replace('{' + 'path' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'FolderMoveResponse')
        return responseObject
        
        
    def Create(self, userId, path, **kwargs):
        """Create

        Args:
            userId, str: User GUID (required)
            path, str: Path (required)
            
        Returns: CreateFolderResponse
        """
        if( userId == None or path == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'path']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method Create" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}/paths/{*path}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('path' in params):
            replacement = str(self.apiClient.toPathValue(params['path']))
            resourcePath = resourcePath.replace('{' + 'path' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'CreateFolderResponse')
        return responseObject
        
        
    def Compress(self, userId, fileId, archiveType, **kwargs):
        """Compress

        Args:
            userId, str: User GUID (required)
            fileId, str: File ID (required)
            archiveType, str: Archive type (optional)
            
        Returns: CompressResponse
        """
        if( userId == None or fileId == None or archiveType == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'archiveType']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method Compress" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}/files/{fileId}/archive/{archiveType}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('archiveType' in params):
            replacement = str(self.apiClient.toPathValue(params['archiveType']))
            resourcePath = resourcePath.replace('{' + 'archiveType' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'CompressResponse')
        return responseObject
        
        
    def CreatePackage(self, userId, packageName, **kwargs):
        """Create Package

        Args:
            userId, str: User GUID (required)
            packageName, str: Package Name (required)
            storeRelativePath, bool: Store files using relative paths (optional)
            body, List[str]: Paths (optional)
            
        Returns: CreatePackageResponse
        """
        if( userId == None or packageName == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'packageName', 'storeRelativePath', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CreatePackage" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}/packages/{packageName}?storeRelativePath={storeRelativePath}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('storeRelativePath' in params):
            queryParams['storeRelativePath'] = self.apiClient.toPathValue(params['storeRelativePath'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('packageName' in params):
            replacement = str(self.apiClient.toPathValue(params['packageName']))
            resourcePath = resourcePath.replace('{' + 'packageName' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'CreatePackageResponse')
        return responseObject
        
        
    def MoveToTrash(self, userId, path, **kwargs):
        """Move to trash

        Args:
            userId, str: User GUID (required)
            path, str: Path (required)
            
        Returns: FolderMoveResponse
        """
        if( userId == None or path == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'path']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method MoveToTrash" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}/trash/{*path}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('path' in params):
            replacement = str(self.apiClient.toPathValue(params['path']))
            resourcePath = resourcePath.replace('{' + 'path' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'FolderMoveResponse')
        return responseObject
        
        
    def RestoreFromTrash(self, userId, path, **kwargs):
        """Restore from trash

        Args:
            userId, str: User GUID (required)
            path, str: Path (required)
            
        Returns: DeleteResponse
        """
        if( userId == None or path == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'path']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method RestoreFromTrash" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/storage/{userId}/trash/{*path}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('path' in params):
            replacement = str(self.apiClient.toPathValue(params['path']))
            resourcePath = resourcePath.replace('{' + 'path' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteResponse')
        return responseObject
        
        
    


