# -*- coding: utf-8 -*-
from os.path import exists as _exists,expanduser
from sys import exit
from envoy import run
from its import osx

bin="/usr/local/bin/growlnotify"
if not osx:
    exit("Mac OS only, sorry :)")
exists=_exists(bin)
if not exists:
    print "%s not exists",bin

def command(title, message=None, app=None, sticky=False,image=None,name=None):
    global bin
    return """
%(bin)s -t '%(title)s'%(app)s%(sticky)s%(image)s%(name)s
""" % \
            {
                "bin"  : bin,
                "title": title,
                #"message": "-m '%s'" % message.replace(" ","\\ ") if message else "",
                "app": ' -a "%s"' % app if app else "",
                "sticky": " -s" if sticky else "",
                "image": " --image %s" % expanduser(image) if image else "",
                "name": " -n %s" % name if name else ""
            }

def growlnotify(title, message="", app=None, sticky=False,image=None,name=None):
    if message:
        if message.__class__ == str:
            message = message.decode("utf-8")
        message = message.encode("utf-8")
    if title.__class__ == str:
        title=title.encode("utf-8")
    if isinstance(title,(unicode,str)):
        if title[0]=="-":
            title="minus "+title[1:]
        title = title.encode("utf-8")
    l=command(title,
            message=message,
            app=app,
            sticky=sticky,
            image=image,
            name=name)
    try:
        run(l,message)
    except Exception, e:
        # Grown not running or freeze
        if str(e).find("Failed to register with")>0:
            run("killall Growl")
        run("open -a Growl")
        run(l)