// Generated by CoffeeScript 1.7.1
(function() {
  var ClosedStatus, Comment, Component, HeaderOrderingFilter, Issue, IssueFilter, IssueType, Milestone, MilestoneManager, NullProject, OpenStatus, Priority, Project, ProjectManager, Resolution, ResolvedStatus, Status, Url, User, UserManager, Version, milestoneManager, projectManager, userManager,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  Url = (function() {
    function Url(url) {
      var uri;
      this.url = url;
      this.scheme = null;
      this.host = null;
      this.path = null;
      this.params = {};
      this.query = {};
      this.fragment = null;
      uri = new URI.parse(this.url);
      this.scheme = uri.protocol;
      this.host = uri.hostname;
      this.path = uri.path;
      this.fragment = uri.fragment;
      if (uri.query) {
        this.query = URI.parseQuery(uri.query);
      }
    }

    return Url;

  })();

  User = (function() {
    function User(id, username, firstName, lastName, email) {
      this.id = id;
      this.username = username;
      this.firstName = firstName;
      this.lastName = lastName;
      this.email = email != null ? email : "";
    }

    User.fromDTO = function(dto) {
      return new User(dto.id, dto.username, dto.firstName, dto.lastName, dto.email);
    };

    return User;

  })();

  UserManager = (function() {
    function UserManager() {
      this.users = {};
    }

    UserManager.prototype.putUser = function(user) {
      return this.users[user.id] = user;
    };

    UserManager.prototype.getUserById = function(userId) {
      return this.users[userId] || null;
    };

    UserManager.prototype.getAll = function() {
      var user, _, _ref, _results;
      _ref = this.users;
      _results = [];
      for (_ in _ref) {
        user = _ref[_];
        _results.push(user);
      }
      return _results;
    };

    UserManager.prototype.getDefaultUser = function() {
      return this.users[0];
    };

    return UserManager;

  })();

  userManager = new UserManager();

  Version = (function() {
    function Version(id, name, description) {
      this.id = id;
      this.name = name;
      this.description = description != null ? description : "";
    }

    Version.fromDTO = function(dto) {
      return new Version(dto.id, dto.name, dto.description);
    };

    return Version;

  })();

  Component = (function() {
    function Component(id, name, description) {
      this.id = id;
      this.name = name;
      this.description = description != null ? description : "";
    }

    Component.fromDTO = function(dto) {
      return new Component(dto.id, dto.name, dto.description);
    };

    return Component;

  })();

  Project = (function() {
    function Project() {
      this.id = -1;
      this.name = "";
      this.description = "";
      this.issueKey = "";
      this.components = [];
      this.versions = [];
      this.priorities = [];
      this.issueTypes = [];
      this.resolutions = [];
    }

    Project.prototype.findComponentById = function(id) {
      return (this.components.filter(function(obj) {
        return obj.id === id;
      }))[0] || null;
    };

    Project.prototype.findVersionById = function(id) {
      return (this.versions.filter(function(obj) {
        return obj.id === id;
      }))[0] || null;
    };

    Project.prototype.findPriorityByShortName = function(shortName) {
      return (this.priorities.filter(function(obj) {
        return obj.shortName === shortName;
      }))[0] || null;
    };

    Project.prototype.getDefaultPriority = function() {
      var defaultPriority, filtered;
      filtered = this.priorities.filter(function(item) {
        return item.shortName === "NP";
      });
      if (filtered.length !== 0) {
        defaultPriority = filtered[0];
      } else {
        defaultPriority = this.priorities[0];
      }
      return defaultPriority;
    };

    Project.fromDTO = function(dto) {
      var component, obj, priority, resolution, type, version;
      obj = new Project();
      obj.id = dto.id;
      obj.name = dto.name;
      obj.description = dto.description;
      obj.issueKey = dto.issueKey;
      obj.components = (function() {
        var _i, _len, _ref, _results;
        _ref = dto.components;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          component = _ref[_i];
          _results.push(Component.fromDTO(component));
        }
        return _results;
      })();
      obj.versions = (function() {
        var _i, _len, _ref, _results;
        _ref = dto.versions;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          version = _ref[_i];
          _results.push(Version.fromDTO(version));
        }
        return _results;
      })();
      obj.issueTypes = (function() {
        var _i, _len, _ref, _results;
        _ref = dto.issueTypes;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          type = _ref[_i];
          _results.push(IssueType.fromDTO(type));
        }
        return _results;
      })();
      obj.resolutions = (function() {
        var _i, _len, _ref, _results;
        _ref = dto.resolutions;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          resolution = _ref[_i];
          _results.push(Resolution.fromDTO(resolution));
        }
        return _results;
      })();
      obj.priorities = (function() {
        var _i, _len, _ref, _results;
        _ref = dto.priorities;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          priority = _ref[_i];
          _results.push(Priority.fromDTO(priority));
        }
        return _results;
      })();
      return obj;
    };

    return Project;

  })();

  NullProject = (function(_super) {
    __extends(NullProject, _super);

    function NullProject() {
      NullProject.__super__.constructor.call(this);
    }

    NullProject.prototype.findComponentById = function(id) {
      return null;
    };

    NullProject.prototype.findVersionById = function(id) {
      return null;
    };

    NullProject.prototype.findPriorityByShortName = function(id) {
      return null;
    };

    return NullProject;

  })(Project);

  ProjectManager = (function() {
    function ProjectManager() {
      this.projects = {};
    }

    ProjectManager.prototype.putProject = function(project) {
      return this.projects[project.id] = project;
    };

    ProjectManager.prototype.getProject = function(id) {
      return this.projects[id] || null;
    };

    ProjectManager.prototype.allProjects = function() {
      var project, _, _ref, _results;
      _ref = this.projects;
      _results = [];
      for (_ in _ref) {
        project = _ref[_];
        _results.push(project);
      }
      return _results;
    };

    return ProjectManager;

  })();

  projectManager = new ProjectManager();

  Priority = (function() {
    function Priority(id, name, shortName, wieght) {
      this.id = id;
      this.name = name;
      this.shortName = shortName;
      this.wieght = wieght;
    }

    Priority.fromDTO = function(dto) {
      return new Priority(dto.id, dto.name, dto.shortName, dto.weight);
    };

    return Priority;

  })();

  IssueType = (function() {
    function IssueType(id, name, shortName) {
      this.id = id != null ? id : -1;
      this.name = name != null ? name : "";
      this.shortName = shortName != null ? shortName : "";
    }

    IssueType.fromDTO = function(dto) {
      switch (dto) {
        case "BUG":
          return IssueType.BUG;
        case "FRQ":
          return IssueType.FEATURE_REQUEST;
        case "TASK":
          return IssueType.TASK;
      }
    };

    IssueType.BUG = new IssueType(1, "Bug", "BUG", 30);

    IssueType.FEATURE_REQUEST = new IssueType(2, "Feature Request", "FRQ", 20);

    IssueType.TASK = new IssueType(3, "Task", "TASK", 10);

    return IssueType;

  })();

  Resolution = (function() {
    function Resolution(id, name) {
      this.id = id;
      this.name = name;
    }

    Resolution.fromDTO = function(dto) {
      switch (dto) {
        case "UNRESOLVED":
          return Resolution.UNRESOLVED;
        case "INVALID":
          return Resolution.INVALID;
        case "WONT_FIX":
          return Resolution.WONT_FIX;
        case "FIXED":
          return Resolution.FIXED;
      }
    };

    Resolution.UNRESOLVED = new Resolution("UNRESOLVED", "Unresolved");

    Resolution.INVALID = new Resolution("INVALID", "Invalid");

    Resolution.WONT_FIX = new Resolution("WONT_FIX", "Won't Fix");

    Resolution.FIXED = new Resolution("FIXED", "Fixed");

    return Resolution;

  })();

  Milestone = (function() {
    function Milestone(id, name, description) {
      this.id = id;
      this.name = name;
      this.description = description != null ? description : "";
    }

    Milestone.fromDTO = function(dto) {
      return new Milestone(dto.id, dto.name, dto.description || "");
    };

    return Milestone;

  })();

  MilestoneManager = (function() {
    function MilestoneManager() {
      this.milestones = {};
    }

    MilestoneManager.prototype.putMilestone = function(milestone) {
      return this.milestones[milestone.id] = milestone;
    };

    MilestoneManager.prototype.getMilestoneById = function(id) {
      return this.milestones[id] || null;
    };

    MilestoneManager.prototype.getAllMilestones = function() {
      var milestone, _, _ref, _results;
      _ref = this.milestones;
      _results = [];
      for (_ in _ref) {
        milestone = _ref[_];
        _results.push(milestone);
      }
      return _results;
    };

    return MilestoneManager;

  })();

  milestoneManager = new MilestoneManager();

  Status = (function() {
    function Status(resolution, id, name) {
      this.resolution = resolution;
      this.id = id;
      this.name = name;
    }

    Status.fromDTO = function(dto, resolution) {
      if (resolution == null) {
        resolution = null;
      }
      switch (dto) {
        case "OPEN":
          return new OpenStatus();
        case "RESOLVED":
          return new ResolvedStatus(Resolution.fromDTO(resolution));
        case "CLOSED":
          return new ClosedStatus({
            resolution: resolution
          });
      }
    };

    return Status;

  })();

  OpenStatus = (function(_super) {
    __extends(OpenStatus, _super);

    function OpenStatus() {
      OpenStatus.__super__.constructor.call(this, Resolution.UNRESOLVED, "OPEN", "Open");
    }

    return OpenStatus;

  })(Status);

  ResolvedStatus = (function(_super) {
    __extends(ResolvedStatus, _super);

    function ResolvedStatus(resolution) {
      if (resolution == null) {
        resolution = Resolution.FIXED;
      }
      ResolvedStatus.__super__.constructor.call(this, resolution, "RESOLVED", "Resolved");
    }

    return ResolvedStatus;

  })(Status);

  ClosedStatus = (function(_super) {
    __extends(ClosedStatus, _super);

    function ClosedStatus(oldStatus) {
      ClosedStatus.__super__.constructor.call(this, oldStatus.resolution, "CLOSED", "Closed");
    }

    return ClosedStatus;

  })(Status);

  Comment = (function() {
    function Comment(id, author, text, created, updated) {
      this.id = id || -1;
      this.created = created || new Date();
      this.updated = updated || new Date();
      this.author = author || null;
      this.text = text || "";
    }

    Comment.fromDTO = function(dto) {
      var author, created, updated;
      created = dto.created ? new Date(dto.created) : new Date();
      updated = dto.updated ? new Date(dto.updated) : new Date();
      author = userManager.getUserById(dto.author.id);
      if (!author) {
        author = User.fromDTO(dto.author);
        userManager.putUser(User.fromDTO(dto.author));
      }
      return new Comment(dto.id, author, dto.text, created, updated);
    };

    return Comment;

  })();

  Issue = (function() {
    function Issue() {
      this.issueKey = null;
      this.issueType = IssueType.BUG;
      this.project = null;
      this.priority = null;
      this.summary = "";
      this.description = "";
      this.stepsToReproduce = "";
      this.assignee = null;
      this.reporter = userManager.getDefaultUser();
      this.components = [];
      this.affectsVersions = [];
      this.fixVersions = [];
      this.milestone = null;
      this.status = new OpenStatus();
      this.comments = [];
      this.reported = new Date();
      this.lastUpdated = new Date();
    }

    Issue.fromDTO = function(dto) {
      var componentId, obj, versionId;
      obj = new Issue();
      obj.issueKey = dto.issueKey;
      obj.project = projectManager.getProject(dto.project);
      obj.issueType = IssueType.fromDTO(dto.issueType);
      obj.priority = obj.project.findPriorityByShortName(dto.priority);
      obj.summary = dto.summary;
      obj.description = dto.description;
      obj.stepsToReproduce = dto.stepsToReproduce;
      obj.components = (function() {
        var _i, _len, _ref, _results;
        _ref = dto.components;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          componentId = _ref[_i];
          _results.push(obj.project.findComponentById(componentId));
        }
        return _results;
      })();
      obj.affectsVersions = (function() {
        var _i, _len, _ref, _results;
        _ref = dto.affectsVersions;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          versionId = _ref[_i];
          _results.push(obj.project.findVersionById(versionId));
        }
        return _results;
      })();
      obj.fixVersions = (function() {
        var _i, _len, _ref, _results;
        _ref = dto.fixVersions;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          versionId = _ref[_i];
          _results.push(obj.project.findVersionById(versionId));
        }
        return _results;
      })();
      obj.status = Status.fromDTO(dto.status);
      obj.resolution = Resolution.fromDTO(dto.resolution);
      if (dto.milestone) {
        obj.milestone = milestoneManager.getMilestoneById(dto.milestone.id);
      }
      obj.assignee = userManager.getUserById(dto.assignee.id);
      obj.reporter = userManager.getUserById(dto.reporter.id);
      obj.reported = new Date(dto.reported);
      obj.lastUpdated = new Date(dto.lastUpdated);
      return obj;
    };

    Issue.prototype.resolve = function(resolution) {
      if (this.status.id === "OPEN") {
        if (resolution.id !== "UNRESOLVED") {
          return this.status = new ResolvedStatus(resolution);
        }
      }
    };

    Issue.prototype.reopen = function() {
      if (this.status.id !== "OPEN") {
        return this.status = new OpenStatus();
      }
    };

    Issue.prototype.close = function() {
      if (this.status.id === "RESOLVED") {
        return this.status = new ClosedStatus(this.status);
      }
    };

    return Issue;

  })();

  IssueFilter = (function() {
    function IssueFilter(allProjects, allStatuses, allUsers, allMilestones) {
      this.allProjects = allProjects != null ? allProjects : null;
      this.allStatuses = allStatuses != null ? allStatuses : null;
      this.allUsers = allUsers != null ? allUsers : null;
      this.allMilestones = allMilestones != null ? allMilestones : null;
      this.allProjects = this.allProjects || [];
      this.allStatuses = this.allStatuses || [];
      this.allVersions = this.allVersions || [];
      this.allUsers = this.allUsers || [];
      this.allMilestones = this.allMilestones || [];
      this.projectsSelected = [];
      this.statusesSelected = [];
      this.affectsVersionsSelected = [];
      this.fixVersionsSelected = [];
      this.assigneesSelected = [];
      this.milestonesSelected = [];
      this.noAffectsVersion = {
        id: -1,
        name: "No Affects Version"
      };
      this.noFixVersion = {
        id: -1,
        name: "No Fix Version"
      };
    }

    IssueFilter.prototype.getAvailableVersions = function(initial) {
      var project, projects, version, versions, _i, _j, _len, _len1, _ref;
      projects = this.projectsSelected;
      if (projects.length === 0) {
        projects = this.allProjects;
      }
      versions = initial ? [initial] : [];
      for (_i = 0, _len = projects.length; _i < _len; _i++) {
        project = projects[_i];
        _ref = project.versions;
        for (_j = 0, _len1 = _ref.length; _j < _len1; _j++) {
          version = _ref[_j];
          versions.push(version);
        }
      }
      return versions;
    };

    IssueFilter.prototype.getAvailableFixVersions = function() {
      return this.getAvailableVersions();
    };

    IssueFilter.prototype.getAvailableAffectsVersions = function() {
      return this.getAvailableVersions();
    };

    IssueFilter.prototype.setSelectedAssigneesByIds = function(ids) {
      return this.assigneesSelected = this.allUsers.filter(function(item) {
        return ids.indexOf(item.id) !== -1;
      });
    };

    IssueFilter.prototype.setSelectedStatuses = function(ids) {
      return this.statusesSelected = ids;
    };

    IssueFilter.prototype.setSelectedProjectsByIds = function(ids) {
      return this.projectsSelected = this.allProjects.filter(function(item) {
        return ids.indexOf(item.id) !== -1;
      });
    };

    IssueFilter.prototype.setSelectedMilestones = function(ids) {
      return this.milestonesSelected = this.allMilestones.filter(function(item) {
        return ids.indexOf(item.id) !== -1;
      });
    };

    IssueFilter.prototype.setSelectedFixVersionsByIds = function(ids) {
      return this.fixVersionsSelected = this.getAvailableFixVersions().filter(function(item) {
        return ids.indexOf(item.id) !== -1;
      });
    };

    IssueFilter.prototype.setSelectedAffectsVersionsByIds = function(ids) {
      return this.affectsVersionsSelected = this.getAvailableAffectsVersions().filter(function(item) {
        return ids.indexOf(item.id) !== -1;
      });
    };

    IssueFilter.prototype.getServerParams = function() {
      var a, m, p, ret, s, v;
      ret = {};
      if (this.projectsSelected.length !== 0) {
        ret.projects = ((function() {
          var _i, _len, _ref, _results;
          _ref = this.projectsSelected;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            p = _ref[_i];
            _results.push(p.issueKey);
          }
          return _results;
        }).call(this)).join(",");
      }
      if (this.statusesSelected.length !== 0) {
        ret.statuses = ((function() {
          var _i, _len, _ref, _results;
          _ref = this.statusesSelected;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            s = _ref[_i];
            _results.push(s.toUpperCase());
          }
          return _results;
        }).call(this)).join(",");
      }
      if (this.affectsVersionsSelected.length !== 0) {
        ret.affects_versions = ((function() {
          var _i, _len, _ref, _results;
          _ref = this.affectsVersionsSelected;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            v = _ref[_i];
            _results.push(v.id.toString());
          }
          return _results;
        }).call(this)).join(",");
      }
      if (this.fixVersionsSelected.length !== 0) {
        ret.fix_versions = ((function() {
          var _i, _len, _ref, _results;
          _ref = this.fixVersionsSelected;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            v = _ref[_i];
            _results.push(v.id.toString());
          }
          return _results;
        }).call(this)).join(",");
      }
      if (this.assigneesSelected.length !== 0) {
        ret.assignees = ((function() {
          var _i, _len, _ref, _results;
          _ref = this.assigneesSelected;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            a = _ref[_i];
            _results.push(a.id.toString());
          }
          return _results;
        }).call(this)).join(",");
      }
      if (this.milestonesSelected.length !== 0) {
        ret.milestones = ((function() {
          var _i, _len, _ref, _results;
          _ref = this.milestonesSelected;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            m = _ref[_i];
            _results.push(m.id.toString());
          }
          return _results;
        }).call(this)).join(",");
      }
      return ret;
    };

    return IssueFilter;

  })();

  HeaderOrderingFilter = (function() {
    function HeaderOrderingFilter(name, direction) {
      this.name = name;
      if (direction == null) {
        direction = HeaderOrderingFilter.DESCENDING_ASCENDING;
      }
      this.upText = "\u25B2";
      this.downText = "\u25BC";
      this.noneText = "";
      this.ascDscNon = direction;
      this.direction = HeaderOrderingFilter.NONE;
      this.directionText = this.noneText;
    }

    HeaderOrderingFilter.prototype.setNone = function() {
      this.direction = HeaderOrderingFilter.NONE;
      return this.directionText = this.noneText;
    };

    HeaderOrderingFilter.prototype.setAscending = function() {
      this.direction = HeaderOrderingFilter.ASCENDING;
      return this.directionText = this.upText;
    };

    HeaderOrderingFilter.prototype.setDescending = function() {
      this.direction = HeaderOrderingFilter.DESCENDING;
      return this.directionText = this.downText;
    };

    HeaderOrderingFilter.prototype.setState = function(state) {
      switch (state) {
        case HeaderOrderingFilter.DESCENDING:
          return this.setDescending();
        case HeaderOrderingFilter.ASCENDING:
          return this.setAscending();
        case HeaderOrderingFilter.NONE:
          return this.setNone;
        default:
          return this.setNone;
      }
    };

    HeaderOrderingFilter.prototype.toggle = function() {
      if (this.ascDscNon) {
        switch (this.direction) {
          case HeaderOrderingFilter.ASCENDING:
            return this.setDescending();
          case HeaderOrderingFilter.DESCENDING:
            return this.setNone();
          case HeaderOrderingFilter.NONE:
            return this.setAscending();
        }
      } else {
        switch (this.direction) {
          case HeaderOrderingFilter.ASCENDING:
            return this.setNone();
          case HeaderOrderingFilter.DESCENDING:
            return this.setAscending();
          case HeaderOrderingFilter.NONE:
            return this.setDescending();
        }
      }
    };

    HeaderOrderingFilter.ASCENDING = "ASC";

    HeaderOrderingFilter.DESCENDING = "DSC";

    HeaderOrderingFilter.NONE = "NONE";

    HeaderOrderingFilter.ASCENDING_DESCENDING = true;

    HeaderOrderingFilter.DESCENDING_ASCENDING = false;

    return HeaderOrderingFilter;

  })();

  this.Gumshoe = {
    User: User,
    UserManager: UserManager,
    userManager: userManager,
    Version: Version,
    Component: Component,
    Project: Project,
    NullProject: NullProject,
    ProjectManager: ProjectManager,
    projectManager: projectManager,
    IssueType: IssueType,
    Issue: Issue,
    Comment: Comment,
    Priority: Priority,
    Status: Status,
    OpenStatus: OpenStatus,
    ResolvedStatus: ResolvedStatus,
    ClosedStatus: ClosedStatus,
    Resolution: Resolution,
    Milestone: Milestone,
    MilestoneManager: MilestoneManager,
    milestoneManager: milestoneManager,
    IssueFilter: IssueFilter,
    HeaderOrderingFilter: HeaderOrderingFilter
  };

  this.Url = Url;

}).call(this);
