// Generated by CoffeeScript 1.7.1
(function() {
  var API, Comment, HeaderOrderingFilter, Issue, IssueFilter, IssueListCtrl, Milestone, MilestoneManager, NavBarCtrl, NullProject, PAGES, Project, ProjectManager, Semaphore, UpdateIssueCtrl, User, UserManager, bootstrap, gumshoe, milestoneManager, projectManager, userManager;

  IssueFilter = Gumshoe.IssueFilter;

  HeaderOrderingFilter = Gumshoe.HeaderOrderingFilter;

  NullProject = Gumshoe.NullProject;

  Comment = Gumshoe.Comment;

  Issue = Gumshoe.Issue;

  Project = Gumshoe.Project;

  projectManager = Gumshoe.projectManager;

  ProjectManager = Gumshoe.ProjectManager;

  Milestone = Gumshoe.Milestone;

  User = Gumshoe.User;

  UserManager = Gumshoe.UserManager;

  userManager = Gumshoe.userManager;

  MilestoneManager = Gumshoe.MilestoneManager;

  milestoneManager = Gumshoe.milestoneManager;

  PAGES = {
    issuesAdd: "/issues/_add",
    issues: "/issues/",
    userHome: "/issues/"
  };

  API = {
    issues: "/rest/issues/"
  };

  IssueListCtrl = (function() {
    IssueListCtrl.$inject = ["$scope", "$http", "$q", "searchService", "projectsService", "usersService", "milestonesService"];

    function IssueListCtrl(scope, http, q, searchService, projectsService, usersService, milestonesService) {
      this.scope = scope;
      this.http = http;
      this.q = q;
      this.searchService = searchService;
      this.projectsService = projectsService;
      this.usersService = usersService;
      this.milestonesService = milestonesService;
      this.scope.issues = [];
      this.scope.issuesFilter = new IssueFilter(this.projectsService.getAll(), ["Open", "Resolved", "Closed"], this.usersService.getAll(), this.milestonesService.getAll());
      this.scope.totalIssues = 0;
      this.scope.currentPage = 1;
      this.scope.pageSize = 25;
      this.scope.totalPages = 1;
      this.scope.pageSizeOptions = [5, 10, 25, 50];
      this.scope.priorityHeader = new HeaderOrderingFilter("Priority");
      this.scope.priorityHeader.setDescending();
      this.scope.issueKeyHeader = new HeaderOrderingFilter("Summary");
      this.scope.resolutionHeader = new HeaderOrderingFilter("Resolution");
      this.scope.assigneeHeader = new HeaderOrderingFilter("Assignee");
      this.scope.refresh = (function(_this) {
        return function() {
          return _this.fetchIssueList();
        };
      })(this);
      this.scope.addIssue = (function(_this) {
        return function() {
          return _this.addIssue();
        };
      })(this);
      this.scope.saveSettings = (function(_this) {
        return function() {
          return _this.saveSearchSettings();
        };
      })(this);
      this.scope.$on("navbar.search.submit", (function(_this) {
        return function(evt, data) {
          return _this.fetchIssueList();
        };
      })(this));
      this.http.get(API.settings).success((function(_this) {
        return function(data, status, headers, config) {
          if (!data.unsaved) {
            return _this.restoreSearchSettings(data);
          } else {
            return _this.fetchIssueList();
          }
        };
      })(this));
      this.scope.$watch("currentPage", (function(_this) {
        return function(newValue, oldValue) {
          if (newValue && newValue !== oldValue) {
            return _this.fetchIssueList();
          }
        };
      })(this));
      this.scope.$watch("pageSize", (function(_this) {
        return function(newValue, oldValue) {
          if (newValue && newValue !== oldValue) {
            return _this.fetchIssueList();
          }
        };
      })(this));
      this.scope.$watch("priorityHeader.direction", (function(_this) {
        return function(newValue, oldValue) {
          if (newValue && newValue !== oldValue) {
            return _this.fetchIssueList();
          }
        };
      })(this));
      this.scope.$watch("issueKeyHeader.direction", (function(_this) {
        return function(newValue, oldValue) {
          if (newValue && newValue !== oldValue) {
            return _this.fetchIssueList();
          }
        };
      })(this));
      this.scope.$watch("resolutionHeader.direction", (function(_this) {
        return function(newValue, oldValue) {
          if (newValue && newValue !== oldValue) {
            return _this.fetchIssueList();
          }
        };
      })(this));
    }

    IssueListCtrl.prototype.toServerParam = function(headerFilter, paramName) {
      if (headerFilter.direction === HeaderOrderingFilter.DESCENDING) {
        return paramName;
      } else {
        return "-" + paramName;
      }
    };

    IssueListCtrl.prototype.addIssue = function() {
      var projectId;
      if (this.scope.issuesFilter.projectsSelected.length !== 1) {
        return alert("Please select ONE project.");
      } else {
        projectId = this.scope.issuesFilter.projectsSelected[0].id;
        return this.saveSearchSettings().then((function(_this) {
          return function() {
            return window.location = PAGES.issuesAdd + ("?project=" + projectId);
          };
        })(this));
      }
    };

    IssueListCtrl.prototype.saveSearchSettings = function() {
      var defered, dto, fixVersion, milestone, project, status, user, version;
      defered = this.q.defer();
      dto = {
        projects: (function() {
          var _i, _len, _ref, _results;
          _ref = this.scope.issuesFilter.projectsSelected;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            project = _ref[_i];
            _results.push(project.id);
          }
          return _results;
        }).call(this),
        statuses: (function() {
          var _i, _len, _ref, _results;
          _ref = this.scope.issuesFilter.statusesSelected;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            status = _ref[_i];
            _results.push(status);
          }
          return _results;
        }).call(this),
        milestones: (function() {
          var _i, _len, _ref, _results;
          _ref = this.scope.issuesFilter.milestonesSelected;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            milestone = _ref[_i];
            _results.push(milestone.id);
          }
          return _results;
        }).call(this),
        fixVersions: (function() {
          var _i, _len, _ref, _results;
          _ref = this.scope.issuesFilter.fixVersionsSelected;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            fixVersion = _ref[_i];
            _results.push(fixVersion.id);
          }
          return _results;
        }).call(this),
        affectsVersions: (function() {
          var _i, _len, _ref, _results;
          _ref = this.scope.issuesFilter.affectsVersionsSelected;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            version = _ref[_i];
            _results.push(version.id);
          }
          return _results;
        }).call(this),
        assignees: (function() {
          var _i, _len, _ref, _results;
          _ref = this.scope.issuesFilter.assigneesSelected;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            user = _ref[_i];
            _results.push(user.id);
          }
          return _results;
        }).call(this),
        currentPage: this.scope.currentPage,
        pageSize: this.scope.pageSize,
        searchTerms: this.searchService.getSearchTerms(),
        ordering: {
          priority: this.scope.priorityHeader.direction,
          issueKey: this.scope.issueKeyHeader.direction,
          resolution: this.scope.resolutionHeader.direction
        }
      };
      this.http.put(API.settings, dto).success((function(_this) {
        return function() {
          return defered.resolve();
        };
      })(this)).error(((function(_this) {
        return function() {
          return defered.reject();
        };
      })(this)));
      return defered.promise;
    };

    IssueListCtrl.prototype.restoreSearchSettings = function(dto) {
      this.scope.issuesFilter.setSelectedProjectsByIds(dto.projects || []);
      this.scope.issuesFilter.setSelectedStatuses(dto.statuses || []);
      this.scope.issuesFilter.setSelectedFixVersionsByIds(dto.fixVersions || []);
      this.scope.issuesFilter.setSelectedAffectsVersionsByIds(dto.affectsVersions || []);
      this.scope.issuesFilter.setSelectedAssigneesByIds(dto.assignees || []);
      this.scope.issuesFilter.setSelectedMilestones(dto.milestones || []);
      this.searchService.setSearchTerms(dto.searchTerms || "");
      this.scope.pageSize = dto.pageSize;
      this.scope.currentPage = dto.currentPage;
      if (dto.ordering) {
        this.scope.priorityHeader.setState(dto.ordering.priority);
        this.scope.issueKeyHeader.setState(dto.ordering.issueKey);
        this.scope.resolutionHeader.setState(dto.ordering.resolution);
      }
      return this.fetchIssueList();
    };

    IssueListCtrl.prototype.fetchIssueList = function() {
      var orderByParams, params, terms;
      params = this.scope.issuesFilter.getServerParams();
      params.page = this.scope.currentPage;
      params.page_size = this.scope.pageSize;
      orderByParams = [];
      if (this.scope.priorityHeader.direction !== HeaderOrderingFilter.NONE) {
        orderByParams.push(this.toServerParam(this.scope.priorityHeader, "priority"));
      }
      if (this.scope.issueKeyHeader.direction !== HeaderOrderingFilter.NONE) {
        orderByParams.push(this.toServerParam(this.scope.issueKeyHeader, "issue_key"));
      }
      if (this.scope.resolutionHeader.direction !== HeaderOrderingFilter.NONE) {
        orderByParams.push(this.toServerParam(this.scope.resolutionHeader, "resolution"));
      }
      if (orderByParams.length !== 0) {
        params.order_by = orderByParams.join(",");
      }
      terms = this.searchService.getSearchTerms();
      if (terms) {
        params.terms = terms;
      }
      return this.http.get(API.issues, {
        params: params
      }).success((function(_this) {
        return function(data, status, headers, config) {
          var i;
          _this.scope.issues = (function() {
            var _i, _len, _ref, _results;
            _ref = data.results;
            _results = [];
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              i = _ref[_i];
              _results.push(Issue.fromDTO(i));
            }
            return _results;
          })();
          _this.scope.totalIssues = data.count;
          _this.scope.totalPages = Math.ceil(_this.scope.totalIssues / _this.scope.pageSize);
          _this.nextPageLink = data.next;
          return _this.previousPageLink = data.previous;
        };
      })(this));
    };

    return IssueListCtrl;

  })();

  UpdateIssueCtrl = (function() {
    UpdateIssueCtrl.$inject = ['$scope', '$http', '$location', 'projectsService', 'usersService', 'milestonesService'];

    function UpdateIssueCtrl(scope, http, location, projectsService, usersService, milestonesService) {
      var issueKey, parts, url;
      this.scope = scope;
      this.http = http;
      this.location = location;
      this.projectsService = projectsService;
      this.usersService = usersService;
      this.milestonesService = milestonesService;
      url = new Url(this.location.absUrl());
      if (url.path === PAGES.issuesAdd) {
        this.scope.addMode = true;
      } else {
        this.scope.addMode = false;
      }
      issueKey = null;
      this.scope.users = this.usersService.getAll();
      this.scope.milestones = this.milestonesService.getAll();
      this.scope.comments = null;
      this.scope.commentText = "";
      this.issueEndpoint = "" + API.issues;
      this.issueCommentsEndpoint = null;
      if (!this.scope.addMode) {
        parts = url.path.split("/");
        issueKey = parts.pop();
        this.issueEndpoint = "" + API.issues + issueKey + "/";
        this.issueCommentsEndpoint = "" + this.issueEndpoint + "comments/";
        this.http.get(this.issueEndpoint).success(((function(_this) {
          return function(data, status, headers, config) {
            _this.scope.issue = Issue.fromDTO(data);
            _this.scope.project = _this.scope.issue.project;
            _this.scope.resolution = _this.scope.issue.status.resolution;
            _this.scope.issueTypes = _this.scope.project.issueTypes;
            _this.scope.priorities = _this.scope.project.priorities;
            _this.scope.resolutions = _this.scope.project.resolutions;
            if (_this.scope.comments) {
              return _this.scope.issue.comments = _this.scope.comments;
            }
          };
        })(this)));
        this.http.get(this.issueCommentsEndpoint).success((function(_this) {
          return function(data, status, headers, config) {
            var c;
            _this.scope.comments = (function() {
              var _i, _len, _results;
              _results = [];
              for (_i = 0, _len = data.length; _i < _len; _i++) {
                c = data[_i];
                _results.push(Comment.fromDTO(c));
              }
              return _results;
            })();
            if (_this.scope.issue) {
              return _this.scope.issue.comments = _this.scope.comments;
            }
          };
        })(this));
      } else {
        this.scope.project = this.projectsService.getProject(parseInt(url.query.project));
        if (!this.scope.project) {
          this.scope.project = new NullProject();
        }
        this.scope.issue = new Issue();
        this.scope.issue.project = this.scope.project;
        this.scope.issue.priority = this.scope.project.getDefaultPriority();
        this.scope.resolution = this.scope.issue.status.resolution;
        this.scope.issueTypes = this.scope.project.issueTypes;
        this.scope.priorities = this.scope.project.priorities;
        this.scope.resolutions = this.scope.project.resolutions;
      }
      this.scope.save = (function(_this) {
        return function() {
          return _this.save(PAGES.userHome);
        };
      })(this);
      this.scope.saveAndAdd = (function(_this) {
        return function() {
          return _this.saveAndAdd();
        };
      })(this);
      this.scope.cancel = (function(_this) {
        return function() {
          return _this.cancel();
        };
      })(this);
      this.scope.resolve = (function(_this) {
        return function() {
          return _this.resolve();
        };
      })(this);
      this.scope.reopen = (function(_this) {
        return function() {
          return _this.reopen();
        };
      })(this);
      this.scope.close = (function(_this) {
        return function() {
          return _this.close();
        };
      })(this);
      this.scope.addComment = (function(_this) {
        return function() {
          return _this.addComment(_this.scope.commentText);
        };
      })(this);
      this.scope.$on("navbar.search.submit", (function(_this) {
        return function(event, data) {
          var dto;
          dto = {
            searchTerms: data.searchTerms
          };
          return _this.http.put(API.settings, dto).success((function(data, status, headers, config) {
            return window.location = PAGES.issues;
          }));
        };
      })(this));
    }

    UpdateIssueCtrl.prototype.addComment = function(text) {
      var pl;
      pl = {
        text: text
      };
      return this.http.post(this.issueCommentsEndpoint, pl).success(((function(_this) {
        return function(data, status, headers, config) {
          return _this.scope.comments.push(Comment.fromDTO(data));
        };
      })(this)));
    };

    UpdateIssueCtrl.prototype.constructIssuePayload = function(issue) {
      var component, version;
      return {
        id: issue.id,
        project: issue.project.id,
        summary: issue.summary,
        issueType: issue.issueType.shortName,
        priority: issue.priority.shortName,
        description: issue.description,
        stepsToReproduce: issue.stepsToReproduce,
        status: issue.status.id,
        resolution: issue.status.resolution.id,
        assigneeId: issue.assignee ? issue.assignee.id : null,
        milestoneId: issue.milestone ? issue.milestone.id : null,
        components: (function() {
          var _i, _len, _ref, _results;
          _ref = issue.components;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            component = _ref[_i];
            _results.push(component.id);
          }
          return _results;
        })(),
        fixVersions: (function() {
          var _i, _len, _ref, _results;
          _ref = issue.fixVersions;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            version = _ref[_i];
            _results.push(version.id);
          }
          return _results;
        })(),
        affectsVersions: (function() {
          var _i, _len, _ref, _results;
          _ref = issue.affectsVersions;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            version = _ref[_i];
            _results.push(version.id);
          }
          return _results;
        })()
      };
    };

    UpdateIssueCtrl.prototype.save = function(redirectUrl) {
      var issuePayload, method, uri;
      issuePayload = this.constructIssuePayload(this.scope.issue);
      if (this.scope.addMode) {
        uri = API.issues;
        method = "post";
      } else {
        uri = "" + API.issues + this.scope.issue.issueKey + "/";
        method = "put";
      }
      return this.http[method](uri, issuePayload).success(((function(_this) {
        return function(data, status, headers, config) {
          if (redirectUrl) {
            return window.location = redirectUrl;
          }
        };
      })(this)));
    };

    UpdateIssueCtrl.prototype.saveAndAdd = function() {
      return this.save("" + PAGES.issuesAdd + "?project=" + this.scope.issue.project.id);
    };

    UpdateIssueCtrl.prototype.cancel = function() {
      return window.location = PAGES.userHome;
    };

    UpdateIssueCtrl.prototype.resolve = function() {
      this.scope.issue.resolve(this.scope.resolution);
      return this.save();
    };

    UpdateIssueCtrl.prototype.close = function() {
      this.scope.issue.close();
      return this.save();
    };

    UpdateIssueCtrl.prototype.reopen = function() {
      this.scope.issue.reopen();
      this.scope.resolution = this.scope.issue.status.resolution;
      return this.save();
    };

    return UpdateIssueCtrl;

  })();

  NavBarCtrl = (function() {
    NavBarCtrl.$inject = ['$scope', '$rootScope', 'searchService'];

    function NavBarCtrl(scope, rootScope, searchService) {
      this.scope = scope;
      this.rootScope = rootScope;
      this.searchService = searchService;
      this.scope.searchTerms = "";
      this.scope.submitSearch = (function(_this) {
        return function() {
          return _this.searchSubmitted();
        };
      })(this);
      this.scope.$watch('searchTerms', (function(_this) {
        return function() {
          return _this.searchService.setSearchTerms(_this.scope.searchTerms);
        };
      })(this));
      this.scope.$on('search.terms.update', (function(_this) {
        return function(evt, data) {
          return _this.scope.searchTerms = _this.searchService.getSearchTerms();
        };
      })(this));
    }

    NavBarCtrl.prototype.searchSubmitted = function() {
      return this.rootScope.$broadcast("navbar.search.submit", {
        "searchTerms": this.scope.searchTerms
      });
    };

    return NavBarCtrl;

  })();

  gumshoe = angular.module("gumshoe", ['gumshoe.initial', 'ui.bootstrap.pagination']);

  gumshoe.controller('UpdateIssueCtrl', UpdateIssueCtrl);

  gumshoe.controller('IssueListCtrl', IssueListCtrl);

  gumshoe.controller('NavBarCtrl', NavBarCtrl);

  gumshoe.factory('projectsService', [
    '$http', 'PROJECTS', function(http, PROJECTS) {
      projectManager = projectManager || new ProjectManager();
      return {
        init: function() {
          var project, _i, _len, _results;
          _results = [];
          for (_i = 0, _len = PROJECTS.length; _i < _len; _i++) {
            project = PROJECTS[_i];
            _results.push(projectManager.putProject(Project.fromDTO(project)));
          }
          return _results;
        },
        getProject: function(id) {
          return projectManager.getProject(id);
        },
        getAll: function() {
          return projectManager.allProjects();
        }
      };
    }
  ]);

  gumshoe.factory('usersService', [
    '$http', 'USERS', function(http, USERS) {
      userManager = userManager || new UserManager();
      return {
        init: function() {
          var user, _i, _len, _results;
          _results = [];
          for (_i = 0, _len = USERS.length; _i < _len; _i++) {
            user = USERS[_i];
            _results.push(userManager.putUser(User.fromDTO(user)));
          }
          return _results;
        },
        getUserById: function(id) {
          return userManager.getUserById(id);
        },
        getAll: function() {
          return userManager.getAll();
        }
      };
    }
  ]);

  gumshoe.factory('milestonesService', [
    '$http', 'MILESTONES', function(http, MILESTONES) {
      milestoneManager = milestoneManager || new MilestoneManager();
      return {
        init: function() {
          var milestone, _i, _len, _results;
          _results = [];
          for (_i = 0, _len = MILESTONES.length; _i < _len; _i++) {
            milestone = MILESTONES[_i];
            _results.push(milestoneManager.putMilestone(Milestone.fromDTO(milestone)));
          }
          return _results;
        },
        getMilestonById: function(id) {
          return milestoneManager.getMilestonById(id);
        },
        getAll: function() {
          return milestoneManager.getAllMilestones();
        }
      };
    }
  ]);

  gumshoe.factory('searchService', [
    '$http', '$rootScope', function(http, rootScope) {
      var currentSearchTerms;
      currentSearchTerms = "";
      return {
        setSearchTerms: function(terms) {
          currentSearchTerms = terms;
          return rootScope.$broadcast("search.terms.update", {});
        },
        getSearchTerms: function() {
          return currentSearchTerms;
        }
      };
    }
  ]);

  gumshoe.filter('jsonPrint', function() {
    return function(src) {
      return JSON.stringify(src, void 0, 2);
    };
  });

  gumshoe.run([
    'projectsService', function(projectsService) {
      return projectsService.init();
    }
  ]);

  gumshoe.run([
    'usersService', function(usersService) {
      return usersService.init();
    }
  ]);

  gumshoe.run([
    'milestonesService', function(milestoneService) {
      return milestoneService.init();
    }
  ]);

  gumshoe.config([
    "$httpProvider", function($httpProvider) {
      $httpProvider.defaults.xsrfCookieName = "csrftoken";
      return $httpProvider.defaults.xsrfHeaderName = "X-CSRFToken";
    }
  ]);

  Semaphore = (function() {
    function Semaphore(stageCount, callback) {
      this.stageCount = stageCount;
      this.callback = callback;
      this.stagesDone = [];
    }

    Semaphore.prototype.signal = function(stage) {
      this.stagesDone.push(stage);
      if (this.stagesDone.length >= this.stageCount) {
        return this.callback();
      }
    };

    return Semaphore;

  })();

  bootstrap = function() {
    var bootstrapAngular, http, initInjector, initial, semaphore;
    bootstrapAngular = function() {
      return angular.element(document).ready(function() {
        return angular.bootstrap(document, ['gumshoe']);
      });
    };
    semaphore = new Semaphore(5, (function(_this) {
      return function() {
        return bootstrapAngular();
      };
    })(this));
    initInjector = angular.injector(['ng']);
    initial = angular.module('gumshoe.initial', []);
    http = initInjector.get('$http');
    return http.get(GUMSHOE_API_ROOT || 'rest/').success(function(data) {
      initial.constant("GUMSHOE_API_ROOT", data);
      API = data;
      API.settings = GUMSHOE_API_ROOT + "settings/";
      API.pages = GUMSHOE_API_ROOT + "pages/";
      semaphore.signal("GUMSHOE_API_ROOT");
      http.get(API.pages).success((function(data) {
        PAGES = data;
        return semaphore.signal('PAGES');
      }));
      http.get(API.projects).success(function(data) {
        initial.constant("PROJECTS", data);
        return semaphore.signal('PROJECTS');
      });
      http.get(API.users).success(function(data) {
        initial.constant("USERS", data);
        return semaphore.signal('USERS');
      });
      return http.get(API.milestones).success(function(data) {
        initial.constant("MILESTONES", data);
        return semaphore.signal("MILESTONES");
      });
    });
  };

  bootstrap();

}).call(this);
