#!/usr/bin/env python
# encoding: utf-8
'''
bin.gus_create_test_plan -- shortdesc

bin.gus_create_test_plan is a description

It defines classes_and_methods

@author:     user_name

@copyright:  2014 organization_name. All rights reserved.

@license:    license

@contact:    user_email
@deffield    updated: Updated
'''

import sys
import os

from optparse import OptionParser
from gus.BacklogClient import BacklogClient
from gus.QAForceClient import QAForceClient

__all__ = []
__version__ = 0.1
__date__ = '2014-08-18'
__updated__ = '2014-08-18'

def main(argv=None):
    '''Command line options.'''

    program_name = os.path.basename(sys.argv[0])
    program_version = "v0.1"
    program_build_date = "%s" % __updated__

    program_version_string = '%%prog %s (%s)' % (program_version, program_build_date)
    #program_usage = '''usage: spam two eggs''' # optional - will be autogenerated by optparse
    program_longdesc = '''''' # optional - give further explanation about what the program does
    program_license = "Copyright 2014 user_name (organization_name)                                            \
                Licensed under the Apache License 2.0\nhttp://www.apache.org/licenses/LICENSE-2.0"

    if argv is None:
        argv = sys.argv[1:]
    try:
        # setup option parser
        parser = OptionParser(version=program_version_string, epilog=program_longdesc, description=program_license)
        parser.add_option("-t", "--team", dest="team", help="Name of Team to create sprint test plan for.")
        parser.add_option("-r", "--release", dest="release", help="Name of Release to create plan for.  Must supply Team")
        parser.add_option("-p", "--plan", dest="plan", help="ID of test plan to populate")
        parser.add_option("-d", "--dont_migrate", dest="dont_migrate", help="Set to non-zero if you don't want to migrate from existing plan")
        
        # process options
        (opts, args) = parser.parse_args(argv)

        if not opts.team or not opts.plan:
            raise Exception('Team ID and Plan ID are both required')
        
        backlog = BacklogClient()
        qa = QAForceClient()

        # MAIN BODY #
        if opts.release:
            work = backlog.get_work_for_release(opts.release, opts.team)
        else:
            sprint = backlog.get_current_sprint_for_team(opts.team)
            work = backlog.get_work_for_sprint(sprint)
            
        for w_id in work:
            add = True
            if opts.dont_migrate is not None and opts.dont_migrate != 0:
                w = backlog.get_work_record(w_id)
                if w['Test_Plan__c'] is not None:
                    add = False
                
            if add == True:
                qa.add_story_to_plan(opts.plan, w_id)
            

    except Exception, e:
        indent = len(program_name) * " "
        sys.stderr.write(program_name + ": " + repr(e) + "\n")
        sys.stderr.write(indent + "  for help use --help")
        return 2


if __name__ == "__main__":
    sys.exit(main())