#!/usr/bin/env python
# encoding: utf-8
'''
bin.gus_teams -- shortdesc

bin.gus_teams is a description

It defines classes_and_methods

@author:     Shawn Crosby
        
@copyright:  2013 organization_name. All rights reserved.
        
@license:    license

@contact:    scrosby@salesforce.com
@deffield    updated: Updated
'''

import sys
import os

from argparse import ArgumentParser
from argparse import RawDescriptionHelpFormatter

from gus.ScrumTeamClient import ScrumTeamClient

__all__ = []
__version__ = 0.1
__date__ = '2013-09-11'
__updated__ = '2013-09-11'

def main(argv=None): # IGNORE:C0111
    '''Command line options.'''
    
    if argv is None:
        argv = sys.argv
    else:
        sys.argv.extend(argv)

    program_name = os.path.basename(sys.argv[0])
    program_shortdesc = __import__('__main__').__doc__.split("\n")[1]
    program_license = '''%s

  Created by user_name on %s.
  Copyright 2013 organization_name. All rights reserved.
  
  Licensed under the Apache License 2.0
  http://www.apache.org/licenses/LICENSE-2.0
  
  Distributed on an "AS IS" basis without warranties
  or conditions of any kind, either express or implied.

USAGE
''' % (program_shortdesc, str(__date__))

    try:
        # Setup argument parser
        parser = ArgumentParser(description=program_license, formatter_class=RawDescriptionHelpFormatter)
        parser.add_argument("-q", "--query", dest="query", help="Name or partial name of team")
        
        # Process arguments
        args = parser.parse_args()
        
        query = args.query
        gus = ScrumTeamClient()
        
        if query:
            teams = gus.find_team_by_name(query)
            for team in teams:
                print("{} - {}".format(team['Id'], team['Name']))
        
        else:
            userid = gus.get_current_user_id()
            teams = gus.get_scrum_teams_for_user(userid)
            for team in teams:
                print("{} - {}".format(team[0], team[1]))
        
        
        return 0
    except KeyboardInterrupt:
        ### handle keyboard interrupt ###
        return 0
    except Exception as e:
        indent = len(program_name) * " "
        sys.stderr.write(program_name + ": " + repr(e) + "\n")
        sys.stderr.write(indent + "  for help use --help\n")
        return 2

if __name__ == "__main__":
    sys.exit(main())