from userdata.Store import Store
from sf.Session import SoapSession

class GusSession(Store):
    '''
    Persists and loads local session data to facilitate login to
    Gus specifically.
    '''
    
    def login(self, user, password, security_token):
        '''
        Authenticates to Gus using a Soap Login with a provided username, password and
        security token.  Returns the Gus Session ID
        '''
        session = SoapSession(user, password, security_token, 'gus.salesforce.com')
        sessionId = session.get_session_id()
        
        self.store(session_id=sessionId, token=security_token, user_name=user)

        return sessionId
    
    def load_gus_token(self):
        '''
        Retrieves the locally cached security token or None if not found
        '''
        return self.__get_local__('token')
    
    def load_session_id(self):
        '''
        Retrieves the locally cached Gus Session ID or None if not found
        '''
        return self.__get_local__('session_id')
    
    def load_user_name(self):
        '''
        Retrieves the locally cached Gus username or None if not found
        '''
        return self.__get_local__('user_name')
    
