#!/usr/bin/env python
# encoding: utf-8

import sys
import os

from gus.Gus import Client

__all__ = []
__version__ = 0.1
__date__ = '2013-09-12'
__updated__ = '2013-09-12'


def main(argv=None): # IGNORE:C0111
    '''Command line options.'''
    
    if argv is None:
        argv = sys.argv
    else:
        sys.argv.extend(argv)

    program_name = os.path.basename(sys.argv[0])

    try:
        gus = Client()
        print("Current User ID: {}".format(gus.get_current_user_id()))
        
        return 0
    except KeyboardInterrupt:
        ### handle keyboard interrupt ###
        return 0
    except Exception, e:
        indent = len(program_name) * " "
        sys.stderr.write(program_name + ": " + repr(e) + "\n")
        sys.stderr.write(indent + "  for help use --help")
        return 2

if __name__ == "__main__":
    sys.exit(main())