#!/usr/bin/env python
# encoding: utf-8
'''
Created on Nov 28, 2013

@author: scrosby
'''
import sys
import os
from argparse import ArgumentParser
from gus.BacklogClient import BacklogClient

__all__ = []
__version__ = 0.1
__date__ = '2013-11-28'
__updated__ = '2013-11-28'

gus = BacklogClient()

def assign(work, build):
    print("Assigning bug {} to build {}".format(work, build))
    gus.assign_work_to_build(work, build)

def main(argv=None): # IGNORE:C0111
    '''Command line options.'''
    
    if argv is None:
        argv = sys.argv
    else:
        sys.argv.extend(argv)

    program_name = os.path.basename(sys.argv[0])
    program_version = "v0.1"
    program_build_date = "%s" % __updated__
 
    program_version_string = '%s %s (%s)' % (program_name, program_version, program_build_date)
    program_longdesc = '''Updates Sprints with incomplete work'''
    program_license = "Copyright 2013 Shawn Crosby (salesforce.com)                                            \
                Licensed under the Apache License 2.0\nhttp://www.apache.org/licenses/LICENSE-2.0"
 
    if argv is None:
        argv = sys.argv[1:]
        
    try:
        # setup option parser
        parser = ArgumentParser(version=program_version_string, epilog=program_longdesc, description=program_license)
        parser.add_argument("-t", "--teamid", dest="teamid", help="Use the Object ID representing the team in GUS")
        parser.add_argument("-p", "--priority", dest="priority", help="The Bug Priority to push")
        parser.add_argument("-r", "--release", dest="release", help="The name of the build to schedule release")
        args, unknown = parser.parse_known_args(argv)
        
        if args.teamid and args.priority and args.release:
            buildid = gus.find_build_id(args.release)
            if args.priority=='1' or args.priority=='P1' or args.priority=='p1':
                p = 'P1'
                bugs = gus.get_unresolved_p1_bugs_for_team(args.teamid)
            elif args.priority=='2' or args.priority=='P2' or args.priority=='p2':
                p = 'P2'
                bugs = gus.get_unresolved_p2_bugs_for_team(args.teamid)
            
            print "Assigning {} {} bugs to release {}".format(len(bugs), p, args.release)
                
            for work in bugs:
                assign(work, buildid)
        else:
            print "Must Provide Team, Priority and Release"
        
        # push unresolved
        
    except KeyboardInterrupt:
        ### handle keyboard interrupt ###
        return 0
    except Exception as e:
        indent = len(program_name) * " "
        sys.stderr.write(program_name + ": " + repr(e) + "\n")
        sys.stderr.write(indent + "  for help use --help")
        return 2

if __name__ == "__main__":
    sys.exit(main())        