'''
Created on Nov 28, 2014

@author: scrosby
'''
import re

class StoryParser:
    STORY_PATTERN=ur'As (.+?)[\s\r\n]*?(I can|I want|I require|I am able|I would like|I\'d like|I am|I expect|I must|I should|I need) (.+?)'
    BENEFIT_PATTERN=ur'[\s\r\n]*?so that (.*)'
    
    def __init__(self, story):
        self.story = story
        
    def is_functional(self):
        return self.get_persona() is not None and self.get_function() is not None
    
    def is_complete(self):
        return self.is_functional() and self.get_benefit() is not None
    
    def __parse__(self):
        match = re.search(self.STORY_PATTERN + self.BENEFIT_PATTERN, self.story, re.IGNORECASE | re.DOTALL)
        if not match:
            match = re.search(self.STORY_PATTERN, self.story, re.IGNORECASE | re.DOTALL)
        return match
    
    def get_persona(self):
        match = self.__parse__()
        if match:
            return re.sub("[\r\n]+", " ", match.group(1)).replace(",","").lower()
        return None
    
    def get_function(self):
        match = self.__parse__()
        if match:
            return match.group(3)
        return None
    
    def get_benefit(self):
        match = self.__parse__()
        if match and len(match.groups()) >= 4:
            return match.group(4)
        return None
