'''
Created on Nov 28, 2014

@author: scrosby
'''
import unittest
from agile.StoryParser import StoryParser


class Test(unittest.TestCase):
    GOOD_STORY = "As a\nPlumber, I can turn a wrench so that I can loosen pipes"
    MULTILINE_STORY = "As a plumber\nI can turn a wrench\nso that I can loosen pipes"
    PARTIAL_STORY = "As a plumber I can turn a wrench"
    BAD_STORY = "this is not a story"

    def test_can_get_persona_from_user_story(self):
        p = StoryParser(self.GOOD_STORY)
        self.assertEqual("a plumber", p.get_persona(), "Didn't Get Persona: {}".format(p.get_persona()))
        
    def test_can_get_persona_from_partial_story(self):
        p = StoryParser(self.PARTIAL_STORY)
        self.assertEqual("a plumber", p.get_persona(), "didn't get correct persona: {}".format(p.get_persona()))
        
    def test_we_get_no_persona_when_not_story_format(self):
        p = StoryParser(self.BAD_STORY)
        self.assertIsNone(p.get_persona(), "Got a persona when I shouldn't have")
        
    def test_can_get_function(self):
        p = StoryParser(self.GOOD_STORY)
        self.assertEqual("turn a wrench", p.get_function(), "Didn't get Function: {}".format(p.get_function()))
        
    def test_we_get_no_function_when_not_a_story(self):
        p = StoryParser(self.BAD_STORY)
        self.assertIsNone(p.get_function(), "Got a function when I shouldn't have")
        
    def test_can_get_benefit(self):
        p = StoryParser(self.GOOD_STORY)
        self.assertEqual("I can loosen pipes", p.get_benefit(), "didn't get benefit: {}".format(p.get_benefit()))
        
    def test_we_get_no_benefit_when_not_a_story(self):
        p = StoryParser(self.BAD_STORY)
        self.assertIsNone(p.get_benefit(), "Got a benefit when I shouldn't have")
        
    def test_we_get_no_benefit_when_partial_story(self):
        p = StoryParser(self.PARTIAL_STORY)
        self.assertIsNone(p.get_benefit(), "Got a benefit when there wasn't one")
        
    def test_is_functional_when_story_has_persona_and_function(self):
        p = StoryParser(self.GOOD_STORY)
        self.assertTrue(p.is_functional(), "Expected Good Story to be functional")
        
    def test_is_complete_when_story_has_persona_function_and_benefit(self):
        p = StoryParser(self.GOOD_STORY)
        self.assertTrue(p.is_complete(), "Expected good story to be complete")
        
    def test_we_can_detect_a_partial_story(self):
        p = StoryParser(self.PARTIAL_STORY)
        self.assertTrue(p.is_functional(), "Expected partial story to be functional")
        
    def test_can_parse_multiline_stories(self):
        p = StoryParser(self.MULTILINE_STORY)
        self.assertTrue(p.is_complete(), "Expected multiline to be complete")

if __name__ == "__main__":
    #import sys;sys.argv = ['', 'Test.testName']
    unittest.main()