#!/usr/bin/env python
# encoding: utf-8
'''
bin.gus_acceptance_criteria -- shortdesc

bin.gus_acceptance_criteria is a description

It defines classes_and_methods

@author:     user_name

@copyright:  2014 organization_name. All rights reserved.

@license:    license

@contact:    user_email
@deffield    updated: Updated
'''

import sys
import os

from optparse import OptionParser
from gus.BacklogClient import BacklogClient

__all__ = []
__version__ = 0.1
__date__ = '2014-08-22'
__updated__ = '2014-08-22'

def main(argv=None):
    '''Command line options.'''

    program_name = os.path.basename(sys.argv[0])
    program_version = "v0.1"
    program_build_date = "%s" % __updated__

    program_version_string = '%%prog %s (%s)' % (program_version, program_build_date)
    #program_usage = '''usage: spam two eggs''' # optional - will be autogenerated by optparse
    program_longdesc = '''''' # optional - give further explanation about what the program does
    program_license = "Copyright 2014 user_name (organization_name)                                            \
                Licensed under the Apache License 2.0\nhttp://www.apache.org/licenses/LICENSE-2.0"

    if argv is None:
        argv = sys.argv[1:]
    try:
        # setup option parser
        parser = OptionParser(version=program_version_string, epilog=program_longdesc, description=program_license)


        # process options
        (opts, args) = parser.parse_args(argv)
        
        gus = BacklogClient()

        # MAIN BODY #
        for work in args:
            w_record = gus.find_work(work)
            all_ac = gus.get_acceptance_criteria_for_work(w_record['Id'])
            print("{} - {}".format(w_record['Name'], w_record['Subject__c']))
            for acid in all_ac:
                ac = gus.get_acceptance_criterion_record(acid)
                if ac['Name'] != 'Background':
                    print("  {}".format(ac['Name']))
        

    except Exception, e:
        indent = len(program_name) * " "
        sys.stderr.write(program_name + ": " + repr(e) + "\n")
        sys.stderr.write(indent + "  for help use --help")
        return 2


if __name__ == "__main__":
    sys.exit(main())