#!/usr/bin/env python
# encoding: utf-8
'''
bin.gus_test_cases -- shortdesc

bin.gus_test_cases is a description

It defines classes_and_methods

@author:     user_name

@copyright:  2014 organization_name. All rights reserved.

@license:    license

@contact:    user_email
@deffield    updated: Updated
'''

import sys, os

from optparse import OptionParser
from gus.QAForceClient import QAForceClient
from gus.BacklogClient import BacklogClient

__all__ = []
__version__ = 0.1
__date__ = '2014-08-17'
__updated__ = '2014-08-17'

def main(argv=None):
    '''Command line options.'''

    program_name = os.path.basename(sys.argv[0])
    program_version = "v0.1"
    program_build_date = "%s" % __updated__

    program_version_string = '%%prog %s (%s)' % (program_version, program_build_date)
    #program_usage = '''usage: spam two eggs''' # optional - will be autogenerated by optparse
    program_longdesc = '''''' # optional - give further explanation about what the program does
    program_license = "Copyright 2014 user_name (organization_name)                                            \
                Licensed under the Apache License 2.0\nhttp://www.apache.org/licenses/LICENSE-2.0"

    if argv is None:
        argv = sys.argv[1:]
    try:
        # setup option parser
        parser = OptionParser(version=program_version_string, epilog=program_longdesc, description=program_license)
        parser.add_option("-t", "--team", dest="team", help="The ID of the team to look at test cases")
        parser.add_option("-r", "--release", dest="release", help="Name of the release to look at test cases")

        (opts, args) = parser.parse_args(argv)
        
        if opts.release is not None and opts.team is None:
            raise Exception("You need to specify a team if you want a release report")
        
        gus = BacklogClient()
        
        if opts.team:
            if opts.release:
                # List test cases for work in release
                work_ids = gus.get_work_ids_for_release(opts.release, opts.team)
                args = []
                for wid in work_ids:
                    w = gus.get_work_record(wid)
                    if w['RecordTypeId'] == '0129000000006gDAAQ':
                        args.append(w['Name'])
            else:
                # List test cases for current sprint
                sprint = gus.get_current_sprint_for_team(opts.team)
                args = [x[0] for x in gus.get_work_for_sprint(sprint)]
                
        qa = QAForceClient()

        no_tests = []
        for arg in args:
            try:
                work = qa.find_work(arg)
                test_case_ids = qa.get_test_case_ids_for_story(work['Id'])
                if len(test_case_ids) > 0:
                    print("+".rjust(85, "-"))
                    print("{} - {}".format(work['Name'], work['Subject__c']))
                    print("+".rjust(85, "-"))
                    for tc_id in test_case_ids:
                        test_case = qa.get_test_case_record(tc_id)
                        print("{} - {}".format(test_case['Name'], test_case['Brief_Description__c']))
                else:
                    no_tests.append("{} - {}.".format(arg, work['Subject__c']))
            except Exception as e:
                no_tests.append("Work record not found: {}".format(arg))
                
        if len(no_tests) > 0:
            print("+".rjust(85, "-"))
            print("The following work doesn't have test cases. Go talk to QE about it")
            for msg in no_tests:
                print ("\t{}".format(msg))

    except Exception as e:
        indent = len(program_name) * "  "
        sys.stderr.write(program_name + ": " + repr(e) + "\n")
        sys.stderr.write(indent + "  for help use --help")
        return 2
    
if __name__ == "__main__":
    sys.exit(main())