from gus.Gus import Client

class TaskClient(Client):
    def get_tasks_for_work_item(self, workid):
        soql = "Select Id from ADM_Task__c where Work__c = '{}'".format(workid)
        result = self.sf_session.query(soql)
        return [x['Id'] for x in result['records']]
    
    def create_task_for_work_item(self, workid, description, owner=None):
        task = {}
        if owner is None:
            task['Assigned_To__c'] = self.get_current_user_id()
        else:
            task['Assigned_To__c'] = owner
        task['Status__c'] = 'Not Started'
        task['Work__c'] = workid
        task['Subject__c'] = description
        
        result = self.sf_session.ADM_Task__c.create(task)
        return result['id']