'''
Created on Sep 26, 2014

@author: scrosby
'''
from gus.Gus import Client
import datetime

class SupportClient(Client):
    def get_investigations_this_month_created_by_user(self, user):
        result = self.sf_session.query("Select Id from ADM_Work__c where CreatedById = '{}' and Number_of_Cases__c > 0 and (CreatedDate = THIS_MONTH or Closed_On__c = THIS_MONTH or Closed__c = 0)".format(user))
        return [x['Id'] for x in result['records']]
    
    def get_investigations_last_month_created_by_user(self, user):
        result = self.sf_session.query("Select Id from ADM_Work__c where CreatedById = '{}' and Number_of_Cases__c > 0 and (CreatedDate = LAST_MONTH or Closed_On__c = LAST_MONTH)".format(user))
        return [x['Id'] for x in result['records']]

    def get_team_open_investigations(self, team):
        result = self.sf_session.query("Select Id from ADM_Work__c where RecordTypeId = '{}' and Closed__c = 0 and Number_of_Cases__c > 0 and Scrum_Team__c = '{}'".format(Client.WORK_RECORD_TYPES['Investigation'], team))
        return [x['Id'] for x in result['records']]
    
    def get_last_month_team_investigations(self, team):
        result = self.sf_session.query("Select Id from ADM_Work__c where CreatedDate = LAST_MONTH and RecordTypeId = '{}' and Number_of_Cases__c > 0 and Scrum_Team__c = '{}'".format(Client.WORK_RECORD_TYPES['Investigation'], team))
        return [x['Id'] for x in result['records']]
    
    def get_investigations_touched_by_team_this_month(self, team):
        result = self.sf_session.query("Select ParentId from ADM_Work__History where CreatedDate = THIS_MONTH and Field = 'Scrum_Team__c' and OldValue = '{}'".format(team))
        out = []
        for x in result['records']:
            if x['Id'] not in out:
                out.append(x['Id'])
                
        return out
    
    def get_open_customer_p1_bugs_by_team(self, team, priority='P1'):
        soql = "SELECT Id FROM ADM_Work__c WHERE Scrum_Team__c = '{}' AND Priority__c = '{}' AND Closed__c = 0 AND RecordTypeId = '{}' and Number_of_Cases__c > 0".format(team, priority, self.WORK_RECORD_TYPES['Bug'])
        result = self.sf_session.query(soql)
        return [x['Id'] for x in result['records']]
    
    def get_open_customer_p2_bugs_by_team(self, team):
        return self.get_open_customer_p1_bugs_by_team(team, priority='P2')
    
    def get_this_month_team_investigations(self, team):
        result = self.sf_session.query("Select Id from ADM_Work__c where CreatedDate = THIS_MONTH and RecordTypeId = '{}' and Scrum_Team__c = '{}'".format(Client.WORK_RECORD_TYPES['Investigation'], team))
        return [x['Id'] for x in result['records']]
    
    def get_last_two_month_team_investigations(self, team):
        result = self.sf_session.query("Select Id from ADM_Work__c where CreatedDate in (THIS_MONTH, LAST_MONTH) and RecordTypeId = '{}' and Scrum_Team__c = '{}'".format(Client.WORK_RECORD_TYPES['Investigation'], team))
        return [x['Id'] for x in result['records']]

    def get_investigation_team_assignment_history(self, work):
        result = self.sf_session.query("SELECT CreatedDate, OldValue, NewValue FROM ADM_Work__History where parentId = '{}' and Field = 'Scrum_Team__c'".format(work))
        out = []
        for x in result['records']:
            if x['CreatedDate'] not in [y[0] for y in out]:
                out.append((x['CreatedDate'], x['OldValue'], x['NewValue']))
                
        return out
    
    def get_seconds_for_work_id_list(self, work_id_list, period_start=None):
        soql = "Select CreatedDate, Closed__c, Closed_On__c from ADM_Work__c where Id in ('{}')".format("','".join(work_id_list))
        result = self.sf_session.query(soql)
        TIME_FORMAT="%Y-%m-%dT%H:%M:%S.000+0000"
        total_seconds = 0
        for record in result['records']:
            start = datetime.datetime.strptime(record['CreatedDate'], TIME_FORMAT)
            if period_start is not None and start < period_start:
                    start = period_start

            if record['Closed__c'] == 0:
                end = datetime.datetime.utcnow()
            else:
                end = datetime.datetime.strptime(record['Closed_On__c'], TIME_FORMAT)
                
            total_seconds += (end - start).total_seconds()
            
        return total_seconds
    
    def get_investigation_assignment_history(self, work):
        result = self.sf_session.query("SELECT CreatedDate, OldValue, NewValue FROM ADM_Work__History where parentId = '{}' and Field = 'Assignee__c'".format(work))
        out = []
        for x in result['records']:
            if x['CreatedDate'] not in [y[0] for y in out]:
                out.append((x['CreatedDate'], x['OldValue'], x['NewValue']))
                
        return out
    