from distutils.core import setup
import os
import re


def find(root, path_type, found=None):
    assert path_type in (find.FILE, find.DIRECTORY)

    if found is None:
        found = set()

    for root, dirs, files in os.walk(root):
        if path_type == 'd':
            found.add(root)
            yieldable = dirs
        elif path_type == 'f':
            yieldable = files
        for basename in yieldable:
            found.add(os.path.join(root, basename))

    return sorted(found)
find.FILE = 'f'
find.DIRECTORY = 'd'


def path2module(path):
    return re.sub('/', '.', path)


setup(
    name='gutenberg_cleaner',
    version='0.0.3',
    author='Clemens Wolff',
    author_email='clemens.wolff+pypi@gmail.com',
    packages=map(path2module, find('gutenberg_cleaner', find.DIRECTORY)),
    scripts=find('scripts', find.FILE),
    url='https://github.com/c-w/GutenbergCleaner',
    download_url='http://pypi.python.org/pypi/GutenbergCleaner',
    license='LICENSE.txt',
    description='Module to clean up texts from Project Gutenberg',
    long_description=open('README.rst').read(),
    install_requires=list(line.strip() for line in open('requirements.txt')),
)
