"""IO utility functions."""


import codecs


def determine_encoding(path, default=None):
    """Determines the encoding of a file based on byte order marks.

    Arguments:
        path (str): The path to a file.
        default (str, optional): The encoding to return if the byte-order-mark
            lookup does not return an answer.

    Returns:
        str: The encoding of the file.

    """
    byte_order_marks = (
        ('utf-8-sig', (codecs.BOM_UTF8, )),
        ('utf-16', (codecs.BOM_UTF16_LE, codecs.BOM_UTF16_BE)),
        ('utf-32', (codecs.BOM_UTF32_LE, codecs.BOM_UTF32_BE)),
    )

    with open(path, 'rb') as infile:
        raw = infile.read(4)

    for encoding, boms in byte_order_marks:
        if any(raw.startswith(bom) for bom in boms):
            return encoding

    return default
