"""Regression tests for gutenberg_cleaner"""


from nose.exc import SkipTest as nose_SkipTest
from nose.tools import eq_ as nose_eq
import codecs
import itertools
import nose
import os

from gutenberg_cleaner import strip_headers
from gutenberg_cleaner.io import determine_encoding


SKIP_TESTS = frozenset((
))

DATA_DIR = os.path.join(os.path.dirname(__file__), 'regression-tests')
WHEN_SUFFIX = '-when'
THEN_SUFFIX = '-then'


def _regression_data(test_name):
    """Loads the regression data for a given regression test.

    """
    when_path = os.path.join(DATA_DIR, test_name + WHEN_SUFFIX)
    then_path = os.path.join(DATA_DIR, test_name + THEN_SUFFIX)
    assert os.path.exists(when_path), 'input missing for test %s' % test_name
    assert os.path.exists(then_path), 'ouput missing for test %s' % test_name

    when = _readlines(when_path)
    then = _readlines(then_path)
    return when, then


def _test_names():
    """Returns the names of all the regression test.

    """
    return sorted(set(_rstrip(filename, (WHEN_SUFFIX, THEN_SUFFIX))
                      for filename in os.listdir(DATA_DIR)))


def test_pairs():
    """Regression test generator.

    """
    for test_name in _test_names():
        yield runtest, test_name


def runtest(test_name, ignored=SKIP_TESTS):
    """A single test for nose.

    """
    when, then = _regression_data(test_name)
    result = strip_headers(when).splitlines()

    try:
        for expected, actual in itertools.izip(then, result):
            nose_eq(expected, actual)
    except AssertionError:
        if test_name in ignored:
            raise nose_SkipTest('skipping {0}'.format(test_name))
        else:
            raise


def _readlines(path, encoding=None):
    """Returns a file using the specified encoding and returns the lines in the
    file.

    """
    if encoding is None:
        encoding = determine_encoding(path, 'utf-8')

    with codecs.open(path, 'r', encoding) as infile:
        lines = infile.read().splitlines()
    return lines


def _rstrip(thestring, suffixes):
    """Strips some suffixes from the end of a string.

    """
    for suffix in suffixes:
        if thestring.endswith(suffix):
            thestring = thestring[:-len(suffix)]
    return thestring


def _main():
    """Run Nose."""
    nose.main()


if __name__ == '__main__':
    _main()
