# -*- coding: utf-8 -*-
"""
ISO639-2 standart: the module only contains the dictionary ISO639_2
which maps a language code in three letters (eg. "fre") to a language
name in english (eg. "French").
"""

# ISO-639, the list comes from:
# http://www.loc.gov/standards/iso639-2/php/English_list.php
_ISO639 = (
    (u"Abkhazian", "abk", "ab"),
    (u"Achinese", "ace", None),
    (u"Acoli", "ach", None),
    (u"Adangme", "ada", None),
    (u"Adygei", "ady", None),
    (u"Adyghe", "ady", None),
    (u"Afar", "aar", "aa"),
    (u"Afrihili", "afh", None),
    (u"Afrikaans", "afr", "af"),
    (u"Afro-Asiatic (Other)", "afa", None),
    (u"Ainu", "ain", None),
    (u"Akan", "aka", "ak"),
    (u"Akkadian", "akk", None),
    (u"Albanian", "alb/sqi", "sq"),
    (u"Alemani", "gsw", None),
    (u"Aleut", "ale", None),
    (u"Algonquian languages", "alg", None),
    (u"Altaic (Other)", "tut", None),
    (u"Amharic", "amh", "am"),
    (u"Angika", "anp", None),
    (u"Apache languages", "apa", None),
    (u"Arabic", "ara", "ar"),
    (u"Aragonese", "arg", "an"),
    (u"Aramaic", "arc", None),
    (u"Arapaho", "arp", None),
    (u"Araucanian", "arn", None),
    (u"Arawak", "arw", None),
    (u"Armenian", "arm/hye", "hy"),
    (u"Aromanian", "rup", None),
    (u"Artificial (Other)", "art", None),
    (u"Arumanian", "rup", None),
    (u"Assamese", "asm", "as"),
    (u"Asturian", "ast", None),
    (u"Athapascan languages", "ath", None),
    (u"Australian languages", "aus", None),
    (u"Austronesian (Other)", "map", None),
    (u"Avaric", "ava", "av"),
    (u"Avestan", "ave", "ae"),
    (u"Awadhi", "awa", None),
    (u"Aymara", "aym", "ay"),
    (u"Azerbaijani", "aze", "az"),
    (u"Bable", "ast", None),
    (u"Balinese", "ban", None),
    (u"Baltic (Other)", "bat", None),
    (u"Baluchi", "bal", None),
    (u"Bambara", "bam", "bm"),
    (u"Bamileke languages", "bai", None),
    (u"Banda", "bad", None),
    (u"Bantu (Other)", "bnt", None),
    (u"Basa", "bas", None),
    (u"Bashkir", "bak", "ba"),
    (u"Basque", "baq/eus", "eu"),
    (u"Batak (Indonesia)", "btk", None),
    (u"Beja", "bej", None),
    (u"Belarusian", "bel", "be"),
    (u"Bemba", "bem", None),
    (u"Bengali", "ben", "bn"),
    (u"Berber (Other)", "ber", None),
    (u"Bhojpuri", "bho", None),
    (u"Bihari", "bih", "bh"),
    (u"Bikol", "bik", None),
    (u"Bilin", "byn", None),
    (u"Bini", "bin", None),
    (u"Bislama", "bis", "bi"),
    (u"Blin", "byn", None),
    (u"Bokmål, Norwegian", "nob", "nb"),
    (u"Bosnian", "bos", "bs"),
    (u"Braj", "bra", None),
    (u"Breton", "bre", "br"),
    (u"Buginese", "bug", None),
    (u"Bulgarian", "bul", "bg"),
    (u"Buriat", "bua", None),
    (u"Burmese", "bur/mya", "my"),
    (u"Caddo", "cad", None),
    (u"Carib", "car", None),
    (u"Castilian", "spa", "es"),
    (u"Catalan", "cat", "ca"),
    (u"Caucasian (Other)", "cau", None),
    (u"Cebuano", "ceb", None),
    (u"Celtic (Other)", "cel", None),
    (u"Central American Indian (Other)", "cai", None),
    (u"Chagatai", "chg", None),
    (u"Chamic languages", "cmc", None),
    (u"Chamorro", "cha", "ch"),
    (u"Chechen", "che", "ce"),
    (u"Cherokee", "chr", None),
    (u"Chewa", "nya", "ny"),
    (u"Cheyenne", "chy", None),
    (u"Chibcha", "chb", None),
    (u"Chichewa", "nya", "ny"),
    (u"Chinese", "chi/zho", "zh"),
    (u"Chinook jargon", "chn", None),
    (u"Chipewyan", "chp", None),
    (u"Choctaw", "cho", None),
    (u"Chuang", "zha", "za"),
    (u"Church Slavic", "chu", "cu"),
    (u"Church Slavonic", "chu", "cu"),
    (u"Chuukese", "chk", None),
    (u"Chuvash", "chv", "cv"),
    (u"Classical Nepal Bhasa", "nwc", None),
    (u"Classical Newari", "nwc", None),
    (u"Coptic", "cop", None),
    (u"Cornish", "cor", "kw"),
    (u"Corsican", "cos", "co"),
    (u"Cree", "cre", "cr"),
    (u"Creek", "mus", None),
    (u"Creoles and pidgins (Other)", "crp", None),
    (u"Creoles and pidgins, English based (Other)", "cpe", None),
    (u"Creoles and pidgins, French-based (Other)", "cpf", None),
    (u"Creoles and pidgins, Portuguese-based (Other)", "cpp", None),
    (u"Crimean Tatar", "crh", None),
    (u"Crimean Turkish", "crh", None),
    (u"Croatian", "scr/hrv", "hr"),
    (u"Cushitic (Other)", "cus", None),
    (u"Czech", "cze/ces", "cs"),
    (u"Dakota", "dak", None),
    (u"Danish", "dan", "da"),
    (u"Dargwa", "dar", None),
    (u"Dayak", "day", None),
    (u"Delaware", "del", None),
    (u"Dhivehi", "div", "dv"),
    (u"Dimili", "zza", None),
    (u"Dimli", "zza", None),
    (u"Dinka", "din", None),
    (u"Divehi", "div", "dv"),
    (u"Dogri", "doi", None),
    (u"Dogrib", "dgr", None),
    (u"Dravidian (Other)", "dra", None),
    (u"Duala", "dua", None),
    (u"Dutch", "dut/nld", "nl"),
    (u"Dutch, Middle (ca.1050-1350)", "dum", None),
    (u"Dyula", "dyu", None),
    (u"Dzongkha", "dzo", "dz"),
    (u"Eastern Frisian", "frs", None),
    (u"Efik", "efi", None),
    (u"Egyptian (Ancient)", "egy", None),
    (u"Ekajuk", "eka", None),
    (u"Elamite", "elx", None),
    (u"English", "eng", "en"),
    (u"English, Middle (1100-1500)", "enm", None),
    (u"English, Old (ca.450-1100)", "ang", None),
    (u"Erzya", "myv", None),
    (u"Esperanto", "epo", "eo"),
    (u"Estonian", "est", "et"),
    (u"Ewe", "ewe", "ee"),
    (u"Ewondo", "ewo", None),
    (u"Fang", "fan", None),
    (u"Fanti", "fat", None),
    (u"Faroese", "fao", "fo"),
    (u"Fijian", "fij", "fj"),
    (u"Filipino", "fil", None),
    (u"Finnish", "fin", "fi"),
    (u"Finno-Ugrian (Other)", "fiu", None),
    (u"Flemish", "dut/nld", "nl"),
    (u"Fon", "fon", None),
    (u"French", "fre/fra", "fr"),
    (u"French, Middle (ca.1400-1600)", "frm", None),
    (u"French, Old (842-ca.1400)", "fro", None),
    (u"Friulian", "fur", None),
    (u"Fulah", "ful", "ff"),
    (u"Ga", "gaa", None),
    (u"Gaelic", "gla", "gd"),
    (u"Galician", "glg", "gl"),
    (u"Ganda", "lug", "lg"),
    (u"Gayo", "gay", None),
    (u"Gbaya", "gba", None),
    (u"Geez", "gez", None),
    (u"Georgian", "geo/kat", "ka"),
    (u"German", "ger/deu", "de"),
    (u"German, Low", "nds", None),
    (u"German, Middle High (ca.1050-1500)", "gmh", None),
    (u"German, Old High (ca.750-1050)", "goh", None),
    (u"Germanic (Other)", "gem", None),
    (u"Gikuyu", "kik", "ki"),
    (u"Gilbertese", "gil", None),
    (u"Gondi", "gon", None),
    (u"Gorontalo", "gor", None),
    (u"Gothic", "got", None),
    (u"Grebo", "grb", None),
    (u"Greek, Ancient (to 1453)", "grc", None),
    (u"Greek, Modern (1453-)", "gre/ell", "el"),
    (u"Greenlandic", "kal", "kl"),
    (u"Guarani", "grn", "gn"),
    (u"Gujarati", "guj", "gu"),
    (u"Gwich´in", "gwi", None),
    (u"Haida", "hai", None),
    (u"Haitian", "hat", "ht"),
    (u"Haitian Creole", "hat", "ht"),
    (u"Hausa", "hau", "ha"),
    (u"Hawaiian", "haw", None),
    (u"Hebrew", "heb", "he"),
    (u"Herero", "her", "hz"),
    (u"Hiligaynon", "hil", None),
    (u"Himachali", "him", None),
    (u"Hindi", "hin", "hi"),
    (u"Hiri Motu", "hmo", "ho"),
    (u"Hittite", "hit", None),
    (u"Hmong", "hmn", None),
    (u"Hungarian", "hun", "hu"),
    (u"Hupa", "hup", None),
    (u"Iban", "iba", None),
    (u"Icelandic", "ice/isl", "is"),
    (u"Ido", "ido", "io"),
    (u"Igbo", "ibo", "ig"),
    (u"Ijo", "ijo", None),
    (u"Iloko", "ilo", None),
    (u"Inari Sami", "smn", None),
    (u"Indic (Other)", "inc", None),
    (u"Indo-European (Other)", "ine", None),
    (u"Indonesian", "ind", "id"),
    (u"Ingush", "inh", None),
    (u"Interlingua", "ina", "ia"),
    (u"Interlingue", "ile", "ie"),
    (u"Inuktitut", "iku", "iu"),
    (u"Inupiaq", "ipk", "ik"),
    (u"Iranian (Other)", "ira", None),
    (u"Irish", "gle", "ga"),
    (u"Irish, Middle (900-1200)", "mga", None),
    (u"Irish, Old (to 900)", "sga", None),
    (u"Iroquoian languages", "iro", None),
    (u"Italian", "ita", "it"),
    (u"Japanese", "jpn", "ja"),
    (u"Javanese", "jav", "jv"),
    (u"Judeo-Arabic", "jrb", None),
    (u"Judeo-Persian", "jpr", None),
    (u"Kabardian", "kbd", None),
    (u"Kabyle", "kab", None),
    (u"Kachin", "kac", None),
    (u"Kalaallisut", "kal", "kl"),
    (u"Kalmyk", "xal", None),
    (u"Kamba", "kam", None),
    (u"Kannada", "kan", "kn"),
    (u"Kanuri", "kau", "kr"),
    (u"Kara-Kalpak", "kaa", None),
    (u"Karachay-Balkar", "krc", None),
    (u"Karelian", "krl", None),
    (u"Karen", "kar", None),
    (u"Kashmiri", "kas", "ks"),
    (u"Kashubian", "csb", None),
    (u"Kawi", "kaw", None),
    (u"Kazakh", "kaz", "kk"),
    (u"Khasi", "kha", None),
    (u"Khmer", "khm", "km"),
    (u"Khoisan (Other)", "khi", None),
    (u"Khotanese", "kho", None),
    (u"Kikuyu", "kik", "ki"),
    (u"Kimbundu", "kmb", None),
    (u"Kinyarwanda", "kin", "rw"),
    (u"Kirdki", "zza", None),
    (u"Kirghiz", "kir", "ky"),
    (u"Kirmanjki", "zza", None),
    (u"Klingon", "tlh", None),
    (u"Komi", "kom", "kv"),
    (u"Kongo", "kon", "kg"),
    (u"Konkani", "kok", None),
    (u"Korean", "kor", "ko"),
    (u"Kosraean", "kos", None),
    (u"Kpelle", "kpe", None),
    (u"Kru", "kro", None),
    (u"Kuanyama", "kua", "kj"),
    (u"Kumyk", "kum", None),
    (u"Kurdish", "kur", "ku"),
    (u"Kurukh", "kru", None),
    (u"Kutenai", "kut", None),
    (u"Kwanyama", "kua", "kj"),
    (u"Ladino", "lad", None),
    (u"Lahnda", "lah", None),
    (u"Lamba", "lam", None),
    (u"Lao", "lao", "lo"),
    (u"Latin", "lat", "la"),
    (u"Latvian", "lav", "lv"),
    (u"Letzeburgesch", "ltz", "lb"),
    (u"Lezghian", "lez", None),
    (u"Limburgan", "lim", "li"),
    (u"Limburger", "lim", "li"),
    (u"Limburgish", "lim", "li"),
    (u"Lingala", "lin", "ln"),
    (u"Lithuanian", "lit", "lt"),
    (u"Lojban", "jbo", None),
    (u"Low German", "nds", None),
    (u"Low Saxon", "nds", None),
    (u"Lower Sorbian", "dsb", None),
    (u"Lozi", "loz", None),
    (u"Luba-Katanga", "lub", "lu"),
    (u"Luba-Lulua", "lua", None),
    (u"Luiseno", "lui", None),
    (u"Lule Sami", "smj", None),
    (u"Lunda", "lun", None),
    (u"Luo (Kenya and Tanzania)", "luo", None),
    (u"Lushai", "lus", None),
    (u"Luxembourgish", "ltz", "lb"),
    (u"Macedo-Romanian", "rup", None),
    (u"Macedonian", "mac/mkd", "mk"),
    (u"Madurese", "mad", None),
    (u"Magahi", "mag", None),
    (u"Maithili", "mai", None),
    (u"Makasar", "mak", None),
    (u"Malagasy", "mlg", "mg"),
    (u"Malay", "may/msa", "ms"),
    (u"Malayalam", "mal", "ml"),
    (u"Maldivian", "div", "dv"),
    (u"Maltese", "mlt", "mt"),
    (u"Manchu", "mnc", None),
    (u"Mandar", "mdr", None),
    (u"Mandingo", "man", None),
    (u"Manipuri", "mni", None),
    (u"Manobo languages", "mno", None),
    (u"Manx", "glv", "gv"),
    (u"Maori", "mao/mri", "mi"),
    (u"Marathi", "mar", "mr"),
    (u"Mari", "chm", None),
    (u"Marshallese", "mah", "mh"),
    (u"Marwari", "mwr", None),
    (u"Masai", "mas", None),
    (u"Mayan languages", "myn", None),
    (u"Mende", "men", None),
    (u"Mi'kmaq", "mic", None),
    (u"Micmac", "mic", None),
    (u"Minangkabau", "min", None),
    (u"Mirandese", "mwl", None),
    (u"Miscellaneous languages", "mis", None),
    (u"Mohawk", "moh", None),
    (u"Moksha", "mdf", None),
    (u"Moldavian", "mol", "mo"),
    (u"Mon-Khmer (Other)", "mkh", None),
    (u"Mongo", "lol", None),
    (u"Mongolian", "mon", "mn"),
    (u"Mossi", "mos", None),
    (u"Multiple languages", "mul", None),
    (u"Munda languages", "mun", None),
    (u"N'Ko", "nqo", None),
    (u"Nahuatl", "nah", None),
    (u"Nauru", "nau", "na"),
    (u"Navaho", "nav", "nv"),
    (u"Navajo", "nav", "nv"),
    (u"Ndebele, North", "nde", "nd"),
    (u"Ndebele, South", "nbl", "nr"),
    (u"Ndonga", "ndo", "ng"),
    (u"Neapolitan", "nap", None),
    (u"Nepal Bhasa", "new", None),
    (u"Nepali", "nep", "ne"),
    (u"Newari", "new", None),
    (u"Nias", "nia", None),
    (u"Niger-Kordofanian (Other)", "nic", None),
    (u"Nilo-Saharan (Other)", "ssa", None),
    (u"Niuean", "niu", None),
    (u"No linguistic content", "zxx", None),
    (u"Nogai", "nog", None),
    (u"Norse, Old", "non", None),
    (u"North American Indian", "nai", None),
    (u"North Ndebele", "nde", "nd"),
    (u"Northern Frisian", "frr", None),
    (u"Northern Sami", "sme", "se"),
    (u"Northern Sotho", "nso", None),
    (u"Norwegian", "nor", "no"),
    (u"Norwegian Bokmål", "nob", "nb"),
    (u"Norwegian Nynorsk", "nno", "nn"),
    (u"Nubian languages", "nub", None),
    (u"Nyamwezi", "nym", None),
    (u"Nyanja", "nya", "ny"),
    (u"Nyankole", "nyn", None),
    (u"Nynorsk, Norwegian", "nno", "nn"),
    (u"Nyoro", "nyo", None),
    (u"Nzima", "nzi", None),
    (u"Occitan (post 1500)", "oci", "oc"),
    (u"Oirat", "xal", None),
    (u"Ojibwa", "oji", "oj"),
    (u"Old Bulgarian", "chu", "cu"),
    (u"Old Church Slavonic", "chu", "cu"),
    (u"Old Newari", "nwc", None),
    (u"Old Slavonic", "chu", "cu"),
    (u"Oriya", "ori", "or"),
    (u"Oromo", "orm", "om"),
    (u"Osage", "osa", None),
    (u"Ossetian", "oss", "os"),
    (u"Ossetic", "oss", "os"),
    (u"Otomian languages", "oto", None),
    (u"Pahlavi", "pal", None),
    (u"Palauan", "pau", None),
    (u"Pali", "pli", "pi"),
    (u"Pampanga", "pam", None),
    (u"Pangasinan", "pag", None),
    (u"Panjabi", "pan", "pa"),
    (u"Papiamento", "pap", None),
    (u"Papuan (Other)", "paa", None),
    (u"Pedi", "nso", None),
    (u"Persian", "per/fas", "fa"),
    (u"Persian, Old (ca.600-400 B.C.)", "peo", None),
    (u"Philippine (Other)", "phi", None),
    (u"Phoenician", "phn", None),
    (u"Pilipino", "fil", None),
    (u"Pohnpeian", "pon", None),
    (u"Polish", "pol", "pl"),
    (u"Portuguese", "por", "pt"),
    (u"Prakrit languages", "pra", None),
    (u"Provençal", "oci", "oc"),
    (u"Provençal, Old (to 1500)", "pro", None),
    (u"Punjabi", "pan", "pa"),
    (u"Pushto", "pus", "ps"),
    (u"Quechua", "que", "qu"),
    (u"Raeto-Romance", "roh", "rm"),
    (u"Rajasthani", "raj", None),
    (u"Rapanui", "rap", None),
    (u"Rarotongan", "rar", None),
    (u"Reserved for local use", "qaa/qtz", None),
    (u"Romance (Other)", "roa", None),
    (u"Romanian", "rum/ron", "ro"),
    (u"Romany", "rom", None),
    (u"Rundi", "run", "rn"),
    (u"Russian", "rus", "ru"),
    (u"Salishan languages", "sal", None),
    (u"Samaritan Aramaic", "sam", None),
    (u"Sami languages (Other)", "smi", None),
    (u"Samoan", "smo", "sm"),
    (u"Sandawe", "sad", None),
    (u"Sango", "sag", "sg"),
    (u"Sanskrit", "san", "sa"),
    (u"Santali", "sat", None),
    (u"Sardinian", "srd", "sc"),
    (u"Sasak", "sas", None),
    (u"Saxon, Low", "nds", None),
    (u"Scots", "sco", None),
    (u"Scottish Gaelic", "gla", "gd"),
    (u"Selkup", "sel", None),
    (u"Semitic (Other)", "sem", None),
    (u"Sepedi", "nso", None),
    (u"Serbian", "scc/srp", "sr"),
    (u"Serer", "srr", None),
    (u"Shan", "shn", None),
    (u"Shona", "sna", "sn"),
    (u"Sichuan Yi", "iii", "ii"),
    (u"Sicilian", "scn", None),
    (u"Sidamo", "sid", None),
    (u"Sign Languages", "sgn", None),
    (u"Siksika", "bla", None),
    (u"Sindhi", "snd", "sd"),
    (u"Sinhala", "sin", "si"),
    (u"Sinhalese", "sin", "si"),
    (u"Sino-Tibetan (Other)", "sit", None),
    (u"Siouan languages", "sio", None),
    (u"Skolt Sami", "sms", None),
    (u"Slave (Athapascan)", "den", None),
    (u"Slavic (Other)", "sla", None),
    (u"Slovak", "slo/slk", "sk"),
    (u"Slovenian", "slv", "sl"),
    (u"Sogdian", "sog", None),
    (u"Somali", "som", "so"),
    (u"Songhai", "son", None),
    (u"Soninke", "snk", None),
    (u"Sorbian languages", "wen", None),
    (u"Sotho, Northern", "nso", None),
    (u"Sotho, Southern", "sot", "st"),
    (u"South American Indian (Other)", "sai", None),
    (u"South Ndebele", "nbl", "nr"),
    (u"Southern Altai", "alt", None),
    (u"Southern Sami", "sma", None),
    (u"Spanish", "spa", "es"),
    (u"Sranan Togo", "srn", None),
    (u"Sukuma", "suk", None),
    (u"Sumerian", "sux", None),
    (u"Sundanese", "sun", "su"),
    (u"Susu", "sus", None),
    (u"Swahili", "swa", "sw"),
    (u"Swati", "ssw", "ss"),
    (u"Swedish", "swe", "sv"),
    (u"Swiss German", "gsw", None),
    (u"Syriac", "syr", None),
    (u"Tagalog", "tgl", "tl"),
    (u"Tahitian", "tah", "ty"),
    (u"Tai (Other)", "tai", None),
    (u"Tajik", "tgk", "tg"),
    (u"Tamashek", "tmh", None),
    (u"Tamil", "tam", "ta"),
    (u"Tatar", "tat", "tt"),
    (u"Telugu", "tel", "te"),
    (u"Tereno", "ter", None),
    (u"Tetum", "tet", None),
    (u"Thai", "tha", "th"),
    (u"Tibetan", "tib/bod", "bo"),
    (u"Tigre", "tig", None),
    (u"Tigrinya", "tir", "ti"),
    (u"Timne", "tem", None),
    (u"Tiv", "tiv", None),
    (u"tlhIngan-Hol", "tlh", None),
    (u"Tlingit", "tli", None),
    (u"Tok Pisin", "tpi", None),
    (u"Tokelau", "tkl", None),
    (u"Tonga (Nyasa)", "tog", None),
    (u"Tonga (Tonga Islands)", "ton", "to"),
    (u"Tsimshian", "tsi", None),
    (u"Tsonga", "tso", "ts"),
    (u"Tswana", "tsn", "tn"),
    (u"Tumbuka", "tum", None),
    (u"Tupi languages", "tup", None),
    (u"Turkish", "tur", "tr"),
    (u"Turkish, Ottoman (1500-1928)", "ota", None),
    (u"Turkmen", "tuk", "tk"),
    (u"Tuvalu", "tvl", None),
    (u"Tuvinian", "tyv", None),
    (u"Twi", "twi", "tw"),
    (u"Udmurt", "udm", None),
    (u"Ugaritic", "uga", None),
    (u"Uighur", "uig", "ug"),
    (u"Ukrainian", "ukr", "uk"),
    (u"Umbundu", "umb", None),
    (u"Undetermined", "und", None),
    (u"Upper Sorbian", "hsb", None),
    (u"Urdu", "urd", "ur"),
    (u"Uyghur", "uig", "ug"),
    (u"Uzbek", "uzb", "uz"),
    (u"Vai", "vai", None),
    (u"Valencian", "cat", "ca"),
    (u"Venda", "ven", "ve"),
    (u"Vietnamese", "vie", "vi"),
    (u"Volapük", "vol", "vo"),
    (u"Votic", "vot", None),
    (u"Wakashan languages", "wak", None),
    (u"Walamo", "wal", None),
    (u"Walloon", "wln", "wa"),
    (u"Waray", "war", None),
    (u"Washo", "was", None),
    (u"Welsh", "wel/cym", "cy"),
    (u"Western Frisian", "fry", "fy"),
    (u"Wolof", "wol", "wo"),
    (u"Xhosa", "xho", "xh"),
    (u"Yakut", "sah", None),
    (u"Yao", "yao", None),
    (u"Yapese", "yap", None),
    (u"Yiddish", "yid", "yi"),
    (u"Yoruba", "yor", "yo"),
    (u"Yupik languages", "ypk", None),
    (u"Zande", "znd", None),
    (u"Zapotec", "zap", None),
    (u"Zaza", "zza", None),
    (u"Zazaki", "zza", None),
    (u"Zenaga", "zen", None),
    (u"Zhuang", "zha", "za"),
    (u"Zulu", "zul", "zu"),
    (u"Zuni", "zun", None),
)

# Bibliographic ISO-639-2 form (eg. "fre" => "French")
ISO639_2 = {}
for line in _ISO639:
    for key in line[1].split("/"):
        ISO639_2[key] = line[0]
del _ISO639

