# Copyright (c) 2009-2011 Te-je Rodgers
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation
# files (the "Software"), to deal in the Software without
# restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following
# conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.
#

import pkg_resources

from .finder import Finder, Plugin


class EpFinder(Finder):

    def __init__(self, path=None):
        self.env = pkg_resources.Environment(path)

    def __iter__(self):
        for project_name in self.env:
            dist = self.env[project_name][0]
            yield EpPlugin(dist)


class EpPlugin(Plugin):
    # Cache all the loaded entry points
    # Change to any map-like object at your will
    # Change to None to disable caching
    caches = {}

    def __init__(self, distribution):
        self.dist = distribution

    def implements(self, hook):
        return self.dist.get_entry_map(hook)

    def implementers(self, hook):
        group = hook
        cache = self.get_cache(group)

        if cache is not None:
            for imp in cache:
                yield imp
            return

        cache = []
        for ep_name in self.dist.get_entry_map(group):
            entry_info = self.dist.get_entry_info(group, ep_name)
            imp = entry_info.load()
            cache.append(imp)
            yield imp

        if self.caches is not None:
            self.caches[group] = cache

    def resourcestream(self, path):
        return pkg_resources.resource_stream(self.dist.as_requirement(), path)

    def get_cache(self, group):
        """Return a cache for the given entry point group."""
        if self.caches is not None:
            return self.caches.get(group)


__all__ = ['EpFinder', 'EpPlugin']
