# Copyright (c) 2009-2011 Te-je Rodgers
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation
# files (the "Software"), to deal in the Software without
# restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following
# conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.
#

from .finder import Finder, Plugin, register_global_finder
from .utils import SingletonMeta


registry = {}

class InternalPlugin(Plugin):
    @staticmethod
    def implements(hook):
        return hook in registry

    @staticmethod
    def implementers(hook):
        return iter(registry.get(hook, []))

    @staticmethod
    def resourcestream(path):
        return open(path, 'r')


class InternalFinder(Finder):
    def __iter__(self):
        yield InternalPlugin

    def __eq__(self, other):
        if isinstance(other, InternalFinder):
            return True
        else:
            return False

register_global_finder(InternalFinder())


def add_internal_extension(hook, extensionobj):
    """
    Add an internal extension to hatch.
    Internal extensions are those that aren't found in plugins, but
    in the application code.

    This is useful when the application supplies its own
    implementations to its established interfaces.

    Internal extensions are found by default if no finder is specified.

    """
    registry.setdefault(hook, set())
    registry[hook].add(extensionobj)
