import os

try:
    from setuptools import setup, find_packages
except ImportError:
    from distribute_setup import use_setuptools
    use_setuptools()
    from setuptools import setup, find_packages


def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()

setup(name='hatch',
      version='0.8',
      description='A framework for extending Python apps',
      author='Te-je Rodgers',
      author_email='te-je@geniphi.com',
      url='http://pypi.python.org/pypi/hatch',
      license='MIT/X11',
      long_description=read('README.rst'),
      packages=find_packages(),
      include_package_data=True,
      keywords=['egg', 'extension', 'plugin'],
      extras_require = {
          'eggs' : ["setuptools"],
      },
      classifiers = [
          "Programming Language :: Python",
          "Programming Language :: Python :: 2",
          "Development Status :: 3 - Alpha",
          "Environment :: Plugins",
          "Intended Audience :: Developers",
          "License :: OSI Approved :: MIT License",
          "Operating System :: OS Independent",
          "Topic :: Software Development :: Libraries :: Python Modules"
      ],
     )
