# -*- encoding: iso-8859-15 -*-

#################################################################
# haufe.hrs.configuration - a pseudo-hierarchical configuration
# management infrastructure
# (C) 2008, Haufe Mediengruppe, Freiburg
#################################################################


"""
Tests for haufe.hrs.configuration module
"""

import os
import unittest
from zope.interface.verify import verifyClass
from unittest import TestCase, TestSuite, makeSuite
from haufe.hrs.configuration.service import ConfigurationService
from haufe.hrs.configuration.interfaces import IConfigurationService

dirname = os.path.dirname(os.path.abspath(__file__))

class ServiceTests(TestCase):

    def _makeOne(self):
        return ConfigurationService(watch=False)

    def testVerifyInterface(self):
        verifyClass(IConfigurationService, ConfigurationService)

    def testService(self):
        service = self._makeOne()
        service.registerModel(os.path.join(dirname, 'model', 'cms.ini'))
        service.registerModel(os.path.join(dirname, 'model', 'toolbox.ini'))
        service.loadConfiguration(os.path.join(dirname, 'example-config.ini'))

        self.assertEqual(service.get('path', 'cms'), '/a/b/c') 
        self.assertEqual(service.get('checkout_path', 'cms'), '/foo/bar')
        self.assertEqual(service.get('port', 'cms'), 777)
        self.assertEqual(service.get('databases.db1', 'cms'), 'n/a')
        self.assertEqual(service.get('databases.db2', 'cms'), None)

    def testGetConfiguration(self):
        service = self._makeOne()
        service.registerModel(os.path.join(dirname, 'model', 'cms.ini'))
        service.registerModel(os.path.join(dirname, 'model', 'toolbox.ini'))
        service.loadConfiguration(os.path.join(dirname, 'example-config.ini'))
        got = service.getConfiguration()
        expected = {'cms.path' : '/a/b/c',
                    'cms.checkout_path' : '/foo/bar',
                    'cms.port' : 777,
                    'cms.databases.db1' : 'n/a',
                    'cms.databases.db2' : None,
                    'toolbox.active' : 0,
                   }
        self.assertEqual(got, expected)

    def testGetConfigurationForPrefix(self):
        service = self._makeOne()
        service.registerModel(os.path.join(dirname, 'model', 'cms.ini'))
        service.registerModel(os.path.join(dirname, 'model', 'toolbox.ini'))
        service.loadConfiguration(os.path.join(dirname, 'example-config.ini'))
        got = service.getConfigurationForPrefix('toolbox')
        expected = {'toolbox.active' : 0}
        self.assertEqual(got, expected)

    def testServiceAndReload(self):
        service = self._makeOne()
        service.registerModel(os.path.join(dirname, 'model', 'cms.ini'))
        service.registerModel(os.path.join(dirname, 'model', 'toolbox.ini'))
        service.loadConfiguration(os.path.join(dirname, 'example-config.ini'))
        self.assertEqual(service.get('path', 'cms'), '/a/b/c')                
        service.reload()
        self.assertEqual(service.get('path', 'cms'), '/a/b/c') 

def test_suite():
    return TestSuite((
        makeSuite(ServiceTests),
        ))

if __name__ == '__main__':
    unittest.main()


