# -*- coding: iso-8859-15 -*-

################################################################
# haufe.sharepoint
################################################################


import re
import logging
import sys
import os
import base64 ## for upload support
import urllib2
from ntlm import HTTPNtlmAuthHandler
from suds.client import Client
from suds.sax.element import Element
from suds.sax.attribute import Attribute
from suds.transport.https import WindowsHttpAuthenticated
from suds.transport.http import HttpAuthenticated
from haufe.sharepoint.other import Factory
from logger import logger as LOG

# Sharepoint field descriptors start with *one* underscore (hopefully)
field_regex = re.compile(r'^_[a-zA-Z0-9]') 
_marker = object
factory = None


class OperationalError(Exception):
    """ Generic error """

class NotFound(Exception):
    """ List item not found """

class DictProxy(dict):
    """ Dict-Proxy for mapped objects providing attribute-style access.
    """

    def __getattribute__(self, name):
        if name in dict.keys(self):
            return self.get(name)
        return super(dict, self).__getattribute__(name) 

    def __getattr__(self, name, default=None):
        if name in dict.keys(self):
            return self.get(name, default)
        return super(dict, self).__getattr__(name, default) 

def ConnectorLists(url, username, password, list_id, NTLM=False):
    return Connector(url + "Lists.asmx?WSDL" if not "Lists.asmx" in url else url, username, password, list_id, NTLM=NTLM)
	
def ConnectorCopy(url, username, password, list_id, NTLM=False):
    return Connector(url + "copy.asmx?WSDL" if not "copy.asmx" in url else url, username, password, list_id, NTLM=NTLM,copy=True)
	
def Connector(url, username, password, list_id, NTLM=False, verbose=False, timeout=65, copy=False):
    """ Sharepoint SOAP connector factory """
    global factory

    if not "USER\\" in username:
        username = "USER\\" + username

    if factory is None:
        factory = Factory()
        LOG.info('Connecting to Sharepoint (%s, %s, %s)' % (url, username, list_id))

    if NTLM:
        transport = WindowsHttpAuthenticated(username=username, password=password, timeout=timeout)
    else:
        transport = HttpAuthenticated(username=username, password=password)
		
    if "copy.asmx" in url and not copy: copy = True

    if not "copy.asmx" in url or not "Lists.asmx" in url:
         url +=  "copy.asmx?WSDL" if copy else "Lists.asmx?WSDL"

    try:
        factory.set("url", url)
        factory.set("username", username)
        factory.set("password", password)
        factory.set("list_id", list_id)
        factory.set("NTLM", NTLM)
        factory.set("timeout", timeout)
        factory.set("copy", copy)
        factory.set("verbose", verbose)

        client = Client(url, transport=transport)
        #client.set_options(service='Lists', port='ListsSoap12')
        api = ListEndpoint(client, list_id, copy=copy)
        factory.set("instance", client)
	
        return api
        
    except Exception, e:
        # *try* to capture authentication related error.
        # Suds fails dealing with a 403 response from Sharepoint in addition
        # it is unable to deal with the error text returned from Sharepoint as
        # *HTML*.
        if '<unknown>' in str(e):
            raise OperationalError('Unknown bug encountered - *possibly* an authentication problem (%s)' % e)
        raise 

class ParsedSoapResult(object):
    """ Represent he result datastructure from sharepoint in a 
        mode Pythonic way. The ParsedSoapResult class exposes two attributes:
        ``ok`` - True if all operations completed successfully,
                  False otherwise
        ``result`` - a list of dicts containing the original SOAP
                  response ``code`` and ``text``
    """

    def __init__(self, results):
        self.raw_result = results
        self.ok = True
        self.result = list()
        rules = dict(
		      listitems={
			      1: "data" 
			  },
			  Attachments={
			      1: "Attachment",
		          "key": 1
			  },
			  Results={
			      1: "CopyResult",
				  2: "_Error"
			  }
		)
        if not "results" in dir(results):
             self.results = results

             for i in rules.keys():
                  if i in dir(self.results):
                       setattr(self, i, getattr(self.results, i))
					   
        else:
             # Stupid SOAP response are either returned as single 'Result'
             # instance or a list (depending on the number of list items touched
             # during one SOAP operation.
             if isinstance(results.Results.Result, (list, tuple)):
                results = [r for r in results.Results.Result]
             else:
                results = [results.Results.Result]
             for item_result in results:
                 d = dict(code=item_result.ErrorCode,
                     success=item_result.ErrorCode=='0x00000000')
                 for key in ('ErrorText', ):
                      value = getattr(item_result, key, _marker)
                 if value is not _marker:
                      d[key.lower()] = value

                 row = getattr(item_result, 'row', _marker)
                 if row is not _marker:
                    # should be serialized
                    d['row'] = item_result.row

                 self.result.append(d)
                 if item_result.ErrorCode != '0x00000000':
                     self.ok = False


class ListEndpoint(object):

    def __init__(self, client, list_id, copy=False):
        global factory
        self.iclient = client
        self.iservice = client.service
        self.client = client
        self.service = client.service
        self.list_id = list_id
        self.viewName = None
        self.factory = factory
        model = factory.model

        ## find the base given the list id and url
        self.base = str(re.sub('_vti.*', '', factory.client['url'])) + factory.client['list_id'] + '/'
        self.lbase = str(re.sub('_vti.*', '', factory.client['url'])) + 'Lists/' + factory.client['list_id'] + '/'
        # perform some introspection on the list

        if not factory.connected:
            if not copy:
                self.model = model['fields'] = self._getFields() 				
                self.required_fields = model['required_fields'] = self._required_fields()
                self.all_fields = model['keys'] =self.model.keys()
                self.primary_key = model['primary_key'] = self._find_primary_key()
            factory.model = model
            factory.connected = True
			
        else:
            if not 'fields' in model.keys() and not copy:
                self.model = model['fields'] = self._getFields() 
                self.required_fields = model['required_fields'] = self._required_fields()
                self.all_fields = model['keys'] = self.model.keys()
                self.primary_key = model['primary_keys'] = self._find_primary_key()
                self.model = model['fields']
                self.required_fields = model['required_fields']
                self.all_fields = model['keys']
            factory.model = model

        factory.model = model
        factory.connected = True
		
 
    def _perform(self, *args, **kwargs):
        self.factory.log_off()
        client = self.factory.get_client()
        fn = args[0]
        args = args[1:]
        if "parse" in kwargs.keys():
			parse = kwargs.pop("parse")
        else:
            parse = False
        try:
            res = ParsedSoapResult(getattr(client, fn)(*args, **kwargs))
        except:
            pass
        self.factory.log_on()
		
        return res if not res is None else False
     
    def _perform_once(self, *args):
        self.factory.log_off()
        result = getattr(self.client.service, args[0])(args[1:])
        self.factory.log_on()
		
        return result

    def _getFields(self):
        """ extract field list """
        list_ = self._perform_once("GetList", self.list_id)
        fields = dict()
        for row in list_.List.Fields.Field:
            if row._Name.startswith('_'):
                continue
            # dictify field description (chop of leading underscore)
            d = dict()
            for k, v in row.__dict__.items():
                if field_regex.match(k):
                    # chop of leading underscore
                    d[unicode(k[1:])] = v
            fields[row._Name] = d
        return fields

    def _find_primary_key(self):
        """ Return the name of the primary key field of the list """
        for k, field_d in self.model.items():
            if field_d.get('PrimaryKey') == u'TRUE':
                return k
        raise OperationalError('No primary key found in sharepoint list description')

    def _required_fields(self):
        """ Return the list of required field names in Sharepoint """
        return [d['Name'] 
                for d in self.model.values() 
                if d.get('Required') == 'TRUE']

    def _serializeListItem(self, item):
        """ Serialize a list item as dict """
        d = DictProxy()
        for fieldname in self.model:
            v = getattr(item, '_ows_' + fieldname, _marker)
            if v is _marker:
                v = None
            d[fieldname] = v 
        return d

    def _preflight(self, data, primary_key_check=True):
        """ Perform some sanity checks on data """

        # data must include the value of the primary key field            
        value_primary_key = data.get(self.primary_key)
        if primary_key_check and value_primary_key is None:
            raise ValueError('No value for primary key "%s" found in update dict (%s)' % (self.primary_key, data))

        data_keys = set(data.keys())
        all_fields = set(self.all_fields)
        if not data_keys.issubset(all_fields):
            disallowed = ', '.join(list(data_keys - all_fields))
            raise ValueError('Data dictionary contains fieldnames unknown to the Sharepoint list model (Disallowed field names: %s)' % disallowed)

    def setDefaultView(self, viewName):
        """ set the default viewName parameter """
        self.viewName = viewName

    def getItems(self, rowLimit=999999999, viewName=None):
        """ Return all list items without further filtering """
        items = self._perform("GetListItems", self.list_id, viewName=viewName or self.viewName, rowLimit=rowLimit) 
		
        if int(items.listitems.data._ItemCount) > 0:
            return [self._serializeListItem(item) for item in items.listitems.data.row]
        return []

    def getItem(self, item_id, viewName=None):
        """ Return all list items without further filtering """
        query0= Element('ns1:query')
        query = Element('Query')
        query0.append(query)
        where = Element('Where')
        query.append(where)
        eq = Element('Eq')
        where.append(eq)
        fieldref = Element('FieldRef').append(Attribute('Name', self.primary_key))
        value = Element('Value').append(Attribute('Type', 'Number')).setText(item_id)
        eq.append(fieldref)
        eq.append(value)
        viewfields = Element('ViewFields')
        viewfields.append(Element('FieldRef').append(Attribute('Name', self.primary_key)))
        queryOptions = Element('queryOptions')
        result = self._perform("GetListItems", self.list_id, 
                                          viewName=viewName or self.viewName, 
                                          query=query0,  
                                          viewFields=viewfields, 
                                          queryOptions=queryOptions, 
                                          rowLimit=1) 

        if int(result.listitems.data._ItemCount) > 0:
            return self._serializeListItem(result.listitems.data.row)
        return []

    def query(self, mode='exact', viewName=None, **kw):
        """ A generic query API. All list field names can be passed to query()
            together with the query values. All subqueries are combined using AND.
            All search criteria must perform an exact match. A better
            implementation of query() may support the 'Contains' or 'BeginsWith'
            query options (as given through CAML). The mode=exact ensures an exact
            match of all query parameter. mode=contains performs a substring search
            across *all* query parameters. mode=beginswith performs a prefix search
            across *all* query parameters.
        """

        if not mode in ('exact', 'contains', 'beginswith'):
            raise ValueError('"mode" must be either "exact", "beginswith" or "contains"')

        # map mode parameters to CAML query options
        query_modes = {'exact' : 'Eq', 'beginswith' : 'BeginsWith', 'contains' : 'Contains'}

        query0= Element('ns1:query')
        query = Element('Query')
        query0.append(query)
        where = Element('Where')
        query.append(where)

        if len (kw) > 1: # more than one query parameter requires <And>
            and_= Element('And')
            where.append(and_)
            where = and_

        # build query 
        for k, v in kw.items():
            if not k in self.all_fields:
                raise ValueError('List definition does not contain a field "%s"' % k)
            
            query_mode = Element(query_modes[mode])
            where.append(query_mode)
            fieldref = Element('FieldRef').append(Attribute('Name', k))
            value = Element('Value').append(Attribute('Type', self.model[k]['Type'])).setText(v)
            query_mode.append(fieldref)
            query_mode.append(value)

        viewfields = Element('ViewFields')
        viewfields.append(Element('FieldRef').append(Attribute('Name', self.primary_key)))
        queryOptions = Element('queryOptions')

        result = self._perform("GetListItems",self.list_id, 
                                          viewName=viewName or self.viewName, 
                                          query=query0,  
                                          viewFields=viewfields, 
                                          queryOptions=queryOptions, 
										  parse=False
                                          )
										  
        row_count = int(result.listitems.data._ItemCount)
        if row_count == 1:
            return [self._serializeListItem(result.listitems.data.row)]
        elif row_count > 1:
            return [self._serializeListItem(item) for item in result.listitems.data.row]
        else:
            return []

    def deleteItems(self, *item_ids):
        """ Remove list items given by value of their primary key """
        batch = Element('Batch')
        batch.append(Attribute('OnError','Return')).append(Attribute('ListVersion','1'))
        for i, item_id in enumerate(item_ids):
            method = Element('Method')
            method.append(Attribute('ID', str(i+1))).append(Attribute('Cmd', 'Delete'))
            method.append(Element('Field').append(Attribute('Name', self.primary_key)).setText(item_id))
            batch.append(method)
        updates = Element('ns0:updates')
        updates.append(batch)

        return self._perform("UpdateListItems", self.list_id, updates)
		
    """
	base64 encode an attachment
	then upload to a list item
	
    @param data
	"""
    def addAttachment(self, *args, **data):
        if len(args) >= 0 and isinstance(args[0], dict):
            data = args[0]
        if len(args) >= 0 and isinstance(args[0], str):
            data.update(dict(
			      listItemID=args[0],
				  fileName=args[1],
				  file=args[2]
			).copy())

        if not 'raw' in data.keys(): data['raw'] = False
        if not 'overwrite' in data.keys(): data['overwrite'] = True

        if data['raw']:
           file = data['contents']
        else:
           file = base64.b64encode(open(os.path.abspath(data['file']), 'rb').read())

        if data['overwrite']:
           """ 
		      delete an existing attachment 
		      only attempt as we do not want to bother a attachment upload
		   """
         
           try:
                self.deleteAttachment("{0}Attachments/{1}/{2}".format(self.lbase,data['listItemID'],data['fileName']))
           except:
			    pass
        return self._perform("AddAttachment", self.list_id, fileName=data['fileName'], listItemID=data['listItemID'], attachment=file)
	
	"""
    get an attachment.
	needs list item id

    @param data
	"""
    def getAttachments(self, id):	
        results = self._perform("GetAttachmentCollection", self.list_id, listItemID=id)
        results.results = []
  
   
        for i in results.Attachments:
             results.results.append(i[1][0])
		
        return results
		
    """ 
    deletes any attachments
    needs the attachment as
    first parameter
    """
    def deleteAttachment(self, url, id=None):
        if id is None:
             m = re.findall("Attachments\/(\d+)\/", url)
             if len(m) >= 0: id = m[0]
        else:
             m = re.findall("http://", url)
             if not len(m) >= 0: ## file
	            url = "{0}Attachments/{1}/{2}".format(self.lbase,id,data['fileName'])

        self._perform("DeleteAttachment", self.list_id, listItemID=id, url=url)

    def deleteAttachments(self, urls):
        for i in urls:
             self.deleteAttachment(i)

    """
    uploads a new file
    to a document
    """
    def upload(self,*args,**data):
        if len(args) >= 0 and isinstance(args[0], dict):
            data = args[0]
        if len(args) >= 0 and isinstance(args[0], str):
            data.update(dict(
			      destinationUrl=args[0],
				  file=args[1]
			).copy())
			
        if not 'raw' in data.keys(): data['raw'] = False
		
        """ to hack for a overwrite, we have to set the source url base as the filename """
        """ see: http://sharepoint.stackexchange.com/questions/39982/overwrite-sharepoint-document-using-copyintoitems-service-of-copy-asmx """
	
        if not 'meta' in data.keys():
           data['meta'] = dict()
        if not 'overwrite' in data.keys():
           data['overwrite'] = False
           
        if data['overwrite']:
	       data['sourceUrl'] = data['destinationUrl']
        else:
		   data['sourceUrl'] = self.base + data['destinationUrl']
		   
        if data['raw']:
           f = data['f']
        else:
           f = base64.b64encode(open(os.path.abspath(data['file']), 'rb').read())

        if not len(re.findall('http', data['destinationUrl'])) > 0:
               data['destinationUrl'] = self.base + data['destinationUrl']

        du = Element('DestinationUrls')
        du.append(Element('string').setText(data['destinationUrl']))

        fit_m = Element('Fields')
        for k,v in data['fields'].iteritems():
            fit = Element('FieldInformation')
            bool_type = False
				
            """
                <FieldInformation Type="Invalid or Integer or Text or Note or DateTime or Counter or Choice or Lookup or Boolean or Number or Currency or URL or Computed or Threading or Guid or MultiChoice or GridChoice or Calculated or File or Attachments or User or Recurrence or CrossProjectLink or ModStat or AllDayEvent or Error" DisplayName="string" InternalName="string" Id="guid" Value="string" />
            """
            if k in data['meta'].keys():
                if data['meta'][k] == 'Boolean':
                     bool_type = True
					
                fit.append(Attribute('Type', data['meta'][k]))

            else:
                if isinstance(v, bool):
                      fit.append(Attribute('Type', 'Boolean'))				
                elif isinstance(v, float) or isinstance(v, int):
                      fit.append(Attribute('Type', 'Number'))  

                else:					
                      fit.append(Attribute('Type', 'Text'))

               
            if isinstance(v, bool):
                v = 'true' if v else 'false'
            if bool_type:
                """ accept either Yes, No, 0, 1, true, false """
                if v in ['Yes', 1]:
                      v = 'true'
                elif v in ['No', 0]:
                      v = 'false'
					  
            if isinstance(v, list):
                choices = Element('choices')
                 
                for i in v:
                     if isinstance(i, tuple):
                         default = Element('default').setText(i[1])
                     else:
			 choice = Element('choice').setText(i)
			 choices.append(choice)
						 
                fit.append(choices)
   
            """ make sure attribute newlines are escaped with CLRF """
            if isinstance(v, str):
                v = re.sub(r'\n|<br\/>|\r\n', '&#13;&#10;', v)
                v = re.sub("\n", '&#13;&#10;', v)
                v = unicode(v, errors='ignore')
         
            fit.append(Attribute('InternalName', v))
            fit.append(Attribute('DisplayName', unicode(k, errors='ignore')))
            #fit.append(Attribute('FillInChoice', 'TRUE'))
            fit.append(Attribute('Value', v))
            #fit.setText(v)
            fit_m.append(fit)

        result = self._perform("CopyIntoItems",
        SourceUrl=data['sourceUrl'], 
        DestinationUrls=du, 
        Fields=fit_m,
        Stream=f)
        result.url = result.Results.CopyResult[0]._DestinationUrl
		
        return result


    """
	get an updload with
	its fields
	"""
    def getUpload(self, url):	
        if not len(re.findall('http', data['url'])) > 0:
               url = self.base + url
			 
        return self._perform("GetItem", self.list_id, Url=url)

    def updateItems(self, *update_items):
        """ Update list items as given through a list of update_item dicts
            holding the data to be updated. The list items are identified
            through the value of the primary key inside the update dict.
        """
        batch = Element('Batch')
        batch.append(Attribute('OnError','Return')).append(Attribute('ListVersion','1'))
        for i, d in enumerate(update_items):
            self._preflight(d)
            method = Element('Method')
            method.append(Attribute('ID', str(i+1))).append(Attribute('Cmd', 'Update'))
            for k,v in d.items():
                method.append(Element('Field').append(Attribute('Name', k)).setText(v))
            batch.append(method)
        updates = Element('ns0:updates')
        updates.append(batch)

        return self._perform("UpdateListItems", self.list_id, updates, parse=True)


    def addItems(self, *addable_items):
        """ Add a sequence of items to the list. All items must be passed as dict.
            The list of assigned primary key values should from the 'row' values of 
            the result object.
        """
        batch = Element('Batch')
        batch.append(Attribute('OnError','Return')).append(Attribute('ListVersion','1'))
        for i, d in enumerate(addable_items):
            method = Element('Method')
            method.append(Attribute('ID', str(i+1))).append(Attribute('Cmd', 'New'))
            for k,v in d.items():
                method.append(Element('Field').append(Attribute('Name', k)).setText(v))
            batch.append(method)
        updates = Element('updates')
        updates.append(batch)

        return self._perform("UpdateListItems", self.list_id, updates)

    def checkout_file(self, pageUrl, checkoutToLocal=False):
        """ Checkout a file """
        return self._perform("CheckOutFile", pageUrl, checkoutToLocal)

    def checkin_file(self, pageUrl, comment=''):
        return self._perform("CheckInFile", pageUrl, comment)

