import sys
import os
from suds.client import Client
from suds.sax.element import Element
from suds.sax.attribute import Attribute
from suds.transport.https import WindowsHttpAuthenticated
from suds.transport.http import HttpAuthenticated
from logger import logger as LOG
import haufe.sharepoint
import patches

class Factory(object):
    def __init__(self):
        self.verbose = False
        self.stdout = False
        self.NTLM = False
        self.timeout = 10
        self.connected = False
        self.client = dict()
        self.model = dict()
        self.instance = None
    def client_option(self,option):
        return self.client[option]
		
    def generate(self):
        if not self.NTLM:
			return haufe.sharepoint.Connector(self.client['url'],self.client['username'],self.client['password'],self.client['list_id'],self.NTLM,self.verbose,self.timeout)
        return self.instance

    def get_instance(self):
        return self.generate()
	
    def get_client(self):
        factory = self.get_instance()
        return factory.client.service

    def get_model(self):
        return self.model
		
    def log_on(self):
        if self.verbose:return

        sys.stdout = self.stdout

    def log_off(self):
         if self.verbose:return

         self.stdout = sys.stdout
         sys.stdout = open(os.devnull, 'wb')	
        
    def set(self, option, val):
        if not option in ('verbose', 'model', 'NTLM', 'timeout', 'instance'):
		    self.client[option] = val
        else:
		    setattr(self, option, val)

    def set_model(self, dict):
        self.model = dict

    def set_client(self, dict):
        self.client = dict

    def set_verbose(self, bool):
        self.verbose = bool