# coding=UTF-8
import os
from haufe.sharepoint import Connector

""" All tests are using NTLM. If you need NTLM support, please add the NTLM """
""" flag in the connector. These tests are for both Lists.asmx and Copy.asmx and """
""" will give you a rough idea of how to use this library """


url = ''
username = ''
password = ''
list_id = ''
item_id = ''

if username == 'username_here' or password == 'password_here':
	print "Please set your username, password and list ids to use tests, exiting.."
	exit(1)

service = Connector(url, username, password, list_id, NTLM=False)

print "Testing for Sharepoint Lists.asmx: Attachments"
print "Connecting to: {0}".format(list_id)

## adds an attachment
filename = 'example-document.png'
file = os.path.abspath("./unit/files/{0}".format(filename))
print "Uploading new attachment for item: %s, filename: %s" % (item_id, filename)
result = service.addAttachment(item_id, "file__.png", file, overwrite=True)

## get all the attachments 
## for this item
print "Getting all the attachments for item: %s" % item_id
result = service.getAttachments(item_id)
print "List of attachments: \n%s" % (",".join(result.results))
## deletes all the items
## attachments
service.deleteAttachments(result.results)

print "Deleting all attachments for: %s" %  item_id
print "Status of delete: %s" % (result.ok)